/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io.importFormats;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.CombinationFileFilter;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.importFormats.ImportFormat;
import CH.ifa.draw.io.importFormats.ImportFormatAbstract;
import CH.ifa.draw.io.importFormats.ImportFormatMulti;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public abstract class ImportFormatMultiAbstract
extends ImportFormatAbstract
implements ImportFormatMulti {
    private List<ImportFormat> _formats;

    public ImportFormatMultiAbstract(String string, String string2) {
        super(string, new CombinationFileFilter(string2));
        this.setFormats(new LinkedList<ImportFormat>());
    }

    protected List<ImportFormat> formats() {
        List<ImportFormat> list = null;
        list = this._formats;
        assert (list != null) : "Failure in ImportFormatAbstract: result == null";
        return list;
    }

    protected void setFormats(List<ImportFormat> list) {
        this._formats = list;
        assert (this.formats() != null) : "Failure in ImportFormatAbstract: formats() == null";
        assert (this.formats().equals(list)) : "Failure in ImportFormatAbstract: formats() != formats";
    }

    protected CombinationFileFilter comFileFilter() {
        CombinationFileFilter combinationFileFilter = null;
        combinationFileFilter = (CombinationFileFilter)this.fileFilter();
        assert (combinationFileFilter != null) : "Failure in ImportFormatAbstract: result == null";
        return combinationFileFilter;
    }

    protected void addFileFilter(FileFilter fileFilter) {
        if (fileFilter instanceof CombinationFileFilter) {
            CombinationFileFilter combinationFileFilter = (CombinationFileFilter)fileFilter;
            for (FileFilter fileFilter2 : combinationFileFilter.getFileFilters()) {
                this.addFileFilter(fileFilter2);
            }
        } else if (fileFilter instanceof SimpleFileFilter) {
            this.comFileFilter().add((SimpleFileFilter)fileFilter);
        }
    }

    protected void removeFileFilter(FileFilter fileFilter) {
        if (fileFilter instanceof CombinationFileFilter) {
            CombinationFileFilter combinationFileFilter = (CombinationFileFilter)fileFilter;
            for (FileFilter fileFilter2 : combinationFileFilter.getFileFilters()) {
                this.removeFileFilter(fileFilter2);
            }
        } else if (fileFilter instanceof SimpleFileFilter) {
            this.comFileFilter().remove((SimpleFileFilter)fileFilter);
        }
    }

    @Override
    public void addImportFormat(ImportFormat importFormat) {
        this.formats().add(importFormat);
        FileFilter fileFilter = importFormat.fileFilter();
        this.addFileFilter(fileFilter);
    }

    @Override
    public ImportFormat[] allImportFormats() {
        ImportFormat[] importFormatArray = null;
        importFormatArray = new ImportFormat[this.formats().size()];
        for (int i = 0; i < importFormatArray.length; ++i) {
            importFormatArray[i] = this.formats().get(i);
        }
        assert (importFormatArray != null) : "Failure in ImportFormatAbstract: result == null";
        return importFormatArray;
    }

    @Override
    public void removeImportFormat(ImportFormat importFormat) {
        this.removeFileFilter(importFormat.fileFilter());
        this.formats().remove(importFormat);
    }

    @Override
    public Drawing[] importFiles(URL[] uRLArray) throws Exception {
        int n;
        Drawing[] drawingArray = null;
        Vector<Drawing> vector = new Vector<Drawing>();
        for (n = 0; n < uRLArray.length; ++n) {
            ImportFormat[] importFormatArray = this.allImportFormats();
            for (int i = 0; i < importFormatArray.length; ++i) {
                if (!importFormatArray[i].canImport(uRLArray[n])) continue;
                URL[] uRLArray2 = new URL[]{uRLArray[n]};
                Drawing[] drawingArray2 = importFormatArray[i].importFiles(uRLArray2);
                for (int j = 0; j < drawingArray2.length; ++j) {
                    vector.add(drawingArray2[j]);
                }
            }
        }
        drawingArray = new Drawing[vector.size()];
        for (n = 0; n < drawingArray.length; ++n) {
            drawingArray[n] = (Drawing)vector.get(n);
        }
        assert (drawingArray != null) : "Failure in ImportFormatAbstract: result == null";
        return drawingArray;
    }
}

