/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.UndoableCommand;
import java.awt.Rectangle;

public class AlignCommand
extends UndoableCommand {
    public static final int LEFTS = 0;
    public static final int CENTERS = 1;
    public static final int RIGHTS = 2;
    public static final int TOPS = 3;
    public static final int MIDDLES = 4;
    public static final int BOTTOMS = 5;
    private int fOp;

    public AlignCommand(String string, int n) {
        super(string);
        this.fOp = n;
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 1;
    }

    @Override
    public boolean executeUndoable() {
        if (this.isExecutable()) {
            if (!super.isExecutable()) {
                return false;
            }
            DrawingView drawingView = this.getEditor().view();
            FigureEnumeration figureEnumeration = drawingView.selectionElements();
            Figure figure = figureEnumeration.nextFigure();
            Rectangle rectangle = figure.displayBox();
            while (figureEnumeration.hasMoreElements()) {
                Figure figure2 = figureEnumeration.nextFigure();
                Rectangle rectangle2 = figure2.displayBox();
                switch (this.fOp) {
                    case 0: {
                        figure2.moveBy(rectangle.x - rectangle2.x, 0);
                        break;
                    }
                    case 1: {
                        figure2.moveBy(rectangle.x + rectangle.width / 2 - (rectangle2.x + rectangle2.width / 2), 0);
                        break;
                    }
                    case 2: {
                        figure2.moveBy(rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), 0);
                        break;
                    }
                    case 3: {
                        figure2.moveBy(0, rectangle.y - rectangle2.y);
                        break;
                    }
                    case 4: {
                        figure2.moveBy(0, rectangle.y + rectangle.height / 2 - (rectangle2.y + rectangle2.height / 2));
                        break;
                    }
                    case 5: {
                        figure2.moveBy(0, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                    }
                }
            }
            drawingView.checkDamage();
            return true;
        }
        return false;
    }
}

