/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.DragTracker;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.apache.log4j.Logger;

public class ChildDragTracker
extends DragTracker {
    public static Logger logger = Logger.getLogger(ChildDragTracker.class);
    private boolean doTracking = false;
    private boolean startTracking = false;
    private Point startPoint;
    private Figure lastFigure = null;
    private ParentFigure oldParent;
    private ParentFigure newParent = null;

    public ChildDragTracker(DrawingEditor drawingEditor, ChildFigure childFigure) {
        super(drawingEditor, childFigure);
        this.startPoint = childFigure.center();
        this.oldParent = childFigure.parent();
    }

    @Override
    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDown(mouseEvent, n, n2);
        this.startTracking = this.doTracking = this.fAnchorFigure != null && this.fAnchorFigure instanceof ChildFigure && this.view().selectionCount() == 1;
    }

    @Override
    protected void drag(int n, int n2) {
        if (this.doTracking) {
            if (this.startTracking && (n != 0 || n2 != 0)) {
                this.fEditor.drawing().bringToFront(this.fAnchorFigure);
                this.startTracking = false;
            }
            this.fAnchorFigure.moveBy(n, n2);
        } else {
            super.drag(n, n2);
        }
    }

    private void findNewParent(int n, int n2) {
        Figure figure = this.drawing().findFigureWithout(n, n2, this.fAnchorFigure);
        if (figure != this.lastFigure) {
            this.lastFigure = figure;
            if (figure instanceof ParentFigure && ((ChildFigure)this.fAnchorFigure).parent() != figure && ((ChildFigure)this.fAnchorFigure).canBeParent((ParentFigure)figure)) {
                this.newParent = (ParentFigure)figure;
                this.view().clearSelection();
                this.view().addToSelection(this.newParent);
            } else if (this.newParent != null && this.oldParent != null) {
                this.view().clearSelection();
                this.view().addToSelection(this.oldParent);
                this.newParent = null;
            }
        }
    }

    @Override
    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDrag(mouseEvent, n, n2);
        if (this.doTracking) {
            this.findNewParent(n, n2);
        }
    }

    @Override
    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        Point point;
        super.mouseUp(mouseEvent, n, n2);
        if (this.doTracking && this.fAnchorFigure != null && !this.startPoint.equals(point = this.fAnchorFigure.center())) {
            this.findNewParent(n, n2);
            if (this.newParent != null) {
                logger.debug((Object)("New Parent " + this.newParent + "!"));
                this.fAnchorFigure.moveBy(this.startPoint.x - point.x, this.startPoint.y - point.y);
                ((ChildFigure)this.fAnchorFigure).setParent(this.newParent);
            }
        }
    }
}

