/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.NullDrawingEditor;
import CH.ifa.draw.util.Command;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class ChooseAttributeCommand
extends Command {
    static final String WINDOWS_CATEGORY_ATTRIBUTES = "Attributes";
    protected JFrame lastParent;
    protected JDialog dialog;
    protected String fAttribute;
    protected Class<?> type;
    protected String displayName;

    public ChooseAttributeCommand(String string, String string2, String string3, Class<?> clazz) {
        super(string2);
        this.fAttribute = string3;
        this.displayName = string;
        this.type = clazz;
    }

    protected void createDialog() {
        JFrame jFrame = DrawPlugin.getGui().getFrame();
        if (this.dialog != null) {
            if (this.lastParent == jFrame) {
                return;
            }
            this.dialog.dispose();
        }
        this.dialog = new JDialog((Frame)jFrame, "Change " + this.displayName + ":");
        this.lastParent = jFrame;
        JButton jButton = new JButton(" Apply ");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChooseAttributeCommand.this.apply();
            }
        });
        JButton jButton2 = new JButton(" Update ");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChooseAttributeCommand.this.updateFromFigure();
            }
        });
        JButton jButton3 = new JButton(" OK ");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChooseAttributeCommand.this.apply();
                ChooseAttributeCommand.closeDialog(ChooseAttributeCommand.this.dialog);
            }
        });
        JButton jButton4 = new JButton(" Cancel ");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChooseAttributeCommand.closeDialog(ChooseAttributeCommand.this.dialog);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jPanel.add(jButton4);
        this.dialog.getContentPane().add((Component)jPanel, "South");
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ChooseAttributeCommand.closeDialog(ChooseAttributeCommand.this.dialog);
            }
        });
        this.specializeDialog();
    }

    protected abstract void specializeDialog();

    protected abstract void updateFromFigure();

    protected abstract void apply();

    @Override
    public void execute() {
        this.createDialog();
        this.updateFromFigure();
        this.dialog.setVisible(true);
        MenuManager.getInstance().getWindowsMenu().addDialog(WINDOWS_CATEGORY_ATTRIBUTES, this.dialog);
    }

    protected DrawingEditor getEditor() {
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        return drawPlugin == null ? NullDrawingEditor.INSTANCE : drawPlugin.getDrawingEditor();
    }

    @Override
    public boolean isExecutable() {
        if (this.getEditor() == NullDrawingEditor.INSTANCE) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 0;
    }

    protected static void closeDialog(JDialog jDialog) {
        MenuManager.getInstance().getWindowsMenu().removeDialog(jDialog);
        jDialog.setVisible(false);
    }
}

