/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.standard.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class InfoDialog
extends JDialog {
    private Logger logger = Logger.getLogger(InfoDialog.class);
    protected JButton button;
    protected MultiLineLabel label;

    public InfoDialog(JFrame jFrame, String string, String string2) {
        super(jFrame, string, true);
        this.getContentPane().setLayout(new BorderLayout(15, 15));
        this.label = new MultiLineLabel(string2, 20, 20);
        this.getContentPane().add("Center", this.label);
        this.button = new JButton("OK");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InfoDialog.this.dispose();
            }
        };
        this.button.addActionListener(actionListener);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 15, 15));
        jPanel.add(this.button);
        this.getContentPane().add("South", jPanel);
        this.pack();
    }

    public InfoDialog(JFrame jFrame, String string, String string2, boolean bl) {
        super(jFrame, string, true);
        try {
            this.getContentPane().setLayout(new BorderLayout(15, 15));
            JLabel jLabel = new JLabel("<html>" + string2 + "</html>");
            jLabel.setOpaque(true);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 25, 10, 25));
            jPanel.add(jLabel);
            jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            jPanel = this.createLinkLabel(jPanel, "http://www.renew.de", false);
            if (bl) {
                jPanel = this.createLinkLabel(jPanel, "http://www.paose.net", false);
            }
            jPanel = this.createLinkLabel(jPanel, "mailto:support@renew.de", true);
            this.getContentPane().add("Center", jPanel);
            this.button = new JButton("OK");
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    InfoDialog.this.dispose();
                }
            };
            this.button.addActionListener(actionListener);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(1, 15, 15));
            jPanel2.add(this.button);
            this.getContentPane().add("South", jPanel2);
            this.pack();
        }
        catch (Exception exception) {
            this.logger.error((Object)("InfoDialog " + exception));
        }
    }

    private JPanel createLinkLabel(JPanel jPanel, String string, final boolean bl) {
        String string2;
        String string3;
        if (bl) {
            if (string.startsWith("mailto:")) {
                string3 = string.replaceFirst("mailto:", "");
                string2 = string;
            } else {
                string3 = string;
                string2 = "mailto:" + string;
            }
        } else {
            string3 = string;
            string2 = string;
        }
        JLabel jLabel = new JLabel("<html><a href=\"" + string2 + "\">" + string3 + "</a></html>");
        jLabel.setCursor(new Cursor(12));
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 0) {
                    InfoDialog.this.openURL(string2, bl);
                }
            }
        });
        jPanel.add(jLabel);
        return jPanel;
    }

    private void openURL(String string, boolean bl) {
        block4: {
            try {
                Desktop desktop = Desktop.getDesktop();
                URI uRI = URI.create(string);
                if (bl) {
                    desktop.mail(uRI);
                } else {
                    desktop.browse(uRI);
                }
            }
            catch (IOException iOException) {
                this.logger.error((Object)(InfoDialog.class.getSimpleName() + ": could not open link " + string + "."));
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.debug((Object)(InfoDialog.class.getSimpleName() + ": " + iOException));
            }
        }
    }
}

