/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.ChooseAttributeCommand;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class QueryAttributeCommand
extends ChooseAttributeCommand {
    JTextField input;
    public static Logger logger = Logger.getLogger(QueryAttributeCommand.class);

    public QueryAttributeCommand(String string, String string2, String string3, Class<?> clazz) {
        super(string, string2, string3, clazz);
    }

    @Override
    protected void specializeDialog() {
        this.input = new JTextField();
        this.dialog.getContentPane().add((Component)this.input, "Center");
        this.input.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    QueryAttributeCommand.this.apply();
                } else if (keyEvent.getKeyCode() == 27) {
                    ChooseAttributeCommand.closeDialog(QueryAttributeCommand.this.dialog);
                }
            }
        });
        this.dialog.pack();
    }

    @Override
    protected void updateFromFigure() {
        Object object;
        DrawingView drawingView = this.getEditor().view();
        Object object2 = null;
        FigureEnumeration figureEnumeration = drawingView.selectionElements();
        while (figureEnumeration.hasMoreElements()) {
            object = figureEnumeration.nextFigure();
            Object object3 = object.getAttribute(this.fAttribute);
            if (object3 == null) continue;
            if (object2 != null && !object2.equals(object3)) {
                object2 = null;
                break;
            }
            object2 = object3;
        }
        object = "";
        if (object2 != null) {
            object = object2.toString();
        }
        this.input.setText((String)object);
        this.resetFocus();
    }

    private void resetFocus() {
        this.input.requestFocus();
        this.input.setSelectionStart(0);
        this.input.setSelectionEnd(this.input.getText().length());
    }

    @Override
    protected void apply() {
        Object object;
        block8: {
            String string = this.input.getText();
            object = null;
            try {
                if (this.type == Integer.class) {
                    object = Integer.valueOf(string);
                } else if (this.type == String.class) {
                    if (this.fAttribute.equals("LineStyle") && (string.startsWith("0") || !string.matches("(\\d+( \\d+)*)?"))) {
                        logger.error((Object)("In the '" + this.displayName + "' dialog only numbers separated by a dash or a gap are allowed. " + "String should not start with 0 (zero)."));
                    } else {
                        object = string;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.error((Object)numberFormatException.getMessage());
                if (!logger.isDebugEnabled()) break block8;
                logger.debug((Object)(QueryAttributeCommand.class.getSimpleName() + ": \n" + numberFormatException));
            }
        }
        if (object != null) {
            new ChangeAttributeCommand("", this.fAttribute, object).execute();
        }
        this.resetFocus();
    }
}

