/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.ChildDragTracker;
import CH.ifa.draw.standard.DragTracker;
import CH.ifa.draw.standard.HandleTracker;
import CH.ifa.draw.standard.SelectAreaTracker;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import org.apache.log4j.Logger;

public class SelectionTool
extends AbstractTool {
    public static Logger logger = Logger.getLogger(SelectionTool.class);
    private Tool fChild = null;
    private Tool fLastChild = null;
    private DrawingView fFreezedView = null;

    public SelectionTool(DrawingEditor drawingEditor) {
        super(drawingEditor);
    }

    @Override
    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        if (this.fChild != null) {
            return;
        }
        try {
            boolean bl;
            boolean bl2 = bl = (mouseEvent.getModifiers() & 0xC) != 0;
            if (this.fLastChild != null && mouseEvent.getClickCount() == 2 && !bl) {
                this.fChild = this.fLastChild;
                this.fLastChild = null;
            } else {
                if (this.fFreezedView == null) {
                    this.fFreezedView = this.view();
                    this.fFreezedView.freezeView();
                }
                Handle handle = null;
                if (!bl && this.view().selectionCount() == 1) {
                    handle = this.view().findHandle(mouseEvent.getX(), mouseEvent.getY());
                }
                if (handle != null) {
                    this.fLastChild = this.fChild = this.createHandleTracker(this.fEditor, handle);
                } else {
                    this.fLastChild = null;
                    Figure figure = this.drawing().findFigure(mouseEvent.getX(), mouseEvent.getY());
                    if (figure == null && (handle = this.view().findHandle(mouseEvent.getX(), mouseEvent.getY())) != null) {
                        figure = handle.owner();
                    }
                    if (figure != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Click-on-figure: " + figure));
                        }
                        if (mouseEvent.getClickCount() >= 2 && !bl) {
                            figure.inspect(this.view(), false);
                            return;
                        }
                        if (bl && this.alternateInspectFigure(figure)) {
                            return;
                        }
                        this.fChild = this.createDragTracker(this.fEditor, figure);
                    } else {
                        if (!mouseEvent.isShiftDown()) {
                            this.view().clearSelection();
                        }
                        this.fChild = this.createAreaTracker(this.fEditor);
                    }
                }
            }
            this.fChild.mouseDown(mouseEvent, n, n2);
        }
        catch (RuntimeException runtimeException) {
            if (this.fFreezedView != null) {
                this.fFreezedView.unfreezeView();
                this.fFreezedView = null;
            }
            throw runtimeException;
        }
        catch (Error error) {
            if (this.fFreezedView != null) {
                this.fFreezedView.unfreezeView();
                this.fFreezedView = null;
            }
            throw error;
        }
    }

    @Override
    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        if (this.fChild != null) {
            this.fChild.mouseDrag(mouseEvent, n, n2);
            this.fLastChild = null;
        }
    }

    @Override
    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        if (this.fFreezedView != null) {
            this.fFreezedView.unfreezeView();
            this.fFreezedView = null;
        }
        if (this.fChild != null) {
            this.fChild.mouseUp(mouseEvent, n, n2);
        }
        this.fChild = null;
    }

    protected Tool createHandleTracker(DrawingEditor drawingEditor, Handle handle) {
        return new HandleTracker(drawingEditor, handle);
    }

    protected Tool createDragTracker(DrawingEditor drawingEditor, Figure figure) {
        if (figure instanceof ChildFigure) {
            return new ChildDragTracker(drawingEditor, (ChildFigure)figure);
        }
        return new DragTracker(drawingEditor, figure);
    }

    protected Tool createAreaTracker(DrawingEditor drawingEditor) {
        return new SelectAreaTracker(drawingEditor);
    }

    protected boolean alternateInspectFigure(Figure figure) {
        return figure.inspect(this.view(), true);
    }

    @Override
    public void draw(Graphics graphics) {
        if (this.fChild != null) {
            this.fChild.draw(graphics);
        }
    }

    @Override
    public void deactivate() {
        if (this.fFreezedView != null) {
            this.fFreezedView.unfreezeView();
            this.fFreezedView = null;
        }
        super.deactivate();
    }
}

