/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.PointConstrainer;
import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.standard.GridConstrainer;
import java.awt.Point;

public class SnapToGridCommand
extends UndoableCommand {
    private Point fGrid;

    public SnapToGridCommand(String string, Point point) {
        super(string);
        this.fGrid = new Point(point.x, point.y);
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 0;
    }

    @Override
    public boolean executeUndoable() {
        Object object;
        DrawingView drawingView = this.getEditor().view();
        PointConstrainer pointConstrainer = drawingView.getConstrainer();
        if (pointConstrainer == null) {
            object = DrawPlugin.getCurrent();
            if (object != null) {
                object.showStatus("No active grid - using default grid.");
            }
            pointConstrainer = new GridConstrainer(this.fGrid.x, this.fGrid.y);
        }
        object = drawingView.selectionElements();
        while (object.hasMoreElements()) {
            Figure figure = object.nextFigure();
            Point point = figure.center();
            Point point2 = pointConstrainer.constrainPoint(figure.center());
            figure.moveBy(point2.x - point.x, point2.y - point.y);
        }
        drawingView.checkDamage();
        return true;
    }
}

