/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingChangeListener;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FilterContainer;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.io.IFAFileFilter;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.util.Lock;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import org.apache.log4j.Logger;

public class StandardDrawing
extends CompositeFigure
implements Drawing {
    public static Logger logger = Logger.getLogger(StandardDrawing.class);
    private static FilterContainer filterContainer;
    static String fgUntitled;
    private static final long serialVersionUID = -2602151437447962046L;
    private transient Vector<DrawingChangeListener> fListeners;
    private transient Lock fLock;
    private String fDrawingName = fgUntitled;
    private transient File fDrawingFilename = null;
    private transient boolean modified = false;
    private transient boolean fBackupStatus = false;
    private int drawingSerializedDataVersion = 1;

    public StandardDrawing() {
        this.fListeners = new Vector(2);
        this.fLock = new Lock();
    }

    @Override
    public String getName() {
        return this.fDrawingName;
    }

    @Override
    public void setName(String string) {
        this.fDrawingName = string;
    }

    public Dimension getSize() {
        return new Dimension(this.getBounds().width, this.getBounds().height);
    }

    @Override
    public File getFilename() {
        return this.fDrawingFilename;
    }

    @Override
    public void setFilename(File file) {
        this.fDrawingFilename = file;
    }

    @Override
    public boolean getBackupStatus() {
        return this.fBackupStatus;
    }

    @Override
    public void setBackupStatus(boolean bl) {
        this.fBackupStatus = bl;
    }

    @Override
    public void addDrawingChangeListener(DrawingChangeListener drawingChangeListener) {
        this.fListeners.addElement(drawingChangeListener);
    }

    @Override
    public void removeDrawingChangeListener(DrawingChangeListener drawingChangeListener) {
        this.fListeners.removeElement(drawingChangeListener);
    }

    @Override
    public Enumeration<DrawingChangeListener> drawingChangeListeners() {
        return this.fListeners.elements();
    }

    @Override
    public Figure remove(Figure figure) {
        if (figure.listener() != null) {
            figure.listener().figureRequestRemove(new FigureChangeEvent(figure, null));
            return figure;
        }
        return null;
    }

    @Override
    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
        Figure figure = figureChangeEvent.getFigure();
        if (this.fFigures.contains(figure)) {
            this.modified = true;
            this.fFigures.removeElement(figure);
            figure.removeFromContainer(this);
            figure.release();
        } else {
            logger.error((Object)"Attempt to remove non-existing figure");
        }
    }

    @Override
    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
        this.modified = true;
        if (this.fListeners != null) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                DrawingChangeListener drawingChangeListener = this.fListeners.elementAt(i);
                drawingChangeListener.drawingInvalidated(new DrawingChangeEvent(this, figureChangeEvent.getInvalidatedRectangle()));
            }
        }
    }

    @Override
    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
        if (this.fListeners != null) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                DrawingChangeListener drawingChangeListener = this.fListeners.elementAt(i);
                drawingChangeListener.drawingRequestUpdate(new DrawingChangeEvent(this, null));
            }
        }
    }

    @Override
    public synchronized void checkDamage() {
        final StandardDrawing standardDrawing = this;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Enumeration enumeration = StandardDrawing.this.fListeners.elements();
                while (enumeration.hasMoreElements()) {
                    DrawingChangeListener drawingChangeListener = (DrawingChangeListener)enumeration.nextElement();
                    drawingChangeListener.drawingRequestUpdate(new DrawingChangeEvent(standardDrawing, null));
                }
            }
        });
    }

    @Override
    public Vector<Handle> handles() {
        Vector<Handle> vector = new Vector<Handle>();
        vector.addElement(new NullHandle(this, RelativeLocator.northWest()));
        vector.addElement(new NullHandle(this, RelativeLocator.northEast()));
        vector.addElement(new NullHandle(this, RelativeLocator.southWest()));
        vector.addElement(new NullHandle(this, RelativeLocator.southEast()));
        return vector;
    }

    @Override
    public Rectangle displayBox() {
        Rectangle rectangle = null;
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (!figure.isVisible()) continue;
            Rectangle rectangle2 = figure.displayBox();
            if (rectangle == null) {
                rectangle = rectangle2;
                continue;
            }
            rectangle.add(rectangle2);
        }
        if (rectangle == null) {
            return new Rectangle(0, 0, 100, 100);
        }
        return new Rectangle(rectangle.x - 10, rectangle.y - 10, rectangle.width + 20, rectangle.height + 20);
    }

    @Override
    public void basicDisplayBox(Point point, Point point2) {
    }

    @Override
    public void lock() {
        this.fLock.lock();
    }

    @Override
    public void unlock() {
        this.fLock.unlock();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.fListeners = new Vector(2);
        this.fLock = new Lock();
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void clearModified() {
        this.modified = false;
    }

    @Override
    public Rectangle getBounds() {
        return this.displayBox();
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(430, 406);
    }

    @Override
    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
    }

    @Override
    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.modified = false;
    }

    @Override
    public String getWindowCategory() {
        return "JHotDrawings";
    }

    public static FilterContainer getFilterContainer() {
        if (filterContainer == null) {
            return new FilterContainer(new IFAFileFilter());
        }
        return filterContainer;
    }

    @Override
    public SimpleFileFilter getDefaultFileFilter() {
        return StandardDrawing.getFilterContainer().getDefaultFileFilter();
    }

    @Override
    public HashSet<SimpleFileFilter> getImportFileFilters() {
        return StandardDrawing.getFilterContainer().getImportFileFilters();
    }

    @Override
    public HashSet<SimpleFileFilter> getExportFileFilters() {
        return StandardDrawing.getFilterContainer().getExportFileFilters();
    }

    @Override
    public String getDefaultExtension() {
        return this.getDefaultFileFilter().getExtension();
    }

    @Override
    public void init() {
    }

    @Override
    public Drawing add(Drawing drawing) {
        FigureEnumeration figureEnumeration = drawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = (Figure)figureEnumeration.nextElement();
            this.add(figure);
        }
        return drawing;
    }

    @Override
    public Drawing add(Drawing drawing, int n, int n2) {
        FigureEnumeration figureEnumeration = drawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = (Figure)figureEnumeration.nextElement();
            this.add(figure);
            figure.moveBy(n, n2);
        }
        return drawing;
    }

    static {
        fgUntitled = "untitled";
    }
}

