/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.SnapshotHistory;
import CH.ifa.draw.standard.NullDrawingEditor;
import CH.ifa.draw.util.Command;

public class UndoRedoCommand
extends Command {
    public static final int UNDO = 1;
    public static final int REDO = 2;
    private int mode;

    public UndoRedoCommand(String string, int n) {
        super(string);
        this.mode = n;
    }

    private DrawingEditor getEditor() {
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        return drawPlugin == null ? NullDrawingEditor.INSTANCE : drawPlugin.getDrawingEditor();
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        if (this.getEditor() == NullDrawingEditor.INSTANCE) {
            return false;
        }
        SnapshotHistory snapshotHistory = null;
        switch (this.mode) {
            case 1: {
                snapshotHistory = this.getEditor().getUndoRedoManager().getUndoHistory(this.getEditor().drawing());
                break;
            }
            case 2: {
                snapshotHistory = this.getEditor().getUndoRedoManager().getRedoHistory(this.getEditor().drawing());
            }
        }
        return snapshotHistory != null && !snapshotHistory.isEmpty();
    }

    @Override
    public void execute() {
        if (this.isExecutable()) {
            this.getEditor().toolDone();
            switch (this.mode) {
                case 1: {
                    this.getEditor().getUndoRedoManager().restoreUndoSnapshot(this.getEditor().drawing());
                    this.getEditor().selectionChanged(this.getEditor().view());
                    break;
                }
                case 2: {
                    this.getEditor().getUndoRedoManager().restoreRedoSnapshot(this.getEditor().drawing());
                    this.getEditor().selectionChanged(this.getEditor().view());
                }
            }
        }
    }
}

