/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.util.AutosaveSaver;
import CH.ifa.draw.util.AutosaveTask;
import java.util.Hashtable;

public class AutosaveManager {
    private Hashtable<Drawing, AutosaveTask> autosaveTasks = new Hashtable();
    private long interval;
    private AutosaveSaver saver;

    public AutosaveManager(AutosaveSaver autosaveSaver, long l) {
        this.saver = autosaveSaver;
        this.interval = l;
    }

    public synchronized void addDrawing(Drawing drawing) {
        AutosaveTask autosaveTask = this.autosaveTasks.get(drawing);
        if (autosaveTask == null) {
            autosaveTask = new AutosaveTask(this.saver, drawing, this.interval);
            this.autosaveTasks.put(drawing, autosaveTask);
        }
        autosaveTask.reset();
    }

    public synchronized void removeDrawing(Drawing drawing) {
        AutosaveTask autosaveTask = this.autosaveTasks.get(drawing);
        if (autosaveTask != null) {
            autosaveTask.terminate();
            this.autosaveTasks.remove(drawing);
        }
    }

    public synchronized void renameDrawing(Drawing drawing) {
        this.removeDrawing(drawing);
        this.addDrawing(drawing);
    }
}

