/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Iconkit {
    public static Logger logger = Logger.getLogger(Iconkit.class);
    private static final int ID = 123;
    private static Iconkit fgIconkit = null;
    private Hashtable<String, Image> fMap = new Hashtable(53);
    private Vector<String> fRegisteredImages = new Vector(10);
    private Component fComponent;

    public Iconkit(Component component) {
        this.fComponent = component;
        fgIconkit = this;
    }

    public static Iconkit instance() {
        return fgIconkit;
    }

    public void loadRegisteredImages(Component component) {
        if (this.fRegisteredImages.size() == 0) {
            return;
        }
        MediaTracker mediaTracker = new MediaTracker(component);
        Enumeration<String> enumeration = this.fRegisteredImages.elements();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (this.basicGetImage(string) != null) continue;
            mediaTracker.addImage(this.loadImage(string), 123);
        }
        this.fRegisteredImages.removeAllElements();
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void registerImage(String string) {
        this.fRegisteredImages.addElement(string);
    }

    public Image registerAndLoadImage(Component component, String string) {
        this.registerImage(string);
        this.loadRegisteredImages(component);
        return this.getImage(string);
    }

    public Image loadImage(String string) {
        if (this.fMap.containsKey(string)) {
            return this.fMap.get(string);
        }
        Image image = this.loadImageResource(string);
        if (image != null) {
            this.fMap.put(string, image);
        }
        return image;
    }

    public Image loadImageResource(String string) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            URL uRL = this.getClass().getResource(string);
            logger.debug((Object)(string + "(" + uRL + ")"));
            if (uRL == null) {
                return toolkit.getImage(string);
            }
            Object object = uRL.getContent();
            if (object instanceof ImageProducer) {
                return toolkit.createImage((ImageProducer)object);
            }
            if (object instanceof InputStream) {
                boolean bl;
                InputStream inputStream = (InputStream)object;
                int n = 1024;
                if (inputStream.available() > n) {
                    n = inputStream.available();
                }
                byte[] byArray = new byte[n];
                int n2 = 0;
                do {
                    int n3;
                    if (n2 > n / 2) {
                        byte[] byArray2 = new byte[n *= 2];
                        System.arraycopy(byArray, 0, byArray2, 0, n2);
                        byArray = byArray2;
                    }
                    boolean bl2 = bl = (n3 = inputStream.read(byArray, n2, n - n2)) > 0;
                    if (!bl) continue;
                    n2 += n3;
                } while (bl);
                inputStream.close();
                return toolkit.createImage(byArray, 0, n2);
            }
            return toolkit.getImage(uRL);
        }
        catch (Exception exception) {
            logger.error((Object)("While loading " + string + ":"));
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public Image getImage(String string) {
        Image image = this.basicGetImage(string);
        if (image != null) {
            return image;
        }
        this.loadRegisteredImages(this.fComponent);
        return this.basicGetImage(string);
    }

    private Image basicGetImage(String string) {
        if (this.fMap.containsKey(string)) {
            return this.fMap.get(string);
        }
        return null;
    }
}

