/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInOut;
import CH.ifa.draw.util.UnknownTypeException;
import de.renew.plugin.PluginManager;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import org.apache.log4j.Logger;

public class StorableInput
extends StorableInOut {
    public static Logger logger = Logger.getLogger(StorableInput.class);
    private StreamTokenizer fTokenizer;
    private Reader fReader;
    private int version = Integer.MAX_VALUE;

    public StorableInput(URL uRL, boolean bl) throws IOException {
        this(URI.create(uRL.toString()), uRL.openStream(), bl);
    }

    public StorableInput(File file, boolean bl) throws FileNotFoundException {
        this(file.toURI(), new FileInputStream(file), bl);
    }

    public StorableInput(InputStream inputStream) {
        this(null, inputStream, true);
    }

    public StorableInput(InputStream inputStream, boolean bl) {
        this(null, inputStream, bl);
    }

    private StorableInput(URI uRI, InputStream inputStream, boolean bl) {
        super(uRI);
        if (bl) {
            try {
                this.fReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.error((Object)"UTF-8 not supported!");
            }
        }
        if (this.fReader == null) {
            this.fReader = new BufferedReader(new InputStreamReader(inputStream));
        }
        this.fTokenizer = new StreamTokenizer(this.fReader);
        this.fTokenizer.wordChars(95, 95);
    }

    public StorableInput(String string) {
        this(null, string);
    }

    private StorableInput(URI uRI, String string) {
        super(uRI);
        if (this.fReader == null) {
            this.fReader = new BufferedReader(new StringReader(string));
        }
        this.fTokenizer = new StreamTokenizer(this.fReader);
        this.fTokenizer.wordChars(95, 95);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public Storable readStorable() throws IOException {
        String string = this.readString();
        if (string.equals("NULL")) {
            return null;
        }
        if (string.equals("REF")) {
            int n = this.readInt();
            return this.retrieve(n);
        }
        Storable storable = (Storable)this.makeInstance(string);
        this.map(storable);
        storable.read(this);
        return storable;
    }

    public String readString() throws IOException {
        int n = this.fTokenizer.nextToken();
        if (n == -3 || n == 34) {
            return this.fTokenizer.sval;
        }
        String string = "String expected in line: " + this.fTokenizer.lineno();
        throw new IOException(string);
    }

    public boolean canReadInt() throws IOException {
        int n = this.fTokenizer.nextToken();
        this.fTokenizer.pushBack();
        return n == -2;
    }

    public int readInt() throws IOException {
        int n = this.fTokenizer.nextToken();
        if (n == -2) {
            return (int)this.fTokenizer.nval;
        }
        String string = "Integer expected in line: " + this.fTokenizer.lineno();
        throw new IOException(string);
    }

    public Color readColor() throws IOException {
        return new Color(this.readInt(), this.readInt(), this.readInt());
    }

    public double readDouble() throws IOException {
        int n = this.fTokenizer.nextToken();
        if (n == -2) {
            return this.fTokenizer.nval;
        }
        String string = "Double expected in line: " + this.fTokenizer.lineno();
        throw new IOException(string);
    }

    public boolean readBoolean() throws IOException {
        int n = this.fTokenizer.nextToken();
        if (n == -2) {
            return (int)this.fTokenizer.nval == 1;
        }
        String string = "Integer expected in line: " + this.fTokenizer.lineno();
        throw new IOException(string);
    }

    protected Object makeInstance(String string) throws IOException {
        try {
            Class<?> clazz = Class.forName(string, true, PluginManager.getInstance().getBottomClassLoader());
            return clazz.newInstance();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new IOException("Class " + string + " does not seem to have a no-arg constructor", noSuchMethodError);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnknownTypeException("No class: " + string, string);
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Cannot instantiate: " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Class (" + string + ") not accessible");
        }
    }

    public void close() {
        try {
            this.fReader.close();
        }
        catch (IOException iOException) {
            logger.error((Object)iOException.getMessage(), (Throwable)iOException);
        }
    }

    public void putBack() {
        this.fTokenizer.pushBack();
    }
}

