/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.base;

import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.net.TransitionInscription;
import de.renew.net.UplinkInscription;
import de.renew.net.loading.NetLoader;
import de.renew.shadow.ShadowArc;
import de.renew.shadow.ShadowCompiler;
import de.renew.shadow.ShadowDeclarationNode;
import de.renew.shadow.ShadowInscription;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetElement;
import de.renew.shadow.ShadowPlace;
import de.renew.shadow.ShadowPreprocessor;
import de.renew.shadow.ShadowTransition;
import de.renew.shadow.SyntaxException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public abstract class AbstractSingleNetCompiler
implements ShadowCompiler {
    protected ShadowLookup lookup;
    protected NetLoader loopbackNetLoader;
    protected transient int placeNum = 0;
    protected transient int transitionNum = 0;

    public void setShadowLookup(ShadowLookup shadowLookup) {
        this.lookup = shadowLookup;
    }

    public ShadowLookup getLookup() {
        return this.lookup;
    }

    public void setLoopbackNetLoader(NetLoader netLoader) {
        this.loopbackNetLoader = netLoader;
    }

    public Net createNet(String string) {
        return new Net(string);
    }

    public ShadowPreprocessor[] getRequiredPreprocessors() {
        return new ShadowPreprocessor[0];
    }

    protected abstract void compilePlaceInscriptions(ShadowPlace var1, Place var2) throws SyntaxException;

    protected void compile(ShadowPlace shadowPlace, Net net) throws SyntaxException {
        String string = shadowPlace.getName();
        if (string == null) {
            ++this.placeNum;
            string = "P" + this.placeNum;
        }
        Place place = new Place(net, string, new NetElementID(shadowPlace.getID()));
        place.setTrace(shadowPlace.getTrace());
        this.lookup.set(shadowPlace, place);
        this.compilePlaceInscriptions(shadowPlace, place);
    }

    protected abstract void compileArc(ShadowArc var1) throws SyntaxException;

    protected abstract Collection<TransitionInscription> compileTransitionInscription(ShadowInscription var1) throws SyntaxException;

    protected void compileNonStandardTransitionInscription(ShadowNetElement shadowNetElement) throws SyntaxException {
        throw new SyntaxException("Unsupported type of transition inscription").addObject((Object)shadowNetElement);
    }

    protected void compileTransitionInscriptions(ShadowTransition shadowTransition, Vector<TransitionInscription> vector, Vector<ShadowInscription> vector2) throws SyntaxException {
        for (Object e : shadowTransition.elements()) {
            if (e instanceof ShadowInscription) {
                ShadowInscription shadowInscription = (ShadowInscription)e;
                Iterator<TransitionInscription> iterator = null;
                try {
                    iterator = this.compileTransitionInscription((ShadowInscription)e).iterator();
                }
                catch (SyntaxException syntaxException) {
                    throw syntaxException.addObject((Object)shadowInscription);
                }
                while (iterator.hasNext()) {
                    vector.addElement(iterator.next());
                    vector2.addElement(shadowInscription);
                }
                continue;
            }
            if (e instanceof ShadowArc) {
                this.compileArc((ShadowArc)e);
                continue;
            }
            if (e instanceof ShadowNetElement) {
                this.compileNonStandardTransitionInscription((ShadowNetElement)e);
                continue;
            }
            throw new SyntaxException("Unsupported type of transition inscription").addObject(e);
        }
    }

    protected void compile(ShadowTransition shadowTransition, Net net) throws SyntaxException {
        int n;
        String string = shadowTransition.getName();
        if (string == null) {
            ++this.transitionNum;
            string = "T" + this.transitionNum;
        }
        Transition transition = new Transition(net, string, new NetElementID(shadowTransition.getID()));
        transition.setTrace(shadowTransition.getTrace());
        this.lookup.set(shadowTransition, transition);
        Vector<TransitionInscription> vector = new Vector<TransitionInscription>();
        Vector<ShadowInscription> vector2 = new Vector<ShadowInscription>();
        this.compileTransitionInscriptions(shadowTransition, vector, vector2);
        int n2 = 0;
        for (n = 0; n < vector.size(); ++n) {
            if (!(vector.elementAt(n) instanceof UplinkInscription)) continue;
            ++n2;
        }
        if (n2 > 1) {
            SyntaxException syntaxException = new SyntaxException("Transition has more than one uplink.");
            for (int i = 0; i < vector.size(); ++i) {
                if (!(vector.elementAt(i) instanceof UplinkInscription)) continue;
                syntaxException.addObject((Object)vector2.elementAt(i));
            }
            throw syntaxException;
        }
        for (n = 0; n < vector.size(); ++n) {
            transition.add(vector.elementAt(n));
        }
    }

    public abstract void parseDeclarations(ShadowNet var1) throws SyntaxException;

    protected ShadowDeclarationNode findDeclarationNode(ShadowNet shadowNet) throws SyntaxException {
        Iterator iterator = shadowNet.elements().iterator();
        ShadowDeclarationNode shadowDeclarationNode = null;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ShadowDeclarationNode)) continue;
            if (shadowDeclarationNode != null) {
                SyntaxException syntaxException = new SyntaxException("Only one declaration node is allowed.");
                syntaxException.addObject((Object)shadowDeclarationNode);
                syntaxException.addObject(e);
                while (iterator.hasNext()) {
                    e = iterator.next();
                    if (!(e instanceof ShadowDeclarationNode)) continue;
                    syntaxException.addObject(e);
                }
                throw syntaxException;
            }
            shadowDeclarationNode = (ShadowDeclarationNode)e;
        }
        return shadowDeclarationNode;
    }

    public void compile(ShadowNet shadowNet) throws SyntaxException {
        Net net = this.lookup.getNet(shadowNet.getName());
        this.parseDeclarations(shadowNet);
        for (Object e : shadowNet.elements()) {
            if (!(e instanceof ShadowPlace)) continue;
            this.compile((ShadowPlace)e, net);
        }
        for (Object e : shadowNet.elements()) {
            if (!(e instanceof ShadowTransition)) continue;
            this.compile((ShadowTransition)e, net);
        }
    }
}

