/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.function;

import de.renew.expression.Function;
import de.renew.formalism.function.Executor;
import de.renew.unify.Impossible;
import de.renew.unify.Tuple;
import de.renew.util.ReflectionSerializer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class StaticMethodFunction
implements Function {
    public static Logger logger = Logger.getLogger(StaticMethodFunction.class);
    transient Method method;

    public StaticMethodFunction(Method method) {
        if ((method.getModifiers() & 8) == 0) {
            throw new RuntimeException("Method expected to be static.");
        }
        this.method = method;
    }

    public Object function(Object object) throws Impossible {
        Tuple tuple = (Tuple)object;
        Object[] objectArray = new Object[tuple.getArity()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = tuple.getComponent(i);
        }
        try {
            return Executor.executeMethod(this.method, null, objectArray);
        }
        catch (Exception exception) {
            if (exception instanceof InvocationTargetException) {
                Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                if (logger.isDebugEnabled()) {
                    logger.error((Object)throwable.getMessage(), throwable);
                    logger.error((Object)("while executing " + this.method + "."));
                }
                throw new Impossible("Method call resulted in an exception: " + throwable, throwable);
            }
            if (logger.isDebugEnabled()) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
                logger.error((Object)("while executing " + this.method + "."));
            }
            throw new Impossible("Exception occured during method call: " + exception, (Throwable)exception);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        ReflectionSerializer.writeMethod((ObjectOutputStream)objectOutputStream, (Method)this.method);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.method = ReflectionSerializer.readMethod((ObjectInputStream)objectInputStream);
    }
}

