/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.formalism.function.CastFunction;
import de.renew.formalism.java.ArcFactory;
import de.renew.formalism.java.JavaHelper;
import de.renew.formalism.java.TimedExpression;
import de.renew.formalism.java.TypedExpression;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.net.TransitionInscription;
import de.renew.net.arc.FlexibleArc;
import de.renew.shadow.SyntaxException;
import de.renew.unify.List;
import de.renew.util.Types;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;

public class FlexibleOutArcFactory
implements ArcFactory {
    public static FlexibleOutArcFactory INSTANCE = new FlexibleOutArcFactory();

    private FlexibleOutArcFactory() {
    }

    @Override
    public void emptyArcCheck() throws SyntaxException {
        throw new SyntaxException("Flexible arcs must be inscribed.");
    }

    @Override
    public boolean allowsTime() {
        return true;
    }

    @Override
    public void compileArc(Place place, Transition transition, boolean bl, Class<?> clazz, TimedExpression timedExpression) throws SyntaxException {
        FlexibleArc flexibleArc;
        TypedExpression typedExpression = timedExpression.getExpression();
        CastFunction castFunction = null;
        Class<?> clazz2 = typedExpression.getType();
        if (clazz2 != Types.UNTYPED) {
            if (clazz2 == null) {
                throw new SyntaxException("Null not allowed for flexible arcs.");
            }
            if (List.class.isAssignableFrom(clazz2) || Enumeration.class.isAssignableFrom(clazz2) || Iterator.class.isAssignableFrom(clazz2) || Collection.class.isAssignableFrom(clazz2)) {
                if (clazz != Types.UNTYPED) {
                    throw new SyntaxException("For non-array inscriptions the place must be untyped.");
                }
            } else if (!clazz2.isArray()) {
                throw new SyntaxException("Incorrect type for flexible arc inscription.");
            }
        }
        if (clazz != Types.UNTYPED) {
            if (!typedExpression.isTyped()) {
                throw new SyntaxException("Output arc expression for typed place must be typed.");
            }
            flexibleArc = clazz2.getComponentType();
            if (!Types.allowsLosslessWidening(flexibleArc, clazz)) {
                throw new SyntaxException("Cannot losslessly convert " + JavaHelper.makeTypeErrorString(flexibleArc) + " to " + JavaHelper.makeTypeErrorString(clazz) + ".");
            }
            if (clazz.isPrimitive()) {
                castFunction = new CastFunction(clazz);
            }
        }
        flexibleArc = new FlexibleArc(place, transition, 1, typedExpression.getExpression(), castFunction, null);
        flexibleArc.setTrace(bl);
        transition.add((TransitionInscription)flexibleArc);
    }
}

