/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.expression.CallExpression;
import de.renew.expression.EqualsExpression;
import de.renew.expression.Expression;
import de.renew.expression.Function;
import de.renew.expression.InvertibleExpression;
import de.renew.expression.ListExpression;
import de.renew.expression.LocalVariable;
import de.renew.expression.NoArgExpression;
import de.renew.expression.NoArgFunction;
import de.renew.expression.TupleExpression;
import de.renew.expression.TypeCheckingExpression;
import de.renew.expression.VariableExpression;
import de.renew.formalism.function.ArrayFunction;
import de.renew.formalism.function.ArrayWriteFunction;
import de.renew.formalism.function.CastFunction;
import de.renew.formalism.function.ConstructorFunction;
import de.renew.formalism.function.DynamicConstructorFunction;
import de.renew.formalism.function.DynamicFieldFunction;
import de.renew.formalism.function.DynamicFieldWriteFunction;
import de.renew.formalism.function.DynamicMethodFunction;
import de.renew.formalism.function.DynamicStaticMethodFunction;
import de.renew.formalism.function.Executor;
import de.renew.formalism.function.FieldFunction;
import de.renew.formalism.function.FieldWriteFunction;
import de.renew.formalism.function.Identity;
import de.renew.formalism.function.MethodFunction;
import de.renew.formalism.function.StaticFieldFunction;
import de.renew.formalism.function.StaticFieldWriteFunction;
import de.renew.formalism.function.StaticMethodFunction;
import de.renew.formalism.java.ParseException;
import de.renew.formalism.java.ParsedDeclarationNode;
import de.renew.formalism.java.PrimaryPart;
import de.renew.formalism.java.Token;
import de.renew.formalism.java.TypedExpression;
import de.renew.util.Types;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Vector;
import org.apache.log4j.Logger;

public class JavaHelper {
    public static Logger logger = Logger.getLogger(JavaHelper.class);

    public static ParseException makeParseException(String string, Token token) {
        if (token != null) {
            Token token2 = token.next == null ? token : token.next;
            ParseException parseException = new ParseException("Error in line " + token2.beginLine + ", column " + token2.beginColumn + ":\n" + string);
            parseException.currentToken = token;
            return parseException;
        }
        return new ParseException(string);
    }

    public static TypedExpression makeTypedBinary(TypedExpression typedExpression, TypedExpression typedExpression2, Function function, Class<?> clazz) {
        return new TypedExpression(clazz, (Expression)new CallExpression(clazz, (Expression)new TupleExpression(typedExpression.getExpression(), typedExpression2.getExpression()), function));
    }

    public static TypedExpression makeBooleanBinary(TypedExpression typedExpression, TypedExpression typedExpression2, Function function) {
        return JavaHelper.makeTypedBinary(typedExpression, typedExpression2, function, Boolean.TYPE);
    }

    public static TypedExpression makeBinary(TypedExpression typedExpression, TypedExpression typedExpression2, Function function, Token token) throws ParseException {
        Class<Serializable> clazz;
        if (!typedExpression.isTyped() || !typedExpression2.isTyped()) {
            clazz = Types.UNTYPED;
        } else if (typedExpression.getType() == Boolean.TYPE || typedExpression2.getType() == Boolean.TYPE) {
            if (typedExpression.getType() != Boolean.TYPE || typedExpression2.getType() != Boolean.TYPE) {
                throw JavaHelper.makeParseException("Operator types do not match.", token);
            }
            clazz = Boolean.TYPE;
        } else {
            clazz = typedExpression.getType() == Double.TYPE || typedExpression2.getType() == Double.TYPE ? Double.TYPE : (typedExpression.getType() == Float.TYPE || typedExpression2.getType() == Float.TYPE ? Float.TYPE : (typedExpression.getType() == Long.TYPE || typedExpression2.getType() == Long.TYPE ? Long.TYPE : Integer.TYPE));
        }
        return JavaHelper.makeTypedBinary(typedExpression, typedExpression2, function, clazz);
    }

    public static Class<?> unaryNumericPromotion(Class<?> clazz, Token token) throws ParseException {
        if (clazz == Types.UNTYPED) {
            return clazz;
        }
        if (clazz == null || !clazz.isPrimitive()) {
            throw JavaHelper.makeParseException("Primitive type expected.", token);
        }
        if (clazz == Boolean.TYPE) {
            throw JavaHelper.makeParseException("Numeric type expected.", token);
        }
        if (clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Character.TYPE) {
            return Integer.TYPE;
        }
        return clazz;
    }

    public static Class<?> unaryIntegralPromotion(Class<?> clazz, Token token) throws ParseException {
        if (clazz == Float.TYPE || clazz == Double.TYPE) {
            throw JavaHelper.makeParseException("Integral type expected.", token);
        }
        return JavaHelper.unaryNumericPromotion(clazz, token);
    }

    public static void ensureNonVoid(TypedExpression typedExpression, Token token) throws ParseException {
        if (typedExpression.getType() == Void.TYPE) {
            throw JavaHelper.makeParseException("Expression of type void not allowed here.", token);
        }
    }

    public static void ensureConvertability(Class<?> clazz, TypedExpression typedExpression, Token token) throws ParseException {
        if (typedExpression.isTyped() && !Types.allowsWideningConversion(typedExpression.getType(), clazz)) {
            throw JavaHelper.makeParseException("Cannot convert " + JavaHelper.makeTypeErrorString(typedExpression.getType()) + " to " + JavaHelper.makeTypeErrorString(clazz) + ".", token);
        }
    }

    public static void ensureEnumerateability(TypedExpression typedExpression, Token token) throws ParseException {
        if (typedExpression.isTyped() && (typedExpression.getType() == null || !typedExpression.getType().isPrimitive() || typedExpression.getType() == Double.TYPE || typedExpression.getType() == Float.TYPE)) {
            throw JavaHelper.makeParseException("Enumerable type expected.", token);
        }
    }

    public static void ensureBinaryMatch(TypedExpression typedExpression, TypedExpression typedExpression2, Token token) throws ParseException {
        if (typedExpression.isTyped() && typedExpression2.isTyped()) {
            boolean bl;
            Class<?> clazz = typedExpression.getType();
            Class<?> clazz2 = typedExpression2.getType();
            boolean bl2 = clazz == null || !clazz.isPrimitive();
            boolean bl3 = bl = clazz2 == null || !clazz2.isPrimitive();
            if (bl2 ^ bl) {
                throw JavaHelper.makeParseException("Operator types do not match.", token);
            }
            if (clazz == Boolean.TYPE ^ clazz2 == Boolean.TYPE) {
                throw JavaHelper.makeParseException("Operator types do not match.", token);
            }
        }
    }

    public static TypedExpression makeExplicitCastExpression(Class<?> clazz, TypedExpression typedExpression, Token token) throws ParseException {
        if (typedExpression.getType() == clazz) {
            return typedExpression;
        }
        if (!typedExpression.isTyped()) {
            if (clazz.isPrimitive()) {
                return new TypedExpression(clazz, (Expression)new CallExpression(clazz, typedExpression.getExpression(), (Function)new CastFunction(clazz)));
            }
            return new TypedExpression(clazz, (Expression)new TypeCheckingExpression(clazz, typedExpression.getExpression()));
        }
        if (Types.allowsCast(typedExpression.getType(), clazz)) {
            if (clazz.isPrimitive()) {
                if (typedExpression.getType() == null) {
                    return new TypedExpression(clazz, typedExpression.getExpression());
                }
                if (Types.allowsLosslessWidening(typedExpression.getType(), clazz)) {
                    return new TypedExpression(clazz, (Expression)new InvertibleExpression(clazz, typedExpression.getExpression(), (Function)new CastFunction(clazz), (Function)new CastFunction(typedExpression.getType())));
                }
                return new TypedExpression(clazz, (Expression)new CallExpression(clazz, typedExpression.getExpression(), (Function)new CastFunction(clazz)));
            }
            return new TypedExpression(clazz, (Expression)new TypeCheckingExpression(clazz, JavaHelper.makeGuardedExpression(typedExpression)));
        }
        throw JavaHelper.makeParseException("Cannot cast " + Types.typeToString(typedExpression.getType()) + " to " + Types.typeToString(clazz) + ".", token);
    }

    public static Expression[] makeExpressionArray(Vector<TypedExpression> vector) {
        Expression[] expressionArray = new Expression[vector.size()];
        for (int i = 0; i < expressionArray.length; ++i) {
            TypedExpression typedExpression = vector.elementAt(i);
            expressionArray[i] = typedExpression.getExpression();
        }
        return expressionArray;
    }

    public static TupleExpression makeTupleExpression(Vector<TypedExpression> vector) {
        return new TupleExpression(JavaHelper.makeExpressionArray(vector));
    }

    public static ListExpression makeListExpression(Vector<TypedExpression> vector, boolean bl) {
        return new ListExpression(JavaHelper.makeExpressionArray(vector), bl);
    }

    public static Expression makeGuardedExpression(TypedExpression typedExpression) {
        if (typedExpression.isTyped() && typedExpression.getType() != null) {
            return new TypeCheckingExpression(typedExpression.getType(), typedExpression.getExpression());
        }
        return typedExpression.getExpression();
    }

    public static TupleExpression makeGuardedTupleExpression(Vector<TypedExpression> vector) {
        Expression[] expressionArray = new Expression[vector.size()];
        for (int i = 0; i < expressionArray.length; ++i) {
            expressionArray[i] = JavaHelper.makeGuardedExpression(vector.elementAt(i));
        }
        return new TupleExpression(expressionArray);
    }

    public static Class<?>[] makeTypeArray(Vector<TypedExpression> vector) {
        Class[] classArray = new Class[vector.size()];
        for (int i = 0; i < classArray.length; ++i) {
            TypedExpression typedExpression = vector.elementAt(i);
            if (!typedExpression.isTyped()) {
                return null;
            }
            classArray[i] = typedExpression.getType();
        }
        return classArray;
    }

    public static Class<?> increaseArrayLevel(Class<?> clazz, Token token) throws ParseException {
        try {
            return Array.newInstance(clazz, 0).getClass();
        }
        catch (Exception exception) {
            throw JavaHelper.makeParseException("Could not create class.", token);
        }
    }

    public static String makeTypeErrorString(Class<?> clazz) {
        if (clazz == null) {
            return "a null expression";
        }
        if (clazz == Types.UNTYPED) {
            return "an untyped expression";
        }
        return "an expression of type " + Types.typeToString(clazz);
    }

    private static TypedExpression makeTypedEquality(TypedExpression typedExpression, TypedExpression typedExpression2, Token token) throws ParseException {
        Class<?> clazz = typedExpression.getType();
        Class<?> clazz2 = typedExpression2.getType();
        Object object = clazz2 == null ? typedExpression2.getExpression() : (clazz2.isPrimitive() ? new InvertibleExpression(clazz, typedExpression2.getExpression(), (Function)new CastFunction(clazz), (Function)new CastFunction(clazz2)) : JavaHelper.makeGuardedExpression(typedExpression2));
        return new TypedExpression(typedExpression.getType(), (Expression)new EqualsExpression(typedExpression.getType(), typedExpression.getExpression(), object));
    }

    public static TypedExpression makeEqualityAssertion(TypedExpression typedExpression, TypedExpression typedExpression2, Token token) throws ParseException {
        Class<?> clazz = typedExpression.getType();
        Class<?> clazz2 = typedExpression2.getType();
        if (clazz == Void.TYPE || clazz2 == Void.TYPE) {
            throw JavaHelper.makeParseException("Expression of type void not allowed here.", token);
        }
        if (!typedExpression.isTyped() || !typedExpression2.isTyped() || Types.allowsIdentityConversion(clazz, clazz2)) {
            return new TypedExpression(clazz, (Expression)new EqualsExpression(clazz, JavaHelper.makeGuardedExpression(typedExpression), JavaHelper.makeGuardedExpression(typedExpression2)));
        }
        if (Types.allowsLosslessWidening(clazz2, clazz)) {
            return JavaHelper.makeTypedEquality(typedExpression, typedExpression2, token);
        }
        if (Types.allowsLosslessWidening(clazz, clazz2)) {
            return JavaHelper.makeTypedEquality(typedExpression2, typedExpression, token);
        }
        throw JavaHelper.makeParseException("Type mismatch in assignment.", token);
    }

    public static TypedExpression makeSinglePartExpression(PrimaryPart primaryPart, TypedExpression typedExpression, ParsedDeclarationNode parsedDeclarationNode) throws ParseException {
        switch (primaryPart.type) {
            case 3: {
                if (typedExpression == null) {
                    return (TypedExpression)primaryPart.obj;
                }
                throw JavaHelper.makeParseException("Invalid left hand side of assignment.", primaryPart.token);
            }
            case 0: {
                Object object;
                try {
                    object = parsedDeclarationNode.interpreteName((String)primaryPart.obj);
                }
                catch (LinkageError linkageError) {
                    String string = "No such variable: " + primaryPart.obj + "\n(denotes class with linkage problem:\n" + linkageError.toString() + ").";
                    logger.warn((Object)string);
                    logger.debug((Object)("Encountered " + linkageError), (Throwable)linkageError);
                    throw JavaHelper.makeParseException(string, primaryPart.token);
                }
                if (object instanceof LocalVariable) {
                    Class<?> clazz = parsedDeclarationNode.findType((LocalVariable)object);
                    if (typedExpression == null) {
                        return new TypedExpression(clazz, (Expression)new VariableExpression(clazz, (LocalVariable)object));
                    }
                    if (clazz == Types.UNTYPED) {
                        return new TypedExpression(clazz, (Expression)new EqualsExpression(clazz, (Expression)new VariableExpression(clazz, (LocalVariable)object), (Expression)new CallExpression(typedExpression.getType(), typedExpression.getExpression(), Identity.FUN)));
                    }
                    if (typedExpression.isTyped() && Types.allowsWideningConversion(typedExpression.getType(), clazz)) {
                        return new TypedExpression(clazz, (Expression)new EqualsExpression(clazz, (Expression)new VariableExpression(clazz, (LocalVariable)object), (Expression)new CallExpression(typedExpression.getType(), typedExpression.getExpression(), (Function)new CastFunction(clazz))));
                    }
                    throw JavaHelper.makeParseException("Cannot assign " + JavaHelper.makeTypeErrorString(typedExpression.getType()) + " to " + JavaHelper.makeTypeErrorString(clazz) + ".", primaryPart.token);
                }
                if (object instanceof Class) {
                    throw JavaHelper.makeParseException("No such variable: " + primaryPart.obj + " (denotes a class).", primaryPart.token);
                }
                logger.debug((Object)("No variable " + primaryPart.obj + " declared in " + parsedDeclarationNode));
                logger.debug((Object)("Meaning of " + primaryPart.obj + " is " + object));
                throw JavaHelper.makeParseException("No such variable: " + primaryPart.obj, primaryPart.token);
            }
        }
        throw new RuntimeException("Malformed primary vector.");
    }

    public static TypedExpression makeConstructorExpression(Class<?> clazz, Vector<TypedExpression> vector, Token token) throws ParseException {
        Class<?>[] classArray = JavaHelper.makeTypeArray(vector);
        if (classArray != null) {
            Constructor<?> constructor = null;
            try {
                constructor = Executor.findBestConstructor(clazz, classArray, true);
                if (constructor == null) {
                    throw JavaHelper.makeParseException("Multiple constructors match: " + Executor.renderMethodSignature(clazz, "<init>", classArray), token);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw JavaHelper.makeParseException("No such constructor: " + Executor.renderMethodSignature(clazz, "<init>", classArray) + JavaHelper.showListOfConstrutors(clazz), token);
            }
            catch (LinkageError linkageError) {
                logger.warn((Object)("Encountered " + linkageError), (Throwable)linkageError);
                throw JavaHelper.makeParseException("Cannot not bind constructor " + Executor.renderMethodSignature(clazz, "<init>", classArray) + " due to " + linkageError + ": ", token);
            }
            return new TypedExpression(clazz, (Expression)new CallExpression(clazz, (Expression)JavaHelper.makeTupleExpression(vector), (Function)new ConstructorFunction(constructor)));
        }
        return new TypedExpression(clazz, (Expression)new CallExpression(clazz, (Expression)JavaHelper.makeTupleExpression(vector), (Function)new DynamicConstructorFunction(clazz)));
    }

    private static String showListOfConstrutors(Class<?> clazz) {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        if (constructorArray.length == 0) {
            return "";
        }
        String string = "\nKnown constructors:";
        for (int i = 0; i < constructorArray.length; ++i) {
            string = string + "\n" + constructorArray[i].getName() + ".<init>(";
            Class<?>[] classArray = constructorArray[i].getParameterTypes();
            for (int j = 0; j < classArray.length; ++j) {
                if (j != 0) {
                    string = string + ", ";
                }
                string = string + classArray[j].getName();
            }
            string = string + ")";
        }
        return string;
    }

    private static String showListOfMethods(Class<?> clazz, String string, int n) {
        Method[] methodArray;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(JavaHelper.class.getName() + ": Class = " + clazz.toString()));
        }
        if ((methodArray = clazz.getMethods()).length == 0) {
            return "";
        }
        String string2 = string;
        String string3 = "\nKnown methods:";
        boolean bl = false;
        if (string2.endsWith("_")) {
            string2 = string2.substring(0, string2.length() - 1);
            bl = true;
        }
        if (methodArray.length > 20) {
            bl = true;
        }
        if (string.equals("_")) {
            bl = false;
        }
        if (bl) {
            string3 = string3 + " (prefixing \"" + string2 + "\")";
        }
        for (int i = 0; i < methodArray.length; ++i) {
            int n2 = methodArray[i].getModifiers();
            String string4 = methodArray[i].getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Name " + string4 + " pattern: " + string2));
                logger.debug((Object)(JavaHelper.class.getName() + ": modifier for " + methodArray[i].getName() + "= " + n2 + " " + !bl + string4.startsWith(string2)));
            }
            if (bl && !string4.startsWith(string2)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(JavaHelper.class.getName() + ": passed filter " + ((n & n2) != 0)));
            }
            if ((n & n2) == 0) continue;
            string3 = string3 + "\n" + string4 + "(";
            Class<?>[] classArray = methodArray[i].getParameterTypes();
            for (int j = 0; j < classArray.length; ++j) {
                if (j != 0) {
                    string3 = string3 + ", ";
                }
                string3 = string3 + classArray[j].getName();
            }
            string3 = string3 + ")";
        }
        return string3;
    }

    private static String showListOfFields(Class<?> clazz) {
        Field[] fieldArray = clazz.getFields();
        if (fieldArray.length == 0) {
            return "";
        }
        String string = "\nKnown fields:";
        for (int i = 0; i < fieldArray.length; ++i) {
            string = string + "\n" + fieldArray[i].getName();
        }
        return string;
    }

    public static TypedExpression makeMethodCall(TypedExpression typedExpression, Class<?> clazz, String string, Vector<TypedExpression> vector, Token token) throws ParseException {
        Method method;
        if (clazz != null) {
            throw JavaHelper.makeParseException("Calls to super object are not supported.", token);
        }
        Class<?> clazz2 = typedExpression.getType();
        if (clazz2 == null) {
            throw JavaHelper.makeParseException("Cannot invoke method on null object.", token);
        }
        Class<?>[] classArray = JavaHelper.makeTypeArray(vector);
        if (classArray == null || !typedExpression.isTyped()) {
            return new TypedExpression(Types.UNTYPED, (Expression)new CallExpression(Types.UNTYPED, (Expression)new TupleExpression(typedExpression.getExpression(), (Expression)JavaHelper.makeTupleExpression(vector)), (Function)new DynamicMethodFunction(string)));
        }
        try {
            method = Executor.findBestMethod(clazz2, string, classArray, true);
            if (method == null) {
                throw JavaHelper.makeParseException("Multiple methods match: " + Executor.renderMethodSignature(clazz2, string, classArray), token);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw JavaHelper.makeParseException("No such method: " + Executor.renderMethodSignature(clazz2, string, classArray) + JavaHelper.showListOfMethods(clazz2, string, Integer.MAX_VALUE), token);
        }
        catch (LinkageError linkageError) {
            logger.warn((Object)("Encountered " + linkageError), (Throwable)linkageError);
            throw JavaHelper.makeParseException("Cannot not bind method " + Executor.renderMethodSignature(clazz2, string, classArray) + " due to " + linkageError + ": ", token);
        }
        return new TypedExpression(method.getReturnType(), (Expression)new CallExpression(method.getReturnType(), (Expression)new TupleExpression(typedExpression.getExpression(), (Expression)JavaHelper.makeTupleExpression(vector)), (Function)new MethodFunction(method)));
    }

    public static TypedExpression makeExpression(Vector<PrimaryPart> vector, TypedExpression typedExpression, ParsedDeclarationNode parsedDeclarationNode, Token token) throws ParseException {
        Object object;
        Serializable serializable;
        int n;
        String string;
        if (typedExpression != null) {
            JavaHelper.ensureNonVoid(typedExpression, token);
        }
        PrimaryPart primaryPart = vector.elementAt(0);
        if (vector.size() == 1) {
            return JavaHelper.makeSinglePartExpression(primaryPart, typedExpression, parsedDeclarationNode);
        }
        int n2 = vector.size();
        if (typedExpression != null) {
            --n2;
        }
        Object object2 = null;
        switch (primaryPart.type) {
            case 3: {
                object2 = primaryPart.obj;
                string = primaryPart.toString();
                break;
            }
            case 0: {
                string = (String)primaryPart.obj;
                if (parsedDeclarationNode == null) break;
                try {
                    object2 = parsedDeclarationNode.interpreteName(string);
                }
                catch (LinkageError linkageError) {
                    logger.warn((Object)("Encountered " + linkageError), (Throwable)linkageError);
                    throw JavaHelper.makeParseException("Could not load class " + string + " due to " + linkageError.toString(), primaryPart.token);
                }
                int n3 = n;
                for (n = 1; n < n2; ++n) {
                    serializable = vector.elementAt(n);
                    if (((PrimaryPart)((Object)serializable)).type != 0) break;
                    string = string + "." + (String)((PrimaryPart)((Object)serializable)).obj;
                    try {
                        object = parsedDeclarationNode.interpreteName(string);
                        continue;
                    }
                    catch (LinkageError linkageError) {
                        logger.warn((Object)("Encountered " + linkageError), (Throwable)linkageError);
                        throw JavaHelper.makeParseException("Could not load class " + string + " due to linkage problem:\n" + linkageError.toString(), primaryPart.token);
                    }
                }
                n = n3;
                break;
            }
            default: {
                throw new RuntimeException("Malformed primary vector.");
            }
        }
        if (object2 == null) {
            logger.debug((Object)("No class or variable " + string + " declared in " + parsedDeclarationNode));
            throw JavaHelper.makeParseException("No such class or variable: " + string, primaryPart.token);
        }
        if (object2 instanceof LocalVariable) {
            Class<?> clazz = parsedDeclarationNode.findType((LocalVariable)object2);
            object2 = new TypedExpression(clazz, (Expression)new VariableExpression(clazz, (LocalVariable)object2));
        }
        while (n < n2) {
            PrimaryPart primaryPart2 = vector.elementAt(n);
            ++n;
            switch (primaryPart2.type) {
                case 3: {
                    throw new RuntimeException("Malformed primary vector.");
                }
                case 0: {
                    Object object3;
                    serializable = null;
                    if (n < vector.size()) {
                        object = vector.elementAt(n);
                        if (((PrimaryPart)object).type == 2) {
                            ++n;
                            object3 = (Vector)((PrimaryPart)object).obj;
                            serializable = object3;
                        }
                    }
                    if (serializable != null) {
                        if (object2 instanceof Class) {
                            object = JavaHelper.makeTypeArray((Vector<TypedExpression>)serializable);
                            if (object == null) {
                                object2 = new TypedExpression(Types.UNTYPED, (Expression)new CallExpression(Types.UNTYPED, (Expression)JavaHelper.makeTupleExpression((Vector<TypedExpression>)serializable), (Function)new DynamicStaticMethodFunction((String)primaryPart2.obj, (Class)object2)));
                                break;
                            }
                            try {
                                object3 = Executor.findBestMethod((Class)object2, (String)primaryPart2.obj, object, true);
                                if (object3 == null) {
                                    throw JavaHelper.makeParseException("Multiple methods match: " + Executor.renderMethodSignature((Class)object2, (String)primaryPart2.obj, object), primaryPart2.token);
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                throw JavaHelper.makeParseException("No such static method: " + Executor.renderMethodSignature((Class)object2, (String)primaryPart2.obj, object) + JavaHelper.showListOfMethods((Class)object2, (String)primaryPart2.obj, 8), primaryPart2.token);
                            }
                            catch (LinkageError linkageError) {
                                logger.warn((Object)("Encountered " + linkageError), (Throwable)linkageError);
                                throw JavaHelper.makeParseException("Cannot not bind method " + Executor.renderMethodSignature((Class)object2, (String)primaryPart2.obj, object) + " due to " + linkageError + ": ", primaryPart2.token);
                            }
                            if ((((Method)object3).getModifiers() & 8) == 0) {
                                throw JavaHelper.makeParseException("Cannot make static call to instance method.", primaryPart2.token);
                            }
                            object2 = new TypedExpression(((Method)object3).getReturnType(), (Expression)new CallExpression(((Method)object3).getReturnType(), (Expression)JavaHelper.makeTupleExpression((Vector<TypedExpression>)serializable), (Function)new StaticMethodFunction((Method)object3)));
                            break;
                        }
                        object2 = JavaHelper.makeMethodCall((TypedExpression)object2, null, (String)primaryPart2.obj, serializable, primaryPart2.token);
                        break;
                    }
                    if (object2 instanceof Class) {
                        object = (Class)object2;
                        object3 = null;
                        try {
                            object3 = ((Class)object).getField((String)primaryPart2.obj);
                        }
                        catch (Exception exception) {
                            throw JavaHelper.makeParseException("No such field: " + primaryPart2.obj + JavaHelper.showListOfFields(object), primaryPart2.token);
                        }
                        object2 = new TypedExpression(((Field)object3).getType(), (Expression)new NoArgExpression(((Field)object3).getType(), (NoArgFunction)new StaticFieldFunction((Field)object3)));
                        break;
                    }
                    if (((TypedExpression)object2).isTyped()) {
                        object = ((TypedExpression)object2).getType();
                        if (object == null) {
                            throw JavaHelper.makeParseException("Cannot access field of null object.", primaryPart2.token);
                        }
                        if (((Class)object).isArray() && "length".equals(primaryPart2.obj)) {
                            object2 = new TypedExpression(Integer.TYPE, (Expression)new CallExpression(Integer.TYPE, ((TypedExpression)object2).getExpression(), (Function)new DynamicFieldFunction((String)primaryPart2.obj)));
                            break;
                        }
                        object3 = null;
                        try {
                            object3 = ((Class)object).getField((String)primaryPart2.obj);
                        }
                        catch (Exception exception) {
                            throw JavaHelper.makeParseException("No such field.", primaryPart2.token);
                        }
                        object2 = new TypedExpression(((Field)object3).getType(), (Expression)new CallExpression(((Field)object3).getType(), ((TypedExpression)object2).getExpression(), (Function)new FieldFunction((Field)object3)));
                        break;
                    }
                    object2 = new TypedExpression(Types.UNTYPED, (Expression)new CallExpression(Types.UNTYPED, ((TypedExpression)object2).getExpression(), (Function)new DynamicFieldFunction((String)primaryPart2.obj)));
                    break;
                }
                case 1: {
                    if (!(object2 instanceof TypedExpression)) {
                        throw JavaHelper.makeParseException("No such class or variable.", primaryPart2.token);
                    }
                    object = Types.UNTYPED;
                    if (((TypedExpression)object2).isTyped()) {
                        object = ((TypedExpression)object2).getType();
                        if (!((Class)object).isArray()) {
                            throw JavaHelper.makeParseException("Not an array.", primaryPart2.token);
                        }
                        object = ((Class)object).getComponentType();
                    }
                    JavaHelper.ensureConvertability(Integer.TYPE, (TypedExpression)primaryPart2.obj, primaryPart2.token);
                    object2 = new TypedExpression((Class<?>)object, (Expression)new CallExpression((Class)object, (Expression)new TupleExpression(((TypedExpression)object2).getExpression(), ((TypedExpression)primaryPart2.obj).getExpression()), ArrayFunction.FUN));
                    break;
                }
                case 2: {
                    throw JavaHelper.makeParseException("Bad method call or no such method.", primaryPart2.token);
                }
                default: {
                    throw new RuntimeException("Malformed primary vector.");
                }
            }
        }
        if (typedExpression != null) {
            if (n == vector.size()) {
                throw JavaHelper.makeParseException("Invalid left hand side of assignment.", token);
            }
            PrimaryPart primaryPart3 = vector.elementAt(n);
            switch (primaryPart3.type) {
                case 0: {
                    if (object2 instanceof TypedExpression) {
                        if (((TypedExpression)object2).isTyped()) {
                            serializable = ((TypedExpression)object2).getType();
                            object = null;
                            try {
                                object = ((Class)serializable).getField((String)primaryPart3.obj);
                            }
                            catch (Exception exception) {
                                throw JavaHelper.makeParseException("No such field.", primaryPart3.token);
                            }
                            JavaHelper.ensureConvertability(((Field)object).getType(), typedExpression, token);
                            object2 = new TypedExpression(((Field)object).getType(), (Expression)new CallExpression(((Field)object).getType(), (Expression)new TupleExpression(((TypedExpression)object2).getExpression(), typedExpression.getExpression()), (Function)new FieldWriteFunction((Field)object)));
                            break;
                        }
                        object2 = new TypedExpression(Types.UNTYPED, (Expression)new CallExpression(Types.UNTYPED, (Expression)new TupleExpression(((TypedExpression)object2).getExpression(), typedExpression.getExpression()), (Function)new DynamicFieldWriteFunction((String)primaryPart3.obj)));
                        break;
                    }
                    serializable = (Class)object2;
                    object = null;
                    try {
                        object = ((Class)serializable).getField((String)primaryPart3.obj);
                    }
                    catch (Exception exception) {
                        throw JavaHelper.makeParseException("No such field.", primaryPart3.token);
                    }
                    JavaHelper.ensureConvertability(((Field)object).getType(), typedExpression, token);
                    object2 = new TypedExpression(((Field)object).getType(), (Expression)new CallExpression(((Field)object).getType(), typedExpression.getExpression(), (Function)new StaticFieldWriteFunction((Field)object)));
                    break;
                }
                case 1: {
                    if (!(object2 instanceof TypedExpression)) {
                        throw JavaHelper.makeParseException("No such class or variable.", primaryPart3.token);
                    }
                    serializable = Types.UNTYPED;
                    if (((TypedExpression)object2).isTyped()) {
                        serializable = ((TypedExpression)object2).getType();
                        if (!((Class)serializable).isArray()) {
                            throw JavaHelper.makeParseException("Not an array.", primaryPart3.token);
                        }
                        serializable = ((Class)serializable).getComponentType();
                        JavaHelper.ensureConvertability(serializable, typedExpression, token);
                    }
                    JavaHelper.ensureConvertability(Integer.TYPE, (TypedExpression)primaryPart3.obj, primaryPart3.token);
                    object2 = new TypedExpression((Class<?>)serializable, (Expression)new CallExpression((Class)serializable, (Expression)new TupleExpression(((TypedExpression)object2).getExpression(), ((TypedExpression)primaryPart3.obj).getExpression(), typedExpression.getExpression()), ArrayWriteFunction.FUN));
                    break;
                }
                default: {
                    throw new RuntimeException("Malformed primary vector.");
                }
            }
        }
        if (!(object2 instanceof TypedExpression)) {
            throw JavaHelper.makeParseException("No such class or variable.", primaryPart.token);
        }
        return (TypedExpression)object2;
    }
}

