/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.expression.CallExpression;
import de.renew.expression.Expression;
import de.renew.expression.Function;
import de.renew.expression.InvertibleExpression;
import de.renew.formalism.function.CastFunction;
import de.renew.formalism.java.JavaHelper;
import de.renew.formalism.java.TypedExpression;
import de.renew.shadow.SyntaxException;
import de.renew.util.Types;

public class JavaNetHelper {
    public static Expression makeCastedOutputExpression(Class<?> clazz, TypedExpression typedExpression) throws SyntaxException {
        if (clazz == Types.UNTYPED) {
            return typedExpression.getExpression();
        }
        if (typedExpression.getType() == Types.UNTYPED) {
            throw new SyntaxException("Output arc expression for typed place must be typed.");
        }
        if (clazz == typedExpression.getType()) {
            return typedExpression.getExpression();
        }
        if (Types.allowsLosslessWidening(typedExpression.getType(), clazz)) {
            if (clazz.isPrimitive()) {
                return new CallExpression(clazz, typedExpression.getExpression(), (Function)new CastFunction(clazz));
            }
            return typedExpression.getExpression();
        }
        throw new SyntaxException("Cannot losslessly convert " + JavaHelper.makeTypeErrorString(typedExpression.getType()) + " to " + JavaHelper.makeTypeErrorString(clazz) + ".");
    }

    public static Expression makeCastedInputExpression(Class<?> clazz, TypedExpression typedExpression) throws SyntaxException {
        if (clazz == Types.UNTYPED) {
            return JavaHelper.makeGuardedExpression(typedExpression);
        }
        if (typedExpression.getType() == Types.UNTYPED) {
            return typedExpression.getExpression();
        }
        if (clazz == typedExpression.getType()) {
            return typedExpression.getExpression();
        }
        if (Types.allowsLosslessWidening(clazz, typedExpression.getType())) {
            if (clazz.isPrimitive()) {
                return new InvertibleExpression(clazz, typedExpression.getExpression(), (Function)new CastFunction(clazz), (Function)new CastFunction(typedExpression.getType()));
            }
            return typedExpression.getExpression();
        }
        if (Types.allowsLosslessWidening(typedExpression.getType(), clazz)) {
            if (clazz.isPrimitive()) {
                return new InvertibleExpression(clazz, typedExpression.getExpression(), (Function)new CastFunction(clazz), (Function)new CastFunction(typedExpression.getType()));
            }
            return JavaHelper.makeGuardedExpression(typedExpression);
        }
        throw new SyntaxException("Cannot losslessly convert " + JavaHelper.makeTypeErrorString(typedExpression.getType()) + " to " + JavaHelper.makeTypeErrorString(clazz) + " or vice versa.");
    }
}

