/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.expression.ConstantExpression;
import de.renew.expression.Expression;
import de.renew.expression.VariableExpression;
import de.renew.formalism.base.AbstractSingleNetCompiler;
import de.renew.formalism.java.ArcFactory;
import de.renew.formalism.java.FlexibleInArcFactory;
import de.renew.formalism.java.FlexibleOutArcFactory;
import de.renew.formalism.java.InscriptionParser;
import de.renew.formalism.java.JavaHelper;
import de.renew.formalism.java.JavaNetHelper;
import de.renew.formalism.java.JavaNetParser;
import de.renew.formalism.java.ParseException;
import de.renew.formalism.java.ParsedDeclarationNode;
import de.renew.formalism.java.PlaceBehaviourModifier;
import de.renew.formalism.java.SimpleArcFactory;
import de.renew.formalism.java.TimedExpression;
import de.renew.formalism.java.Token;
import de.renew.formalism.java.TypedExpression;
import de.renew.net.ExpressionTokenSource;
import de.renew.net.Net;
import de.renew.net.Place;
import de.renew.net.TokenSource;
import de.renew.net.Transition;
import de.renew.net.TransitionInscription;
import de.renew.net.UplinkInscription;
import de.renew.net.arc.ClearArc;
import de.renew.net.inscription.ActionInscription;
import de.renew.net.inscription.DownlinkInscription;
import de.renew.net.inscription.ExpressionInscription;
import de.renew.net.inscription.GuardInscription;
import de.renew.shadow.SequentialOnlyExtension;
import de.renew.shadow.ShadowArc;
import de.renew.shadow.ShadowDeclarationNode;
import de.renew.shadow.ShadowInscription;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowPlace;
import de.renew.shadow.ShadowTransition;
import de.renew.shadow.SyntaxException;
import de.renew.unify.Tuple;
import de.renew.util.Types;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class SingleJavaNetCompiler
extends AbstractSingleNetCompiler {
    private boolean allowTimeInscriptions;
    private boolean wantEarlyTokens;
    private transient Hashtable<ShadowPlace, Class<?>> placeTypes = new Hashtable();
    protected ParsedDeclarationNode declaration;

    public SingleJavaNetCompiler(boolean bl, boolean bl2, boolean bl3) {
        this.allowTimeInscriptions = bl2;
        this.wantEarlyTokens = bl3;
    }

    @Override
    public Net createNet(String string) {
        Net net = super.createNet(string);
        net.setEarlyTokens(this.wantEarlyTokens);
        return net;
    }

    protected InscriptionParser makeParser(String string) {
        JavaNetParser javaNetParser = new JavaNetParser(new StringReader(string));
        javaNetParser.setNetLoader(this.loopbackNetLoader);
        return javaNetParser;
    }

    public static SyntaxException makeSyntaxException(ParseException parseException) {
        Token token = parseException.currentToken;
        if (token.next != null) {
            token = token.next;
        }
        return new SyntaxException(parseException.getMessage(), null, token.beginLine, token.beginColumn, (Throwable)parseException);
    }

    public String checkDeclarationNode(String string, boolean bl, ShadowNet shadowNet) throws SyntaxException {
        this.parseDeclarationNode(string);
        return "declaration";
    }

    public String checkArcInscription(String string, boolean bl, ShadowNet shadowNet) throws SyntaxException {
        this.makeDeclarationNode(shadowNet);
        this.parseArcInscription(string);
        return "inscription";
    }

    public String checkTransitionInscription(String string, boolean bl, ShadowNet shadowNet) throws SyntaxException {
        this.makeDeclarationNode(shadowNet);
        Collection<TransitionInscription> collection = this.makeInscriptions(string, null, false);
        if (collection.size() != 1) {
            return null;
        }
        TransitionInscription transitionInscription = collection.iterator().next();
        if (transitionInscription instanceof ActionInscription) {
            return "action";
        }
        if (transitionInscription instanceof GuardInscription) {
            return "guard";
        }
        if (transitionInscription instanceof UplinkInscription) {
            return "uplink";
        }
        if (transitionInscription instanceof DownlinkInscription) {
            return "downlink";
        }
        if (transitionInscription instanceof ExpressionInscription) {
            return "expression";
        }
        return null;
    }

    public String checkPlaceInscription(String string, boolean bl, ShadowNet shadowNet) throws SyntaxException {
        this.makeDeclarationNode(shadowNet);
        Collection<Object> collection = this.parsePlaceInscription(string);
        if (collection.size() != 1) {
            return null;
        }
        Object object = collection.iterator().next();
        if (object instanceof Class) {
            return "type";
        }
        if (object instanceof PlaceBehaviourModifier) {
            return "placebehaviour";
        }
        return "initialMarking";
    }

    @Override
    protected void compilePlaceInscriptions(ShadowPlace shadowPlace, Place place) throws SyntaxException {
        int n;
        Object object;
        Class clazz2;
        Vector vector = new Vector();
        Vector<Class> vector2 = new Vector<Class>();
        for (Class clazz2 : shadowPlace.elements()) {
            if (clazz2 instanceof ShadowInscription) {
                String string = ((ShadowInscription)clazz2).inscr;
                try {
                    object = this.parsePlaceInscription(string).iterator();
                    while (object.hasNext()) {
                        vector.addElement(object.next());
                        vector2.addElement(clazz2);
                    }
                    continue;
                }
                catch (SyntaxException syntaxException) {
                    throw syntaxException.addObject((Object)clazz2);
                }
            }
            if (clazz2 instanceof ShadowArc) continue;
            throw new SyntaxException("Unsupported place inscription").addObject((Object)shadowPlace).addObject((Object)clazz2);
        }
        clazz2 = Types.UNTYPED;
        int n2 = 0;
        object = new PlaceBehaviourModifier(0);
        int n3 = 0;
        for (n = 0; n < vector.size(); ++n) {
            if (vector.elementAt(n) instanceof Class) {
                clazz2 = (Class)vector.elementAt(n);
                ++n2;
                continue;
            }
            if (!(vector.elementAt(n) instanceof PlaceBehaviourModifier)) continue;
            object = (PlaceBehaviourModifier)vector.elementAt(n);
            ++n3;
        }
        if (n2 > 1) {
            SyntaxException syntaxException = new SyntaxException("Place is typed more than once.");
            for (int i = 0; i < vector.size(); ++i) {
                if (!(vector.elementAt(i) instanceof Class)) continue;
                syntaxException.addObject(vector2.elementAt(i));
            }
            throw syntaxException;
        }
        if (n3 > 1) {
            SyntaxException syntaxException = new SyntaxException("Place has more than one assigned behaviour.");
            for (int i = 0; i < vector.size(); ++i) {
                if (!(vector.elementAt(i) instanceof PlaceBehaviourModifier)) continue;
                syntaxException.addObject(vector2.elementAt(i));
            }
            throw syntaxException;
        }
        if (clazz2 != Types.UNTYPED) {
            this.placeTypes.put(shadowPlace, clazz2);
        }
        place.setBehaviour(((PlaceBehaviourModifier)object).behaviour);
        for (n = 0; n < vector.size(); ++n) {
            if (!(vector.elementAt(n) instanceof TypedExpression)) continue;
            TypedExpression typedExpression = (TypedExpression)vector.elementAt(n);
            Expression expression = null;
            try {
                expression = JavaNetHelper.makeCastedOutputExpression(clazz2, typedExpression);
            }
            catch (SyntaxException syntaxException) {
                throw syntaxException.addObject(vector2.elementAt(n));
            }
            place.add((TokenSource)new ExpressionTokenSource(expression));
        }
    }

    Class<?> getType(ShadowPlace shadowPlace) {
        if (this.placeTypes.containsKey(shadowPlace)) {
            return this.placeTypes.get(shadowPlace);
        }
        return Types.UNTYPED;
    }

    Collection<Object> parsePlaceInscription(String string) throws SyntaxException {
        if (string != null && !string.equals("")) {
            InscriptionParser inscriptionParser = this.makeParser(string);
            inscriptionParser.setDeclarationNode(this.declaration);
            try {
                return inscriptionParser.PlaceInscription();
            }
            catch (ParseException parseException) {
                throw SingleJavaNetCompiler.makeSyntaxException(parseException);
            }
        }
        return Collections.emptySet();
    }

    @Override
    protected void compileArc(ShadowArc shadowArc) throws SyntaxException {
        ArcFactory arcFactory = this.getArcFactory(shadowArc);
        if (shadowArc.shadowArcType == 5) {
            this.compileClearArc(shadowArc);
        } else {
            this.compileArcInscriptions(shadowArc, arcFactory);
        }
    }

    protected ShadowInscription getSingleArcInscription(ShadowArc shadowArc) throws SyntaxException {
        Set set = shadowArc.elements();
        if (set.size() >= 2) {
            SyntaxException syntaxException = new SyntaxException("This arc must not be inscribed multiple times.").addObject((Object)shadowArc);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                syntaxException.addObject(iterator.next());
            }
            throw syntaxException;
        }
        if (set.size() == 1) {
            return (ShadowInscription)set.iterator().next();
        }
        return null;
    }

    protected TypedExpression parseVariable(String string) throws SyntaxException {
        InscriptionParser inscriptionParser = this.makeParser(string);
        inscriptionParser.setDeclarationNode(this.declaration);
        try {
            return inscriptionParser.VariableInscription();
        }
        catch (ParseException parseException) {
            throw SingleJavaNetCompiler.makeSyntaxException(parseException);
        }
    }

    protected void compileClearArc(ShadowArc shadowArc) throws SyntaxException {
        Transition transition = this.lookup.get(shadowArc.transition);
        Place place = this.lookup.get(shadowArc.place);
        Class<?> clazz = this.getType(shadowArc.place);
        ShadowInscription shadowInscription = this.getSingleArcInscription(shadowArc);
        String string = null;
        if (shadowInscription != null) {
            string = shadowInscription.inscr;
        }
        if (string == null || string.equals("")) {
            ClearArc clearArc = new ClearArc(place, transition, (Expression)new VariableExpression(Types.UNTYPED, null), Object.class);
            clearArc.setTrace(shadowArc.getTrace());
            transition.add((TransitionInscription)clearArc);
        } else {
            Class clazz2;
            TypedExpression typedExpression;
            try {
                typedExpression = this.parseVariable(string);
            }
            catch (SyntaxException syntaxException) {
                throw syntaxException.addObject((Object)shadowInscription);
            }
            Class<?> clazz3 = typedExpression.getType();
            if (clazz == Types.UNTYPED) {
                if (clazz3 != Types.UNTYPED) {
                    throw new SyntaxException("Cannot clear untyped place using typed variable.").addObject((Object)shadowArc);
                }
                clazz2 = Object.class;
            } else if (clazz3 == Types.UNTYPED) {
                clazz2 = clazz;
            } else {
                if (!clazz3.isArray()) {
                    throw new SyntaxException("Variable of array type expected.").addObject((Object)shadowInscription);
                }
                clazz2 = clazz3.getComponentType();
                if (!Types.allowsLosslessWidening(clazz, clazz2)) {
                    throw new SyntaxException("Cannot losslessly convert " + JavaHelper.makeTypeErrorString(clazz) + " to " + JavaHelper.makeTypeErrorString(clazz2) + ".").addObject((Object)shadowInscription);
                }
            }
            ClearArc clearArc = new ClearArc(place, transition, typedExpression.getExpression(), clazz2);
            clearArc.setTrace(shadowArc.getTrace());
            transition.add((TransitionInscription)clearArc);
        }
    }

    protected Collection<TimedExpression> makeArcExpressions(String string) throws SyntaxException {
        Iterator<TimedExpression> iterator = this.parseArcInscription(string).iterator();
        ArrayList<TimedExpression> arrayList = new ArrayList<TimedExpression>();
        while (iterator.hasNext()) {
            TimedExpression timedExpression = iterator.next();
            if (timedExpression.getExpression().getType() == Void.TYPE) {
                throw new SyntaxException("Cannot use void expressions as arc inscriptions.");
            }
            if (timedExpression.isTimed()) {
                this.setSequential(true);
            }
            arrayList.add(timedExpression);
        }
        return arrayList;
    }

    protected Collection<TimedExpression> makeEmptyArcExpressions() throws SyntaxException {
        return this.makeArcExpressions(null);
    }

    protected void compileSingleArcInscription(Collection<TimedExpression> collection, Class<?> clazz, ArcFactory arcFactory, Place place, Transition transition, boolean bl) throws SyntaxException {
        for (TimedExpression timedExpression : collection) {
            if (arcFactory.allowsTime() && this.allowTimeInscriptions) {
                if (timedExpression.isTimed() && timedExpression.getTime().isTyped() && !Types.allowsWideningConversion(timedExpression.getTime().getType(), Double.TYPE)) {
                    throw new SyntaxException("Non-numeric time expression.");
                }
            } else if (timedExpression.isTimed()) {
                if (this.allowTimeInscriptions) {
                    throw new SyntaxException("This arc type does not allow time inscriptions.");
                }
                throw new SyntaxException("Time annotations are not allowed.");
            }
            arcFactory.compileArc(place, transition, bl, clazz, timedExpression);
        }
    }

    protected void compileArcInscriptions(ShadowArc shadowArc, ArcFactory arcFactory) throws SyntaxException {
        Transition transition = this.lookup.get(shadowArc.transition);
        Place place = this.lookup.get(shadowArc.place);
        Iterator iterator = shadowArc.elements().iterator();
        if (iterator.hasNext()) {
            do {
                ShadowInscription shadowInscription = (ShadowInscription)iterator.next();
                try {
                    this.compileSingleArcInscription(this.makeArcExpressions(shadowInscription.inscr), this.getType(shadowArc.place), arcFactory, place, transition, shadowArc.getTrace());
                }
                catch (SyntaxException syntaxException) {
                    throw syntaxException.addObject((Object)shadowInscription);
                }
            } while (iterator.hasNext());
        } else {
            try {
                arcFactory.emptyArcCheck();
                this.compileSingleArcInscription(this.makeEmptyArcExpressions(), this.getType(shadowArc.place), arcFactory, place, transition, shadowArc.getTrace());
            }
            catch (SyntaxException syntaxException) {
                throw syntaxException.addObject((Object)shadowArc);
            }
        }
    }

    protected ArcFactory getArcFactory(int n, boolean bl) {
        return new SimpleArcFactory(n, bl);
    }

    protected ArcFactory getArcFactory(ShadowArc shadowArc) throws SyntaxException {
        switch (shadowArc.shadowArcType) {
            case 0: {
                return this.getArcFactory(0, false);
            }
            case 2: {
                return this.getArcFactory(6, true);
            }
            case 1: {
                return this.getArcFactory(shadowArc.placeToTransition ? -1 : 1, true);
            }
            case 3: {
                this.setSequential(true);
                return this.getArcFactory(5, false);
            }
            case 4: {
                if (shadowArc.placeToTransition) {
                    return FlexibleInArcFactory.INSTANCE;
                }
                return FlexibleOutArcFactory.INSTANCE;
            }
            case 5: {
                this.setSequential(true);
                return null;
            }
        }
        throw new SyntaxException("Unsupported arc type.").addObject((Object)shadowArc);
    }

    protected Collection<TimedExpression> parseArcInscription(String string) throws SyntaxException {
        if (string != null && !string.equals("")) {
            InscriptionParser inscriptionParser = this.makeParser(string);
            inscriptionParser.setDeclarationNode(this.declaration);
            try {
                return inscriptionParser.ArcInscription();
            }
            catch (ParseException parseException) {
                throw SingleJavaNetCompiler.makeSyntaxException(parseException);
            }
        }
        return Collections.singleton(new TimedExpression(new TypedExpression(Tuple.class, (Expression)new ConstantExpression(Tuple.class, (Object)new Tuple(0))), null));
    }

    @Override
    protected Collection<TransitionInscription> compileTransitionInscription(ShadowInscription shadowInscription) throws SyntaxException {
        return this.makeInscriptions(shadowInscription, this.lookup, true);
    }

    protected Collection<TransitionInscription> makeInscriptions(ShadowInscription shadowInscription, ShadowLookup shadowLookup, boolean bl) throws SyntaxException {
        String string = shadowInscription.inscr;
        Transition transition = shadowLookup.get((ShadowTransition)shadowInscription.inscribable);
        return this.makeInscriptions(string, transition, bl);
    }

    protected Collection<TransitionInscription> makeInscriptions(String string, Transition transition, boolean bl) throws SyntaxException {
        InscriptionParser inscriptionParser = this.makeParser(string);
        inscriptionParser.setLookup(this.lookup);
        inscriptionParser.setDeclarationNode(this.declaration);
        try {
            return inscriptionParser.TransitionInscription(bl, transition);
        }
        catch (ParseException parseException) {
            throw SingleJavaNetCompiler.makeSyntaxException(parseException);
        }
    }

    protected ParsedDeclarationNode compile(ShadowDeclarationNode shadowDeclarationNode) throws SyntaxException {
        try {
            return this.parseDeclarationNode(shadowDeclarationNode.inscr);
        }
        catch (SyntaxException syntaxException) {
            throw syntaxException.addObject((Object)shadowDeclarationNode);
        }
    }

    ParsedDeclarationNode parseDeclarationNode(String string) throws SyntaxException {
        if (string != null) {
            InscriptionParser inscriptionParser = this.makeParser(string);
            try {
                return inscriptionParser.DeclarationNode();
            }
            catch (ParseException parseException) {
                throw SingleJavaNetCompiler.makeSyntaxException(parseException);
            }
        }
        return this.makeEmptyDeclarationNode(null);
    }

    protected ParsedDeclarationNode makeEmptyDeclarationNode(ShadowNet shadowNet) {
        return new ParsedDeclarationNode();
    }

    @Override
    public void parseDeclarations(ShadowNet shadowNet) throws SyntaxException {
        this.makeDeclarationNode(shadowNet);
    }

    public ParsedDeclarationNode makeDeclarationNode(ShadowNet shadowNet) throws SyntaxException {
        ShadowDeclarationNode shadowDeclarationNode = this.findDeclarationNode(shadowNet);
        this.declaration = shadowDeclarationNode == null ? this.makeEmptyDeclarationNode(shadowNet) : this.compile(shadowDeclarationNode);
        return this.declaration;
    }

    private void setSequential(boolean bl) {
        SequentialOnlyExtension sequentialOnlyExtension = SequentialOnlyExtension.lookup((ShadowLookup)this.lookup);
        sequentialOnlyExtension.setSequentialOnly(bl);
    }
}

