/*
 * Decompiled with CFR 0.152.
 */
package de.renew.prompt;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import de.renew.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.Map;
import org.apache.log4j.Logger;

public class PromptPlugin
extends PluginAdapter {
    public static Logger logger = Logger.getLogger(PromptPlugin.class);
    public static final String DONT_PROP_NAME = "de.renew.prompt.dont";
    public static final String ALIVE_PROP_NAME = "de.renew.prompt.keepalive";
    private static final int NULL_INPUT_RETRIES = 3;
    private PromptThread _promptThread;
    private boolean blockingState = false;

    public PromptPlugin(URL uRL) throws PluginException {
        super(uRL);
    }

    public PromptPlugin(PluginProperties pluginProperties) {
        super(pluginProperties);
    }

    public synchronized void init() {
        boolean bl;
        boolean bl2 = bl = !this.getProperties().getBoolProperty(DONT_PROP_NAME);
        if (bl) {
            this.prompt();
            this.setBlockingState(this.getProperties().getBoolProperty(ALIVE_PROP_NAME));
            PluginManager.getInstance().addCLCommand("keepalive", (CLCommand)new BlockingPromptCommand());
        } else {
            logger.debug((Object)"PromptPlugin: de.renew.prompt.dont is set to true. Not prompting.");
        }
    }

    public synchronized boolean cleanup() {
        if (this._promptThread != null) {
            logger.debug((Object)("shutting down prompt thread " + this._promptThread));
            this._promptThread.setStop();
            PluginManager.getInstance().removeCLCommand("keepalive");
            this._promptThread = null;
        }
        return true;
    }

    private void prompt() {
        this._promptThread = new PromptThread(this);
        this._promptThread.start();
    }

    public synchronized void setBlockingState(boolean bl) {
        if (bl != this.blockingState) {
            this.blockingState = bl;
            if (this.blockingState) {
                this.registerExitBlock();
            } else {
                this.registerExitOk();
            }
        }
    }

    private class BlockingPromptCommand
    implements CLCommand {
        private BlockingPromptCommand() {
        }

        public void execute(String[] stringArray, PrintStream printStream) {
            if (stringArray.length == 0) {
                if (PromptPlugin.this.blockingState) {
                    printStream.println("Prompt will keep plugin system alive.");
                } else {
                    printStream.println("Prompt will not prevent plugin system from automatic termination.");
                }
            } else if ("on".equals(stringArray[0])) {
                PromptPlugin.this.setBlockingState(true);
                printStream.println("Prompt will keep plugin system alive.");
            } else if ("off".equals(stringArray[0])) {
                PromptPlugin.this.setBlockingState(false);
                printStream.println("Prompt will not prevent plugin system from automatic termination.");
            } else {
                printStream.println("Controls the keep-alive feature of the Renew Prompt plugin.\nArguments:\n - \"on\" prevents the plugin system from automatic termination.\n - \"off\" allows automatic termination as long as no other plugin prevents it.\n - no argument displays the current keep-alive mode.");
            }
        }

        public String getDescription() {
            return "controls the keep-alive feature of the Renew Prompt plugin.";
        }
    }

    private class PromptThread
    extends Thread {
        private boolean _stop;
        private BufferedReader _reader;
        private PromptPlugin _myself;

        public PromptThread(PromptPlugin promptPlugin2) {
            super("Plugin-Prompt-Thread");
            this._stop = false;
            this._myself = promptPlugin2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            logger.debug((Object)"Prompt thread running.");
            String string = "";
            int n = 0;
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            this._reader = new BufferedReader(inputStreamReader);
            this._stop = false;
            try {
                while (!this._stop) {
                    System.out.print("Enter command: ");
                    try {
                        String[] stringArray;
                        string = this.readCommand();
                        if (string == null) {
                            if (++n > 3) {
                                logger.error((Object)"PromptPlugin: No input. Terminating prompt.");
                                PluginManager.getInstance().stop((IPlugin)this._myself);
                                this._stop = true;
                                continue;
                            }
                            logger.debug((Object)("PromptPlugin: No input. (" + n + ")"));
                            continue;
                        }
                        n = 0;
                        Map map = PluginManager.getInstance().getCLCommands();
                        for (String string2 : stringArray = string.split("---")) {
                            String[] stringArray2 = StringUtil.splitStringWithEscape((String)string2);
                            if (stringArray2.length == 0) continue;
                            CLCommand cLCommand = (CLCommand)map.get(stringArray2[0]);
                            if (cLCommand == null) {
                                System.out.println("unknown command.");
                                continue;
                            }
                            String[] stringArray3 = new String[stringArray2.length - 1];
                            for (int i = 0; i < stringArray3.length; ++i) {
                                stringArray3[i] = stringArray2[i + 1];
                            }
                            cLCommand.execute(stringArray3, System.out);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        logger.error((Object)("PromptThread: an exeption occurred: " + runtimeException));
                        logger.error((Object)runtimeException.getMessage(), (Throwable)runtimeException);
                    }
                }
            }
            catch (ThreadDeath threadDeath) {
                logger.debug((Object)"Prompt thread exiting!");
            }
            this._reader = null;
            PromptPlugin.this.setBlockingState(false);
        }

        protected void setStop() {
            this._stop = true;
            this.interrupt();
        }

        public String readCommand() {
            String string = "";
            try {
                string = this._reader.readLine();
            }
            catch (IOException iOException) {
                logger.debug((Object)iOException.getMessage(), (Throwable)iOException);
            }
            return string;
        }
    }
}

