/*
 * Decompiled with CFR 0.152.
 */
package de.renew.splashscreen;

import de.renew.plugin.load.IExtendedProgressBar;
import de.renew.splashscreen.RenewSplashScreen;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ExtendedProgressBar
extends JPanel
implements IExtendedProgressBar {
    private static final String loadedInfoScrollPane = "loadedInfoScrollPane";
    private static final String loadedInfoTextArea = "loadedInfoTextArea";
    private JProgressBar progressBar;
    private JScrollPane scrollPane;
    private JTextArea textArea;
    private static IExtendedProgressBar iExtendedProgressBar;

    private ExtendedProgressBar() {
        if (iExtendedProgressBar == null) {
            this.init();
        }
    }

    public static synchronized IExtendedProgressBar getInstance() {
        if (iExtendedProgressBar == null) {
            iExtendedProgressBar = new ExtendedProgressBar();
        }
        return iExtendedProgressBar;
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.textArea = new JTextArea(10, 30);
        this.textArea.setName(loadedInfoTextArea);
        this.scrollPane = new JScrollPane(this.textArea);
        this.scrollPane.setName(loadedInfoScrollPane);
        this.scrollPane.setAutoscrolls(true);
        this.textArea.setEditable(false);
        Font font = new Font("Arial", 1, 14);
        this.textArea.setFont(font);
        this.textArea.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        this.scrollPane.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        this.add(this.scrollPane);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.setOpaque(false);
        this.setBackground(Color.WHITE);
        this.progressBar.setAlignmentY(0.5f);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(this.progressBar);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("progress" == propertyChangeEvent.getPropertyName()) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (n > 100) {
                n = 100;
            }
            this.progressBar.setValue(n);
            this.progressBar.validate();
        }
        if ("pluginLoaded" == propertyChangeEvent.getPropertyName()) {
            String string = "Loaded plugin : " + propertyChangeEvent.getNewValue() + "\n";
            this.textArea.append(string);
            this.textArea.setCaretPosition(this.textArea.getCaretPosition() + string.length());
        }
    }

    public int getValue() {
        return this.progressBar.getValue();
    }

    public void close() {
        RenewSplashScreen.getInstance().closeSplashScreen();
    }
}

