/*
 * Decompiled with CFR 0.152.
 */
package de.renew.splashscreen;

import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.load.IExtendedProgressBar;
import de.renew.plugin.load.PluginLoaderComposition;
import de.renew.splashscreen.ExtendedProgressBar;
import de.renew.splashscreen.RenewSplashScreen;
import java.net.URL;

public class SplashscreenPlugin
extends PluginAdapter {
    private static final String KEY_SPLASHSCREEN_ENABLED = "de.renew.splashscreen.enabled";
    private static SplashscreenPlugin _instance;

    public SplashscreenPlugin(URL uRL) throws PluginException {
        super(uRL);
        this.makeInstance();
        this.showScreen();
    }

    public SplashscreenPlugin(PluginProperties pluginProperties) {
        super(pluginProperties);
        this.makeInstance();
        this.showScreen();
    }

    private void makeInstance() {
        if (_instance == null) {
            _instance = this;
        }
    }

    private void showScreen() {
        if (this.getProperties().getBoolProperty(KEY_SPLASHSCREEN_ENABLED)) {
            RenewSplashScreen renewSplashScreen = RenewSplashScreen.getInstance();
            if (renewSplashScreen != null) {
                renewSplashScreen.showSplashScreen(PluginManager.getLoaderLocation());
                PluginLoaderComposition.setProgressBar((IExtendedProgressBar)ExtendedProgressBar.getInstance());
            }
        } else {
            logger.debug((Object)"Splash screen disabled by user choice.");
        }
    }

    public static SplashscreenPlugin getInstance() {
        return _instance;
    }
}

