/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.util.Fontkit;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.searchqueue.TimeListener;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.gui.CPNSimulation;
import de.renew.remote.BindingAccessor;
import de.renew.remote.RemoteTriggerable;
import de.renew.remote.TransitionInstanceAccessor;
import de.renew.remote.TriggerableForwarder;
import de.renew.remote.TriggerableForwarderImpl;
import de.renew.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

class BindingSelectionFrame
implements ListSelectionListener,
TimeListener,
RemoteTriggerable {
    public static Logger logger = Logger.getLogger(BindingSelectionFrame.class);
    private static BindingSelectionFrame instance = null;
    private JFrame frame;
    private JTextArea currentElement;
    private JList bindingList;
    private DefaultListModel bindingListModel;
    private JButton fireButton;
    private JButton updateButton;
    private JButton closeButton;
    private BindingAccessor[] bindings;
    private String[] fullBindingText;
    private TransitionInstanceAccessor transitionInstance;
    private CPNSimulation simulation;
    private TriggerableForwarder triggerableForwarder;
    private boolean dirty = false;
    private boolean inSearch = false;
    private boolean wantClose = false;
    private Object updateSynchronizer = new Object();
    private static boolean frameOpened = false;

    private BindingSelectionFrame() {
        this.frame = new JFrame();
        this.currentElement = new JTextArea(5, 20);
        this.currentElement.setEditable(false);
        this.currentElement.setFont((Font)Fontkit.getFont((String)"Monospaced", (int)0, (int)11));
        JScrollPane jScrollPane = new JScrollPane(this.currentElement);
        jScrollPane.setMinimumSize(new Dimension(150, 50));
        jScrollPane.setPreferredSize(new Dimension(250, 100));
        this.bindingListModel = new DefaultListModel();
        this.bindingList = new JList(this.bindingListModel);
        this.bindingList.setSelectionMode(0);
        this.bindingList.addListSelectionListener(this);
        this.bindingList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    int n = BindingSelectionFrame.this.bindingList.getSelectedIndex();
                    BindingSelectionFrame.this.fireBinding(n);
                }
            }
        });
        this.bindingList.setVisibleRowCount(10);
        JScrollPane jScrollPane2 = new JScrollPane(this.bindingList);
        jScrollPane2.setMinimumSize(new Dimension(100, 50));
        jScrollPane2.setPreferredSize(new Dimension(150, 100));
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane2, jScrollPane);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.1);
        this.frame.getContentPane().add((Component)jSplitPane, "Center");
        this.fireButton = new JButton(" Fire ");
        this.fireButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = BindingSelectionFrame.this.bindingList.getSelectedIndex();
                BindingSelectionFrame.this.fireBinding(n);
            }
        });
        this.updateButton = new JButton(" Update ");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BindingSelectionFrame.this.update();
            }
        });
        this.closeButton = new JButton(" Close ");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BindingSelectionFrame.close();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.fireButton);
        jPanel.add(this.updateButton);
        jPanel.add(this.closeButton);
        this.frame.getContentPane().add((Component)jPanel, "South");
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BindingSelectionFrame.close();
            }
        });
        this.frame.pack();
        SearchQueue.insertTimeListener((TimeListener)this);
        try {
            this.triggerableForwarder = new TriggerableForwarderImpl((RemoteTriggerable)this);
        }
        catch (RemoteException remoteException) {
            logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
            JOptionPane.showMessageDialog(this.frame, "A problem occurred: " + remoteException + "\n" + "See the console for details.", "Binding selection frame", 0);
        }
    }

    static synchronized void open(TransitionInstanceAccessor transitionInstanceAccessor, CPNSimulation cPNSimulation) {
        if (instance == null) {
            instance = new BindingSelectionFrame();
        }
        frameOpened = true;
        instance.setup(transitionInstanceAccessor, cPNSimulation);
    }

    static synchronized void close() {
        if (instance != null) {
            instance.instanceClose();
        }
    }

    private synchronized void instanceClose() {
        if (this.inSearch) {
            this.wantClose = true;
        } else {
            this.closeNow();
        }
    }

    private void closeNow() {
        assert (this.triggerableForwarder != null) : "Triggerable forwarder should have the same lifespan as the frame.";
        if (this.transitionInstance != null) {
            try {
                this.transitionInstance.forgetBindings(this.triggerableForwarder);
            }
            catch (RemoteException remoteException) {
                logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
                JOptionPane.showMessageDialog(this.frame, "Could not disconnect from transition instance:\n" + remoteException + "\n" + "See the console for details.", "Binding selection frame", 2);
            }
        }
        this.frame.setVisible(false);
        frameOpened = false;
        this.bindingListModel.clear();
        this.transitionInstance = null;
        this.wantClose = false;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        String string = "";
        int n = this.bindingList.getSelectedIndex();
        if (n >= 0 && n < this.bindings.length) {
            string = this.fullBindingText[n];
        }
        this.currentElement.setText(string);
        this.currentElement.setCaretPosition(0);
    }

    private void fireBinding(int n) {
        if (n >= 0 && n < this.bindings.length) {
            this.simulation.getBreakpointManager().clearLog();
            try {
                this.bindings[n].execute(!this.simulation.isStrictlySequential());
            }
            catch (RemoteException remoteException) {
                logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
                JOptionPane.showMessageDialog(this.frame, "A problem occurred: " + remoteException + "\n" + "See the console for details.", "Binding selection frame", 0);
            }
            this.simulation.simulationRefresh();
            this.update();
        } else {
            this.fireButton.setEnabled(false);
        }
    }

    private void setup(TransitionInstanceAccessor transitionInstanceAccessor, CPNSimulation cPNSimulation) {
        this.transitionInstance = transitionInstanceAccessor;
        this.wantClose = false;
        this.simulation = cPNSimulation;
        try {
            this.frame.setTitle(transitionInstanceAccessor.asString() + "'s possible bindings");
        }
        catch (RemoteException remoteException) {
            logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
            JOptionPane.showMessageDialog(this.frame, "A problem occurred: " + remoteException + "\n" + "See the console for details.", "Binding selection frame", 0);
        }
        this.update();
    }

    public void proposeSearch() {
        this.update();
    }

    public void timeAdvanced() {
        this.update();
    }

    public void update() {
        SimulationThreadPool.getCurrent().execute((Runnable)new BindingListUpdater());
    }

    private void setActiveBindings(BindingAccessor[] bindingAccessorArray, String[] stringArray, String[] stringArray2) {
        this.bindings = bindingAccessorArray;
        this.fullBindingText = stringArray;
        this.bindingListModel.clear();
        for (int i = 0; i < stringArray2.length; ++i) {
            this.bindingListModel.addElement(stringArray2[i]);
        }
        String string = "";
        if (this.bindings.length > 0) {
            this.bindingList.setSelectedIndex(0);
            string = this.fullBindingText[0];
        }
        this.currentElement.setText(string);
        this.currentElement.setCaretPosition(0);
        this.fireButton.setEnabled(this.bindings.length > 0);
    }

    private class BindingListUpdater
    extends Thread {
        private BindingListUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = BindingSelectionFrame.this.updateSynchronizer;
            synchronized (object) {
                if (BindingSelectionFrame.this.inSearch) {
                    BindingSelectionFrame.this.dirty = true;
                    return;
                }
                if (BindingSelectionFrame.this.wantClose) {
                    BindingSelectionFrame.this.closeNow();
                    return;
                }
                BindingSelectionFrame.this.dirty = false;
                BindingSelectionFrame.this.inSearch = true;
            }
            while (true) {
                if (BindingSelectionFrame.this.transitionInstance != null) {
                    this.update();
                }
                object = BindingSelectionFrame.this.updateSynchronizer;
                synchronized (object) {
                    if (BindingSelectionFrame.this.wantClose) {
                        BindingSelectionFrame.this.closeNow();
                        BindingSelectionFrame.this.dirty = false;
                    }
                    if (!BindingSelectionFrame.this.dirty) {
                        BindingSelectionFrame.this.inSearch = false;
                        return;
                    }
                    BindingSelectionFrame.this.dirty = false;
                }
            }
        }

        public void update() {
            BindingAccessor[] bindingAccessorArray;
            try {
                bindingAccessorArray = BindingSelectionFrame.this.transitionInstance.findAllBindings(BindingSelectionFrame.this.triggerableForwarder);
            }
            catch (RemoteException remoteException) {
                logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
                return;
            }
            final String[] stringArray = new String[bindingAccessorArray.length];
            final String[] stringArray2 = new String[bindingAccessorArray.length];
            for (int i = 0; i < bindingAccessorArray.length; ++i) {
                try {
                    stringArray[i] = bindingAccessorArray[i].getDescription();
                }
                catch (RemoteException remoteException) {
                    logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
                    stringArray[i] = remoteException.toString();
                }
                stringArray2[i] = StringUtil.unspace((String)stringArray[i]);
                if (stringArray2[i].length() <= 50) continue;
                stringArray2[i] = stringArray2[i].substring(0, 47) + "...";
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BindingSelectionFrame.this.setActiveBindings(bindingAccessorArray, stringArray, stringArray2);
                    if (frameOpened) {
                        BindingSelectionFrame.this.frame.setVisible(true);
                    }
                }
            });
        }
    }
}

