/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class BreakpointDecoration {
    public static Logger logger = Logger.getLogger(BreakpointDecoration.class);
    private static ImageIcon icon = null;
    private static boolean failed = false;
    private static int iconWidth = 0;

    private BreakpointDecoration() {
    }

    private static ImageIcon getIcon() {
        if (icon == null && !failed) {
            String string = "/de/renew/gui/images/BP_TAG.gif";
            URL uRL = BreakpointDecoration.class.getResource(string);
            if (uRL == null) {
                logger.warn((Object)("Could not retrieve icon via class loader, trying file system: " + string));
                File file = new File(string);
                if (!file.isFile()) {
                    logger.warn((Object)("Icon file is not a regular file: " + file));
                } else {
                    try {
                        uRL = file.toURI().toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        logger.warn((Object)("Icon file is not valid as URL: " + file), (Throwable)malformedURLException);
                    }
                }
            }
            if (uRL == null) {
                failed = true;
            } else {
                icon = new ImageIcon(uRL);
                iconWidth = icon.getImage().getWidth(null);
            }
        }
        return icon;
    }

    public static void draw(Graphics graphics, Rectangle rectangle) {
        ImageIcon imageIcon = BreakpointDecoration.getIcon();
        if (imageIcon != null) {
            imageIcon.paintIcon(null, graphics, rectangle.x + rectangle.width - iconWidth, rectangle.y);
        }
    }
}

