/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.standard.FigureException;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.CommandMenuItem;
import de.renew.application.SimulationEnvironment;
import de.renew.application.SimulatorExtension;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.gui.Breakpoint;
import de.renew.gui.BreakpointHitEvent;
import de.renew.gui.BreakpointHitListener;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNDrawingLoader;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.CPNSimulation;
import de.renew.gui.ClearAllBreakpointsCommand;
import de.renew.gui.GuiPlugin;
import de.renew.gui.InstanceFigure;
import de.renew.gui.ModeReplacement;
import de.renew.gui.PlaceFigure;
import de.renew.gui.PlaceInstanceBreakpoint;
import de.renew.gui.ToggleBreakpointCommand;
import de.renew.gui.TransitionFigure;
import de.renew.gui.TransitionInstanceBreakpoint;
import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.net.Transition;
import de.renew.net.TransitionInstance;
import de.renew.net.event.PlaceEventProducer;
import de.renew.net.event.TransitionEventProducer;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.RemotePlugin;
import de.renew.shadow.ShadowLookup;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class BreakpointManager
implements SimulatorExtension {
    private static final int MENU_SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    public static Logger logger = Logger.getLogger(BreakpointManager.class);
    private CPNSimulation simulation;
    private CommandMenu breakpointSimulationMenu = null;
    private CommandMenu breakpointNetMenu = null;
    private Vector<Breakpoint> breakpoints = new Vector();
    private Vector<BreakpointHitListener> breakpointHitListeners = new Vector();
    private Map<Breakpoint, JMenuItem> breakpointMenuItems = new HashMap<Breakpoint, JMenuItem>();
    private StringBuffer messageMemory = new StringBuffer();

    public BreakpointManager(CPNSimulation cPNSimulation) {
        this.setSimulation(cPNSimulation);
    }

    public void setSimulation(CPNSimulation cPNSimulation) {
        this.simulation = cPNSimulation;
    }

    public JMenu getNetMenu() {
        if (this.breakpointNetMenu == null) {
            this.breakpointNetMenu = this.createSetMenu("Breakpoint", 12);
            this.breakpointNetMenu.addSeparator();
            this.breakpointNetMenu.add((Command)new ToggleBreakpointCommand("none", this, 2, 12), 67, MENU_SHORTCUT_KEY_MASK + 512);
        }
        return this.breakpointNetMenu;
    }

    public CPNApplication getGui() {
        return (CPNApplication)DrawPlugin.getGui();
    }

    public JMenu getSimulationMenu() {
        if (this.breakpointSimulationMenu == null) {
            CommandMenu commandMenu = DrawApplication.createCommandMenu((String)"Breakpoints");
            commandMenu.add((JMenuItem)this.createSetMenus("Set BP at selection"));
            commandMenu.add((JMenuItem)this.createClearMenus("Clear BP at selection"));
            commandMenu.add((Command)new ClearAllBreakpointsCommand("Clear all BPs in current simulation", this, this.simulation), 67, MENU_SHORTCUT_KEY_MASK + 512);
            commandMenu.addSeparator();
            this.breakpointSimulationMenu = commandMenu;
        }
        return this.breakpointSimulationMenu;
    }

    protected CommandMenu createSetMenus(String string) {
        CommandMenu commandMenu = DrawApplication.createCommandMenu((String)string);
        commandMenu.add((JMenuItem)this.createSetMenu("local", 11));
        commandMenu.add((JMenuItem)this.createSetMenu("global", 10));
        return commandMenu;
    }

    protected CommandMenu createSetMenu(String string, int n) {
        CommandMenu commandMenu = DrawApplication.createCommandMenu((String)string);
        int n2 = 66;
        if (n == 10) {
            n2 = 71;
        }
        commandMenu.add((Command)new ToggleBreakpointCommand("default (t,p)", this, 1, n), n2, MENU_SHORTCUT_KEY_MASK + 512);
        commandMenu.add((Command)new ToggleBreakpointCommand("firing starts (t)", this, 1, n, 1));
        commandMenu.add((Command)new ToggleBreakpointCommand("firing completes (t)", this, 1, n, 2));
        commandMenu.add((Command)new ToggleBreakpointCommand("marking changes (p)", this, 1, n, 3));
        commandMenu.add((Command)new ToggleBreakpointCommand("marking changes, ignoring test arcs (p)", this, 1, n, 5));
        commandMenu.add((Command)new ToggleBreakpointCommand("+ 1 token (p)", this, 1, n, 6));
        commandMenu.add((Command)new ToggleBreakpointCommand("- 1 token (p)", this, 1, n, 7));
        commandMenu.add((Command)new ToggleBreakpointCommand("test status changes (p)", this, 1, n, 8));
        return commandMenu;
    }

    protected CommandMenu createClearMenus(String string) {
        CommandMenu commandMenu = DrawApplication.createCommandMenu((String)string);
        commandMenu.add((JMenuItem)this.createClearMenu("local", 11));
        commandMenu.add((JMenuItem)this.createClearMenu("global", 10));
        return commandMenu;
    }

    protected CommandMenu createClearMenu(String string, int n) {
        CommandMenu commandMenu = DrawApplication.createCommandMenu((String)string);
        commandMenu.add((JMenuItem)new CommandMenuItem((Command)new ToggleBreakpointCommand("any type", this, 2, n)));
        return commandMenu;
    }

    protected CommandMenu createBPMenu(final Breakpoint breakpoint) {
        CommandMenu commandMenu = DrawApplication.createCommandMenu((String)breakpoint.toString());
        commandMenu.add(DrawApplication.createMenuItem((String)"show", (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BreakpointManager.this.showBreakpoint(breakpoint);
            }
        }));
        commandMenu.add(DrawApplication.createMenuItem((String)"clear", (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BreakpointManager.this.deleteBreakpoint(breakpoint);
            }
        }));
        return commandMenu;
    }

    public Breakpoint createTransitionInstanceBreakpoint(TransitionInstance transitionInstance, int n) {
        return this.createTransitionListenerBreakpoint((TransitionEventProducer)transitionInstance, n, transitionInstance.getNetInstance().getNet());
    }

    public Breakpoint createTransitionBreakpoint(Transition transition, int n, Net net) {
        return this.createTransitionListenerBreakpoint((TransitionEventProducer)transition, n, net);
    }

    private Breakpoint createTransitionListenerBreakpoint(TransitionEventProducer transitionEventProducer, int n, Net net) {
        if (!BreakpointManager.isValidTransitionMode(n)) {
            return null;
        }
        TransitionInstanceBreakpoint transitionInstanceBreakpoint = new TransitionInstanceBreakpoint(this, transitionEventProducer, n, net);
        this.addBreakpoint(transitionInstanceBreakpoint);
        return transitionInstanceBreakpoint;
    }

    public Breakpoint createPlaceInstanceBreakpoint(PlaceInstance placeInstance, int n) {
        return this.createPlaceListenerBreakpoint((PlaceEventProducer)placeInstance, n, placeInstance.getNetInstance().getNet());
    }

    public Breakpoint createPlaceBreakpoint(Place place, int n, Net net) {
        return this.createPlaceListenerBreakpoint((PlaceEventProducer)place, n, net);
    }

    private Breakpoint createPlaceListenerBreakpoint(PlaceEventProducer placeEventProducer, int n, Net net) {
        if (!BreakpointManager.isValidPlaceMode(n)) {
            return null;
        }
        PlaceInstanceBreakpoint placeInstanceBreakpoint = new PlaceInstanceBreakpoint(this, placeEventProducer, n, net);
        this.addBreakpoint(placeInstanceBreakpoint);
        return placeInstanceBreakpoint;
    }

    public List<Breakpoint> getBreakpointsAt(Object object) {
        ArrayList<Breakpoint> arrayList = new ArrayList<Breakpoint>();
        for (Breakpoint breakpoint : this.breakpoints) {
            if (breakpoint.getTaggedElement() != object) continue;
            arrayList.add(breakpoint);
        }
        return arrayList;
    }

    public boolean isBreakpointSetAt(Object object) {
        for (Breakpoint breakpoint : this.breakpoints) {
            if (breakpoint.getTaggedElement() != object) continue;
            return true;
        }
        return false;
    }

    public int deleteBreakpointsAt(Object object) {
        List<Breakpoint> list = this.getBreakpointsAt(object);
        for (Breakpoint breakpoint : list) {
            this.deleteBreakpoint(breakpoint);
        }
        return list.size();
    }

    public void deleteAllBreakpoints() {
        int n;
        while ((n = this.breakpoints.size()) > 0) {
            this.deleteBreakpoint(this.breakpoints.get(n - 1));
        }
    }

    public void deleteBreakpoint(Breakpoint breakpoint) {
        breakpoint.release();
        this.removeBreakpoint(breakpoint);
    }

    protected void addPresetBreakpoints(ShadowLookup shadowLookup) {
        CPNDrawingLoader cPNDrawingLoader = ModeReplacement.getInstance().getDrawingLoader();
        Iterator iterator = shadowLookup.allNewlyCompiledNetNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Net net = shadowLookup.getNet(string);
            CPNDrawing cPNDrawing = cPNDrawingLoader.getDrawing(string, false);
            if (cPNDrawing == null) {
                logger.debug((Object)("BreakpointManager: Could not add preset breakpoints for net " + string + ": no drawing found."));
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(BreakpointManager.class.getName() + ": Looking for breakpoints in " + string));
            }
            FigureEnumeration figureEnumeration = cPNDrawing.figures();
            while (figureEnumeration.hasMoreElements()) {
                Breakpoint breakpoint;
                int n;
                Figure figure = figureEnumeration.nextFigure();
                Integer n2 = (Integer)figure.getAttribute("BreakpointMode");
                if (n2 == null) continue;
                if (figure instanceof TransitionFigure) {
                    TransitionFigure transitionFigure = (TransitionFigure)figure;
                    n = transitionFigure.getID();
                    Transition transition = net.getTransitionWithID(new NetElementID(n));
                    if (transition == null) {
                        logger.warn((Object)(BreakpointManager.class.getName() + ": Found no Transition for Breakpoint on Figure " + transitionFigure));
                        continue;
                    }
                    breakpoint = this.createTransitionBreakpoint(transition, n2, net);
                    logger.debug((Object)("Created Breapoint: " + breakpoint));
                    continue;
                }
                if (!(figure instanceof PlaceFigure)) continue;
                PlaceFigure placeFigure = (PlaceFigure)figure;
                n = placeFigure.getID();
                Place place = net.getPlaceWithID(new NetElementID(n));
                if (place == null) {
                    logger.warn((Object)(BreakpointManager.class.getName() + ": Found no Place for Breakpoint on Figure " + placeFigure));
                    continue;
                }
                breakpoint = this.createPlaceBreakpoint(place, n2, net);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Created Breapoint: " + breakpoint));
            }
        }
    }

    private void addBreakpoint(Breakpoint breakpoint) {
        this.breakpoints.add(breakpoint);
        JMenuItem jMenuItem = this.breakpointSimulationMenu.add((JMenuItem)this.createBPMenu(breakpoint));
        this.breakpointMenuItems.put(breakpoint, jMenuItem);
    }

    private void removeBreakpoint(Breakpoint breakpoint) {
        this.breakpoints.remove(breakpoint);
        JMenuItem jMenuItem = this.breakpointMenuItems.remove(breakpoint);
        this.breakpointSimulationMenu.remove(jMenuItem);
    }

    protected void stopSimulation() {
        SimulationThreadPool.getCurrent().execute(new Runnable(){

            @Override
            public void run() {
                BreakpointManager.this.simulation.simulationStop();
            }
        });
    }

    protected void informHitBreakpoint(Breakpoint breakpoint) {
        BreakpointHitEvent breakpointHitEvent = new BreakpointHitEvent(breakpoint);
        BreakpointHitListener[] breakpointHitListenerArray = this.breakpointHitListeners.toArray(new BreakpointHitListener[0]);
        for (int i = 0; i < breakpointHitListenerArray.length; ++i) {
            breakpointHitListenerArray[i].hitBreakpoint(breakpointHitEvent);
        }
        if (!breakpointHitEvent.isConsumed()) {
            this.showHitBreakpoint(breakpoint);
        }
    }

    protected void showHitBreakpoint(final Breakpoint breakpoint) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DrawPlugin.getGui().showStatus("A breakpoint was hit: " + breakpoint + ".");
                FigureException figureException = BreakpointManager.this.locateBreakpoint(breakpoint, true);
                if (figureException != null) {
                    GuiPlugin.getCurrent().processFigureException(figureException, true);
                }
            }
        });
    }

    protected void showBreakpoint(Breakpoint breakpoint) {
        assert (EventQueue.isDispatchThread()) : "showBreakpoint must be called within AWT event queue.";
        DrawPlugin.getGui().showStatus("Selecting " + breakpoint + ".");
        FigureException figureException = this.locateBreakpoint(breakpoint, false);
        if (figureException != null) {
            this.getGui().selectOffendingElements(figureException);
        }
    }

    public void addBreakpointHitListener(BreakpointHitListener breakpointHitListener) {
        this.breakpointHitListeners.add(breakpointHitListener);
    }

    public void removeBreakpointHitListener(BreakpointHitListener breakpointHitListener) {
        this.breakpointHitListeners.remove(breakpointHitListener);
    }

    public void clearLog() {
        this.messageMemory = new StringBuffer();
    }

    private FigureException locateBreakpoint(Breakpoint breakpoint, boolean bl) {
        String string;
        Object object;
        Object object2;
        String string2 = "";
        Net net = null;
        NetInstance netInstance = null;
        int n = 0;
        Object object3 = object2 = bl ? breakpoint.getHitElement() : breakpoint.getTaggedElement();
        if (object2 instanceof PlaceInstance) {
            object = (PlaceInstance)object2;
            n = object.getPlace().getID().getFigureID();
            netInstance = object.getNetInstance();
            net = netInstance.getNet();
            if (bl) {
                string2 = "Hit " + breakpoint + ".";
            }
        } else if (object2 instanceof TransitionInstance) {
            object = (TransitionInstance)object2;
            n = object.getTransition().getID().getFigureID();
            netInstance = object.getNetInstance();
            net = netInstance.getNet();
            if (bl) {
                string2 = "Hit " + breakpoint + ".";
            }
        } else if (object2 instanceof Transition) {
            object = (Transition)object2;
            n = object.getID().getFigureID();
            net = breakpoint.getTaggedNet();
        } else if (object2 instanceof Place) {
            object = (Place)object2;
            n = object.getID().getFigureID();
            net = breakpoint.getTaggedNet();
        } else {
            logger.error((Object)("Cannot determine the location of breakpoint at " + object2 + "!?"));
            return null;
        }
        if (bl) {
            string = this.messageMemory.toString() + "\n" + string2;
            this.messageMemory.append("(");
            this.messageMemory.append(string2);
            this.messageMemory.append(")\n");
        } else {
            string = string2;
        }
        object = net.getName();
        CPNDrawing cPNDrawing = ModeReplacement.getInstance().getDrawingLoader().getDrawing((String)object);
        if (cPNDrawing == null) {
            string2 = string2 + "\nSorry, cannot show the location of breakpoint at " + object2 + " because net " + (String)object + " is not loaded.";
            this.getGui().showStatus(string2);
            logger.error((Object)string2);
            return null;
        }
        if (netInstance == null) {
            FigureWithID figureWithID = cPNDrawing.getFigureWithID(n);
            return new FigureException("Renew: Breakpoint", string, (Drawing)cPNDrawing, (Figure)figureWithID);
        }
        try {
            if (RemotePlugin.getInstance() != null) {
                NetInstanceAccessor netInstanceAccessor = RemotePlugin.getInstance().wrapInstance(netInstance);
                this.getGui().openInstanceDrawing(netInstanceAccessor);
                CPNInstanceDrawing cPNInstanceDrawing = CPNInstanceDrawing.getInstanceDrawing(netInstanceAccessor);
                FigureWithID figureWithID = cPNDrawing.getFigureWithID(n);
                InstanceFigure instanceFigure = cPNInstanceDrawing.getInstanceFigure((Figure)figureWithID);
                return new FigureException("Renew: Breakpoint", string, (Drawing)cPNInstanceDrawing, (Figure)instanceFigure);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
            return null;
        }
    }

    public void simulationSetup(SimulationEnvironment simulationEnvironment) {
    }

    public void netsCompiled(ShadowLookup shadowLookup) {
        if (shadowLookup.containsNewlyCompiledNets()) {
            this.addPresetBreakpoints(shadowLookup);
        }
        this.clearLog();
    }

    public void simulationTerminated() {
        this.deleteAllBreakpoints();
        this.clearLog();
    }

    public void simulationTerminating() {
    }

    public static boolean isValidTransitionMode(int n) {
        return n == 1 || n == 2 || n == 0;
    }

    public static boolean isValidPlaceMode(int n) {
        return n == 3 || n == 5 || n == 6 || n == 7 || n == 8 || n == 0;
    }
}

