/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.application.DrawingViewContainer;
import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.DrawingListener;
import CH.ifa.draw.util.Palette;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.searchqueue.TimeListener;
import de.renew.gui.ArcConnection;
import de.renew.gui.BindingSelectionFrame;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNDrawingView;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.CPNSelectionTool;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.CPNTextTool;
import de.renew.gui.DeclarationFigure;
import de.renew.gui.DoubleArcConnection;
import de.renew.gui.FigureExceptionFactory;
import de.renew.gui.GuiPlugin;
import de.renew.gui.ModeReplacement;
import de.renew.gui.PlaceFigureCreationTool;
import de.renew.gui.TokenBagDrawing;
import de.renew.gui.TransitionFigureCreationTool;
import de.renew.gui.VirtualPlaceFigureCreationTool;
import de.renew.io.RNWFileFilter;
import de.renew.plugin.PluginManager;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.shadow.ShadowCompilerFactory;
import de.renew.shadow.SyntaxException;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.rmi.RemoteException;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class CPNApplication
extends DrawApplication
implements DrawingListener {
    public static Logger logger = Logger.getLogger(CPNApplication.class);
    public static final String CPNIMAGES = "/de/renew/gui/images/";
    private static final Color INSTANCE_COLOR = new Color(200, 200, 255);
    private static final Color TOKEN_BAG_COLOR = new Color(230, 230, 255);
    private ToolButton fInscrTB;
    private ToolButton fNameTB;
    private ToolButton fDeclTB;
    private ToolButton fAuxTB;
    private GuiPlugin fPlugin;

    protected CPNApplication(GuiPlugin guiPlugin) {
        this(new String[0], guiPlugin);
    }

    protected CPNApplication(String[] stringArray, GuiPlugin guiPlugin) {
        super("Reference Net Workshop", "de.renew.gui.CPNDrawing", (SimpleFileFilter)new RNWFileFilter(), stringArray, "/de/renew/gui/images/RENEW.gif");
        this.addDrawingListener(this);
        this.fPlugin = guiPlugin;
        if (this.fPlugin != null) {
            this.fPlugin.notifyGuiStart(this);
        }
    }

    public ShadowCompilerFactory getDefaultCompilerFactory() {
        return ModeReplacement.getInstance().getDefaultCompilerFactory();
    }

    protected Drawing createDrawing() {
        return new CPNDrawing();
    }

    protected DrawApplication newWindow() {
        return new CPNApplication(this.fPlugin);
    }

    void cleanupSimulationWindows() {
        this.showStatus("Simulation terminated.");
        BindingSelectionFrame.close();
        this.closeAllSimulationDrawings();
    }

    void closeAllSimulationDrawings() {
        boolean bl;
        block0: do {
            bl = false;
            Enumeration enumeration = this.drawings();
            while (enumeration.hasMoreElements()) {
                Drawing drawing = (Drawing)enumeration.nextElement();
                if (!(drawing instanceof CPNInstanceDrawing) && !(drawing instanceof TokenBagDrawing)) continue;
                this.closeDrawing(drawing);
                bl = true;
                continue block0;
            }
        } while (bl);
    }

    public void openNetPatternDrawing(String string) {
        this.openNetPatternDrawing(string, 0);
    }

    public void openNetPatternDrawing(String string, int n) {
        DrawingViewContainer drawingViewContainer = this.internalShowNetPatternDrawing(string, n);
        if (drawingViewContainer != null) {
            drawingViewContainer.getFrame().toFront();
        }
    }

    protected DrawingViewContainer internalShowNetPatternDrawing(String string, int n) {
        Object object;
        Enumeration enumeration = this.drawings();
        CPNDrawing cPNDrawing = null;
        while (enumeration.hasMoreElements() && cPNDrawing == null) {
            object = enumeration.nextElement();
            if (!(object instanceof CPNDrawing) || !((CPNDrawing)object).getName().equals(string)) continue;
            cPNDrawing = (CPNDrawing)object;
        }
        if (cPNDrawing == null) {
            cPNDrawing = ModeReplacement.getInstance().getDrawingLoader().getDrawing(string);
        }
        if (cPNDrawing != null) {
            FigureWithID figureWithID;
            object = this.getViewContainer((Drawing)cPNDrawing);
            DrawingViewContainer drawingViewContainer = this.showDrawingViewContainer((Drawing)cPNDrawing, object.getLocation(), object.getSize());
            if (n != 0 && (figureWithID = cPNDrawing.getFigureWithID(n)) != null) {
                DrawingView drawingView = drawingViewContainer.view();
                drawingView.clearSelection();
                drawingView.addToSelection((Figure)figureWithID);
                drawingView.repairDamage();
            }
            return drawingViewContainer;
        }
        return null;
    }

    protected StandardDrawingView createDrawingView(int n, int n2) {
        return new CPNDrawingView((DrawingEditor)this, n, n2);
    }

    protected Component wrapStatusLine(Component component) {
        boolean bl = ModeReplacement.getInstance().getSimulation().isStrictlySequential();
        if (bl) {
            JTextField jTextField;
            JPanel jPanel = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            jPanel.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(component, gridBagConstraints);
            jPanel.add(component);
            if (component instanceof JTextField) {
                jTextField = (JTextField)component;
                jTextField.setColumns(jTextField.getColumns() - 23);
            }
            jTextField = new JTextField("0.0", 23);
            SearchQueue.insertTimeListener((TimeListener)new TimeListener(){

                public void timeAdvanced() {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jTextField.setText(String.valueOf(SearchQueue.getTime()));
                        }
                    });
                }
            });
            jTextField.setEditable(false);
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(jTextField, gridBagConstraints);
            jPanel.add(jTextField);
            return jPanel;
        }
        return component;
    }

    public void drawingAdded(Drawing drawing) {
        if (drawing instanceof CPNDrawing) {
            ModeReplacement.getInstance().getDrawingLoader();
            logger.debug((Object)("drawing loaded: " + drawing.getName()));
            ModeReplacement.getInstance().getDrawingLoader().addDrawing((CPNDrawing)drawing);
        }
        if (drawing instanceof CPNInstanceDrawing || drawing instanceof TokenBagDrawing) {
            this.noUndoHistoryFor(drawing);
        }
    }

    public void drawingReleased(Drawing drawing) {
        if (drawing instanceof CPNDrawing) {
            ModeReplacement.getInstance().getDrawingLoader().releaseDrawing((CPNDrawing)drawing);
        }
    }

    boolean syntaxCheck() {
        if (ModeReplacement.getInstance().getSimulation().isSimulationActive()) {
            this.showStatus("Terminate the current simulation before a syntax check.");
        } else {
            try {
                ModeReplacement.getInstance().getSimulation().syntaxCheckOnly();
                this.showStatus("Syntax check successful.");
                GuiPlugin.getCurrent().closeSyntaxErrorFrame();
                return true;
            }
            catch (SyntaxException syntaxException) {
                logger.debug((Object)syntaxException.getMessage(), (Throwable)syntaxException);
                GuiPlugin.getCurrent().processSyntaxException(FigureExceptionFactory.createFigureException(syntaxException), true);
            }
        }
        return false;
    }

    public JFrame getFrame() {
        return super.getFrame();
    }

    public void openInstanceDrawing(NetInstanceAccessor netInstanceAccessor) {
        assert (EventQueue.isDispatchThread()) : "Must be called within AWT event thread.";
        try {
            CPNInstanceDrawing cPNInstanceDrawing = CPNInstanceDrawing.getInstanceDrawing(netInstanceAccessor);
            if (cPNInstanceDrawing != null) {
                boolean bl = this.getViewContainer((Drawing)cPNInstanceDrawing) == null;
                CPNDrawing cPNDrawing = ModeReplacement.getInstance().getDrawingLoader().getDrawing(netInstanceAccessor.getNet().asString());
                DrawingViewContainer drawingViewContainer = this.getViewContainer((Drawing)cPNDrawing);
                DrawingViewContainer drawingViewContainer2 = this.showDrawingViewContainer((Drawing)cPNInstanceDrawing, drawingViewContainer.getLocation(), drawingViewContainer.getSize());
                if (bl) {
                    drawingViewContainer2.onDiscardRelease();
                    drawingViewContainer2.view().setBackground(INSTANCE_COLOR);
                    drawingViewContainer2.validate();
                }
            }
        }
        catch (RemoteException remoteException) {
            logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
            JOptionPane.showMessageDialog(null, "A problem occurred: " + remoteException + "\n" + "See the console for details.", "Renew", 0);
        }
    }

    public void openTokenBagDrawing(PlaceInstanceAccessor placeInstanceAccessor) throws RemoteException {
        TokenBagDrawing tokenBagDrawing = TokenBagDrawing.getTokenBagDrawing(placeInstanceAccessor);
        boolean bl = this.getViewContainer((Drawing)tokenBagDrawing) == null;
        CPNInstanceDrawing cPNInstanceDrawing = CPNInstanceDrawing.getInstanceDrawing(placeInstanceAccessor.getNetInstance());
        DrawingViewContainer drawingViewContainer = this.getViewContainer((Drawing)cPNInstanceDrawing);
        DrawingViewContainer drawingViewContainer2 = this.showDrawingViewContainer((Drawing)tokenBagDrawing, drawingViewContainer.getLocation(), null);
        if (bl) {
            drawingViewContainer2.onDiscardRelease();
            drawingViewContainer2.view().setBackground(TOKEN_BAG_COLOR);
        }
    }

    protected boolean closeViewContainer(DrawingViewContainer drawingViewContainer) {
        Enumeration<CPNInstanceDrawing> enumeration;
        Drawing drawing = drawingViewContainer.view().drawing();
        if (drawing instanceof CPNDrawing && (enumeration = CPNInstanceDrawing.getDependentInstanceDrawings((CPNDrawing)drawing)) != null) {
            this.showDrawingViewContainer(drawing);
            int n = JOptionPane.showConfirmDialog(this.menuFrame, new String[]{"The drawing \"" + drawing.getName() + "\" " + "you are about to close", "is needed to display one or more instance drawings."}, "Renew: Confirm Close", 2);
            if (n == 2) {
                return false;
            }
            while (enumeration.hasMoreElements()) {
                this.closeDrawing((Drawing)enumeration.nextElement());
            }
        }
        return super.closeViewContainer(drawingViewContainer);
    }

    protected void requestClose() {
        boolean bl = false;
        if (this.fPlugin != null) {
            bl = this.fPlugin.isShutdownOnClose();
        }
        if (bl) {
            this.showStatus("Shutting down plugin system...");
            this.fPlugin.doShutdownOnClose();
        } else {
            this.showStatus("Closing Renew Gui...");
            super.requestClose();
        }
    }

    public void exit() {
        BindingSelectionFrame.close();
        this.closeAllSimulationDrawings();
        super.exit();
    }

    protected void destroy() {
        if (this.fPlugin != null) {
            this.fPlugin.notifyGuiClosed(this);
            this.fPlugin = null;
        }
    }

    public boolean canClose() {
        if (!PluginManager.getInstance().isStopping() && ModeReplacement.getInstance().getSimulation().isSimulationActive()) {
            int n = JOptionPane.showConfirmDialog(this.menuFrame, "Renew: The simulation engine is still active.\nIt can continue running without graphical feedback.\n Do you want to terminate it now?");
            switch (n) {
                case 0: {
                    ModeReplacement.getInstance().getSimulation().simulationTerminate();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return false;
                }
            }
        }
        return super.canClose();
    }

    public ToolButton toolButtonForTextFigure(TextFigure textFigure) {
        if (textFigure instanceof CPNTextFigure) {
            if (textFigure instanceof DeclarationFigure) {
                return this.fDeclTB;
            }
            switch (((CPNTextFigure)textFigure).getType()) {
                case 3: {
                    if (this.fAuxTB != null) {
                        return this.fAuxTB;
                    }
                    return this.fInscrTB;
                }
                case 1: {
                    return this.fInscrTB;
                }
                case 2: {
                    return this.fNameTB;
                }
            }
        }
        return super.toolButtonForTextFigure(textFigure);
    }

    protected void createTools(JPanel jPanel) {
        super.createTools(jPanel);
        Palette palette = new Palette("Petri Net Tools");
        Object object = null;
        object = new TransitionFigureCreationTool((DrawingEditor)this);
        palette.add(this.createToolButton("/de/renew/gui/images/TRANS", "Transition Tool", (Tool)object));
        object = new PlaceFigureCreationTool((DrawingEditor)this);
        palette.add(this.createToolButton("/de/renew/gui/images/PLACE", "Place Tool", (Tool)object));
        object = new VirtualPlaceFigureCreationTool((DrawingEditor)this);
        palette.add(this.createToolButton("/de/renew/gui/images/VPLACE", "Virtual Place Tool", (Tool)object));
        object = new ConnectionTool((DrawingEditor)this, (ConnectionFigure)ArcConnection.NormalArc);
        palette.add(this.createToolButton("/de/renew/gui/images/ARC", "Arc Tool", (Tool)object));
        object = new ConnectionTool((DrawingEditor)this, (ConnectionFigure)ArcConnection.TestArc);
        palette.add(this.createToolButton("/CH/ifa/draw/images/LINE", "Test Arc Tool", (Tool)object));
        object = new ConnectionTool((DrawingEditor)this, (ConnectionFigure)ArcConnection.ReserveArc);
        palette.add(this.createToolButton("/CH/ifa/draw/images/CONN", "Reserve Arc Tool", (Tool)object));
        object = new ConnectionTool((DrawingEditor)this, (ConnectionFigure)DoubleArcConnection.DoubleArc);
        palette.add(this.createToolButton("/de/renew/gui/images/DARC", "Flexible Arc Tool", (Tool)object));
        object = new CPNTextTool((DrawingEditor)this, CPNTextFigure.Inscription);
        this.fInscrTB = this.createToolButton("/de/renew/gui/images/INSCR", "Inscription Tool", (Tool)object);
        palette.add(this.fInscrTB);
        object = new ConnectedTextTool((DrawingEditor)this, (TextFigure)CPNTextFigure.Name);
        this.fNameTB = this.createToolButton("/de/renew/gui/images/NAME", "Name Tool", (Tool)object);
        palette.add(this.fNameTB);
        object = new CPNTextTool((DrawingEditor)this, new DeclarationFigure(), false);
        this.fDeclTB = this.createToolButton("/de/renew/gui/images/DECL", "Declaration Tool", (Tool)object);
        palette.add(this.fDeclTB);
        jPanel.add(palette.getComponent());
    }

    protected Tool createSelectionTool() {
        return new CPNSelectionTool(this);
    }

    public void menuStateChanged() {
        JMenuBar jMenuBar = this.menuFrame.getJMenuBar();
        int n = jMenuBar.getMenuCount();
        for (int i = 0; i < n; ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            if (!(jMenu instanceof CommandMenu)) continue;
            ((CommandMenu)jMenu).checkEnabled();
            ((CommandMenu)jMenu).updateCommandText();
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("The CPNApplication class does no longer provide a stand-alone application.");
        System.out.println("Please run de.renew.plugin.PluginManager with the command \"gui\".");
        System.out.println("A simple command line is:");
        System.out.println("       java -jar loader.jar gui [filenames]");
    }
}

