/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeAdapter;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.framework.FilterContainer;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.DeclarationFigure;
import de.renew.gui.FigureWithHighlight;
import de.renew.gui.GraphLayout;
import de.renew.gui.LayoutableDrawing;
import de.renew.gui.NodeFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.ShadowHolder;
import de.renew.gui.TransitionFigure;
import de.renew.io.RNWFileFilter;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetElement;
import de.renew.shadow.ShadowNetSystem;
import java.awt.Dimension;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CPNDrawing
extends StandardDrawing
implements LayoutableDrawing {
    public static Logger logger = Logger.getLogger(CPNDrawing.class);
    private static FilterContainer filterContainer;
    protected transient ShadowNet shadowNet = null;
    private AbstractFigure iconFigure = null;
    private transient Hashtable<Figure, Figure> hilightMap = new Hashtable();
    private transient int maxUsedID = 0;
    private transient Hashtable<Integer, Figure> usedIDs = new Hashtable();

    public void release() {
        super.release();
        this.discardShadow();
    }

    public ShadowNet getShadow() {
        return this.shadowNet;
    }

    static CPNDrawing findDrawing(Object object) {
        if (object instanceof ShadowNetElement) {
            return (CPNDrawing)((ShadowNetElement)object).getNet().context;
        }
        return null;
    }

    public void discardShadow() {
        if (this.shadowNet != null) {
            this.shadowNet.discard();
            this.shadowNet = null;
        }
    }

    private void buildShadow(Class<?> clazz) {
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (!(figure instanceof ShadowHolder) || !clazz.isInstance(figure)) continue;
            ((ShadowHolder)figure).buildShadow(this.shadowNet);
        }
    }

    public ShadowNet buildShadow(ShadowNetSystem shadowNetSystem) {
        this.discardShadow();
        this.shadowNet = new ShadowNet(this.getName(), shadowNetSystem);
        this.shadowNet.context = this;
        this.buildShadow(DeclarationFigure.class);
        this.buildShadow(NodeFigure.class);
        this.buildShadow(LineConnection.class);
        this.buildShadow(CPNTextFigure.class);
        return this.shadowNet;
    }

    public void setIconFigure(AbstractFigure abstractFigure) {
        this.iconFigure = abstractFigure;
    }

    public Figure getIconFigure() {
        return this.iconFigure;
    }

    public Figure remove(Figure figure) {
        Figure figure2;
        if (figure == this.iconFigure) {
            this.iconFigure = null;
        }
        if (figure instanceof FigureWithID) {
            this.freeID((FigureWithID)figure);
        }
        if (figure instanceof FigureWithHighlight && (figure2 = ((FigureWithHighlight)figure).getHighlightFigure()) != null) {
            this.hilightMap.remove(figure2);
        }
        figure2 = super.remove(figure);
        if (figure instanceof CompositeFigure) {
            this.recomputeIDCache();
        }
        return figure2;
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeStorable((Storable)this.iconFigure);
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        if (storableInput.getVersion() >= 2) {
            try {
                this.iconFigure = (AbstractFigure)storableInput.readStorable();
            }
            catch (IOException iOException) {
                logger.error((Object)"Icon expected.");
                logger.debug((Object)"Icon expected.", (Throwable)iOException);
            }
            if (storableInput.getVersion() >= 3) {
                this.recomputeHilightMap();
            }
        }
        this.recomputeIDCache();
    }

    @Override
    public synchronized void fillInGraph(GraphLayout graphLayout) {
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (figure instanceof TransitionFigure || figure instanceof PlaceFigure || figure instanceof TextFigure && ((TextFigure)figure).parent() == null) {
                graphLayout.addNode(figure);
                continue;
            }
            if (!(figure instanceof ConnectionFigure)) continue;
            graphLayout.addEdge((ConnectionFigure)figure, 20);
        }
    }

    void setHighlightFigure(final FigureWithHighlight figureWithHighlight, final Figure figure) {
        Figure figure2 = figureWithHighlight.getHighlightFigure();
        if (figure2 != null) {
            this.hilightMap.remove(figure2);
        }
        figureWithHighlight.setHighlightFigure(figure);
        if (figure != null) {
            this.hilightMap.put(figure, (Figure)figureWithHighlight);
            figure.addFigureChangeListener((FigureChangeListener)new FigureChangeAdapter(){

                public void figureRemoved(FigureChangeEvent figureChangeEvent) {
                    CPNDrawing.this.setHighlightFigure(figureWithHighlight, null);
                }
            });
            figureWithHighlight.addFigureChangeListener((FigureChangeListener)new FigureChangeAdapter(){

                public void figureRemoved(FigureChangeEvent figureChangeEvent) {
                    CPNDrawing.this.hilightMap.remove(figure);
                }
            });
        }
    }

    FigureWithHighlight getFigureForHighlight(Figure figure) {
        try {
            return (FigureWithHighlight)this.hilightMap.get(figure);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public Dimension defaultSize() {
        return new Dimension(535, 788);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.hilightMap = new Hashtable();
        this.maxUsedID = 0;
        this.usedIDs = new Hashtable();
        this.recomputeIDCache();
        this.recomputeHilightMap();
    }

    private void recomputeHilightMap() {
        this.hilightMap.clear();
        this.addToHilightMap((CompositeFigure)this);
    }

    private void addToHilightMap(CompositeFigure compositeFigure) {
        FigureEnumeration figureEnumeration = compositeFigure.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure;
            Figure figure2 = figureEnumeration.nextFigure();
            if (figure2 instanceof FigureWithHighlight && (figure = ((FigureWithHighlight)figure2).getHighlightFigure()) != null) {
                this.hilightMap.put(figure, figure2);
            }
            if (!(figure2 instanceof CompositeFigure)) continue;
            this.addToHilightMap((CompositeFigure)figure2);
        }
    }

    public String getWindowCategory() {
        return "Nets";
    }

    public Figure add(Figure figure) {
        Figure figure2;
        if (figure instanceof FigureWithID) {
            this.checkAndAssignID((FigureWithID)figure);
        }
        Figure figure3 = super.add(figure);
        if (figure instanceof FigureWithHighlight && (figure2 = ((FigureWithHighlight)figure).getHighlightFigure()) != null) {
            this.hilightMap.put(figure2, figure);
        }
        if (figure instanceof CompositeFigure) {
            this.recomputeIDCache();
            this.recomputeHilightMap();
        }
        return figure3;
    }

    private void checkAndAssignID(FigureWithID figureWithID) {
        int n;
        int n2 = n = figureWithID.getID();
        FigureWithID figureWithID2 = (FigureWithID)this.usedIDs.get(new Integer(n));
        if (figureWithID2 != null && figureWithID2 != figureWithID) {
            n2 = 0;
        }
        if (n2 == 0) {
            n2 = this.newUniqueID();
            figureWithID.setID(n2);
        }
        this.usedIDs.put(new Integer(n2), (Figure)figureWithID);
    }

    public void assignID(FigureWithID figureWithID, int n) {
        FigureWithID figureWithID2 = (FigureWithID)this.usedIDs.get(new Integer(n));
        if (figureWithID2 != null && figureWithID2 != figureWithID) {
            throw new IllegalArgumentException("The id is already in use!");
        }
        this.usedIDs.remove(new Integer(figureWithID.getID()));
        figureWithID.setID(n);
        this.usedIDs.put(new Integer(n), (Figure)figureWithID);
    }

    private void freeID(FigureWithID figureWithID) {
        Integer n = new Integer(figureWithID.getID());
        if (this.usedIDs.get(n) == figureWithID) {
            this.usedIDs.remove(n);
        }
    }

    private int newUniqueID() {
        if (this.maxUsedID == 0) {
            this.recomputeIDCache();
        }
        ++this.maxUsedID;
        if (this.usedIDs.containsKey(new Integer(this.maxUsedID))) {
            boolean bl = false;
            while (this.usedIDs.containsKey(new Integer(this.maxUsedID))) {
                ++this.maxUsedID;
                if (this.maxUsedID != Integer.MIN_VALUE) continue;
                this.maxUsedID = 1;
                if (bl) {
                    throw new RuntimeException("Maximum numnber of figures exeeded.");
                }
                bl = true;
            }
        }
        return this.maxUsedID;
    }

    protected void recomputeIDCache() {
        Vector<Figure> vector = new Vector<Figure>();
        this.usedIDs.clear();
        this.addToIDCache((CompositeFigure)this, vector);
        Enumeration<Figure> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.checkAndAssignID((FigureWithID)enumeration.nextElement());
        }
    }

    private void addToIDCache(CompositeFigure compositeFigure, Vector<Figure> vector) {
        FigureEnumeration figureEnumeration = compositeFigure.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (figure instanceof FigureWithID) {
                int n = ((FigureWithID)figure).getID();
                FigureWithID figureWithID = (FigureWithID)this.usedIDs.get(new Integer(n));
                if (figureWithID == null || figureWithID == figure) {
                    this.usedIDs.put(new Integer(n), figure);
                    if (n <= this.maxUsedID) continue;
                    this.maxUsedID = n;
                    continue;
                }
                vector.addElement(figure);
                continue;
            }
            if (!(figure instanceof CompositeFigure)) continue;
            this.addToIDCache((CompositeFigure)figure, vector);
        }
    }

    public FigureWithID getFigureWithID(int n) {
        return (FigureWithID)this.usedIDs.get(new Integer(n));
    }

    public static FilterContainer getFilterContainer() {
        if (filterContainer == null) {
            return new FilterContainer((SimpleFileFilter)new RNWFileFilter());
        }
        return filterContainer;
    }

    public SimpleFileFilter getDefaultFileFilter() {
        return CPNDrawing.getFilterContainer().getDefaultFileFilter();
    }

    public HashSet<SimpleFileFilter> getImportFileFilters() {
        return CPNDrawing.getFilterContainer().getImportFileFilters();
    }

    public HashSet<SimpleFileFilter> getExportFileFilters() {
        return CPNDrawing.getFilterContainer().getExportFileFilters();
    }

    public String getDefaultExtension() {
        return this.getDefaultFileFilter().getExtension();
    }
}

