/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.IOHelper;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import de.renew.gui.CPNDrawing;
import de.renew.gui.HelperGui;
import de.renew.shadow.DefaultShadowNetLoader;
import de.renew.util.ClassSource;
import de.renew.util.StringUtil;
import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CPNDrawingLoader {
    public static Logger logger = Logger.getLogger(CPNDrawingLoader.class);
    private DefaultShadowNetLoader.PathEntry[] netSource;
    protected Vector<CPNDrawing> drawings = new Vector();

    public CPNDrawingLoader() {
        this.configureNetPath(System.getProperties());
    }

    void configureNetPath(Properties properties) {
        this.setNetPath(properties.getProperty("de.renew.netPath", System.getProperty("user.dir")));
    }

    void setNetPath(String string) {
        this.setNetPath(StringUtil.splitPaths((String)string));
    }

    void setNetPath(String[] stringArray) {
        this.netSource = DefaultShadowNetLoader.canonizePaths((String[])stringArray);
        if (logger.isDebugEnabled()) {
            for (int i = 0; i < this.netSource.length; ++i) {
                logger.debug((Object)("Drawing loader source" + (this.netSource[i].isClasspathRelative ? " (relative to CLASSPATH): " : ": ") + this.netSource[i].path));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDrawing(CPNDrawing cPNDrawing) {
        Vector<CPNDrawing> vector = this.drawings;
        synchronized (vector) {
            this.drawings.addElement(cPNDrawing);
            logger.debug((Object)("CPNDrawingLoader: added " + cPNDrawing.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseDrawing(CPNDrawing cPNDrawing) {
        Vector<CPNDrawing> vector = this.drawings;
        synchronized (vector) {
            this.drawings.removeElement(cPNDrawing);
        }
        cPNDrawing.discardShadow();
        logger.debug((Object)("CPNDrawingLoader: released " + cPNDrawing.getName()));
    }

    public Iterator<CPNDrawing> loadedDrawings() {
        if (logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator<CPNDrawing> iterator = this.drawings.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(' ');
                stringBuffer.append(iterator.next().getName());
            }
            logger.debug((Object)("CPNDrawingLoader: request for all drawings:" + stringBuffer));
        }
        return this.drawings.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPNDrawing getDrawing(String string, boolean bl) {
        logger.debug((Object)("CPNDrawingLoader: request for " + string + " (loader " + (bl ? "en" : "dis") + "abled)"));
        if (string == null) {
            return null;
        }
        Vector<CPNDrawing> vector = this.drawings;
        synchronized (vector) {
            CPNDrawing cPNDrawing;
            for (int i = 0; i < this.drawings.size(); ++i) {
                CPNDrawing cPNDrawing2 = this.drawings.elementAt(i);
                String string2 = cPNDrawing2.getName();
                if (!string.equals(string2)) continue;
                return cPNDrawing2;
            }
            if (bl && (cPNDrawing = this.findDrawingFile(string)) != null) {
                return cPNDrawing;
            }
        }
        return null;
    }

    CPNDrawing getDrawing(String string) {
        return this.getDrawing(string, true);
    }

    public CPNDrawing findDrawing(String string, SimpleFileFilter simpleFileFilter) {
        if (!this.drawingLoaded(string)) {
            for (DefaultShadowNetLoader.PathEntry pathEntry : this.netSource) {
                StatusRememberer statusRememberer;
                Drawing drawing;
                File file = new File(pathEntry.path + File.separator + string + "." + simpleFileFilter.getExtension());
                if (!file.canRead() || (drawing = DrawingFileHelper.loadDrawing((File)file, (StatusDisplayer)(statusRememberer = new StatusRememberer()))) == null || !(drawing instanceof CPNDrawing) || !drawing.getName().equals(string)) continue;
                return (CPNDrawing)drawing;
            }
        }
        return null;
    }

    private boolean drawingLoaded(String string) {
        for (int i = 0; i < this.drawings.size(); ++i) {
            CPNDrawing cPNDrawing = this.drawings.elementAt(i);
            String string2 = cPNDrawing.getName();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    CPNDrawing findDrawingFile(String string) {
        CPNDrawing cPNDrawing = this.getDrawing(string, false);
        if (cPNDrawing != null) {
            return cPNDrawing;
        }
        File file = null;
        for (int i = 0; i < this.netSource.length; ++i) {
            URL uRL;
            boolean bl;
            block17: {
                bl = false;
                uRL = null;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.netSource[i].path);
                if (!"".equals(this.netSource[i].path)) {
                    stringBuffer.append(File.separator);
                }
                stringBuffer.append(string);
                stringBuffer.append(".rnw");
                String string2 = stringBuffer.toString();
                logger.debug((Object)("looking for: " + string2));
                try {
                    if (this.netSource[i].isClasspathRelative) {
                        uRL = ClassSource.getClassLoader().getResource(StringUtil.convertToSlashes((String)string2));
                        bl = uRL == null;
                        break block17;
                    }
                    file = new File(string2);
                    boolean bl2 = bl = !file.canRead();
                    if (!bl) {
                        try {
                            uRL = file.toURI().toURL();
                        }
                        catch (MalformedURLException malformedURLException) {
                            logger.error((Object)("Could not transform drawing filename to URL: " + malformedURLException.getMessage()));
                            bl = true;
                        }
                    }
                    if (bl) {
                        file = null;
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)("CPN drawing loader: " + string2 + " caused " + exception));
                    bl = true;
                }
            }
            if (bl) continue;
            assert (uRL != null) : "error should be set if url==null.";
            StatusRememberer statusRememberer = new StatusRememberer();
            Drawing drawing = file != null ? DrawingFileHelper.loadDrawing((File)file, (StatusDisplayer)statusRememberer) : DrawingFileHelper.loadDrawing((URL)uRL, (StatusDisplayer)statusRememberer);
            if (drawing == null || !(drawing instanceof CPNDrawing)) continue;
            final IOHelper iOHelper = DrawPlugin.getCurrent().getIOHelper();
            if (iOHelper != null) {
                final URL uRL2 = uRL;
                if (SwingUtilities.isEventDispatchThread()) {
                    iOHelper.loadAndOpenDrawing(uRL2);
                } else {
                    try {
                        EventQueue.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                iOHelper.loadAndOpenDrawing(uRL2);
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        logger.error((Object)"Caught interrupt while loading drawing", (Throwable)interruptedException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        logger.error((Object)"Caught InvocationTargetException while loading drawing", (Throwable)invocationTargetException);
                    }
                }
            }
            return this.getDrawing(string, false);
        }
        HelperGui.loadRnwFileFromJar(string);
        CPNDrawing cPNDrawing2 = this.getDrawing(string, false);
        return cPNDrawing2;
    }

    private class StatusRememberer
    implements StatusDisplayer {
        private StatusRememberer() {
        }

        public void showStatus(String string) {
            logger.debug((Object)("CPNDrawingLoader: " + string));
        }
    }
}

