/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.application.IllegalCompilerException;
import de.renew.application.NoSimulationException;
import de.renew.application.SimulationEnvironment;
import de.renew.application.SimulationRunningException;
import de.renew.application.SimulatorExtension;
import de.renew.application.SimulatorExtensionAdapter;
import de.renew.application.SimulatorPlugin;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.engine.simulator.Simulator;
import de.renew.gui.BindingSelectionFrame;
import de.renew.gui.BreakpointManager;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNDrawingLoader;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.GuiPlugin;
import de.renew.gui.ModeReplacement;
import de.renew.net.NetInstance;
import de.renew.net.NetNotFoundException;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.RemotePlugin;
import de.renew.shadow.ShadowCompilerFactory;
import de.renew.shadow.ShadowNetSystem;
import de.renew.shadow.SyntaxException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class CPNSimulation {
    public static Logger logger = Logger.getLogger(CPNSimulation.class);
    protected ShadowNetSystem netSystem;
    private boolean sequentialOnly;
    private BreakpointManager breakpointManager = null;
    private CPNDrawingLoader drawingLoader;
    private SimulatorPlugin simulatorPlugin = SimulatorPlugin.getCurrent();
    public Exception lastSyntaxException;
    public boolean inGuiSetup;
    private SimulatorGuiCompilationExtension compilationExtension;

    public CPNSimulation(boolean bl, CPNDrawingLoader cPNDrawingLoader) {
        this.sequentialOnly = bl;
        this.drawingLoader = cPNDrawingLoader;
        this.inGuiSetup = false;
        this.lastSyntaxException = null;
        this.newNetSystem();
        this.compilationExtension = new SimulatorGuiCompilationExtension(this);
        this.simulatorPlugin.addExtension((SimulatorExtension)this.compilationExtension);
    }

    public boolean isStrictlySequential() {
        return this.sequentialOnly;
    }

    public void buildAllShadows() {
        this.newNetSystem();
        boolean bl = true;
        while (bl) {
            bl = false;
            Iterator<CPNDrawing> iterator = this.drawingLoader.loadedDrawings();
            try {
                while (iterator.hasNext()) {
                    CPNDrawing cPNDrawing = iterator.next();
                    logger.debug((Object)("CPNSimulation: Building shadow for drawing " + cPNDrawing + "."));
                    cPNDrawing.buildShadow(this.netSystem);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                logger.error((Object)"CPNSimulation.buildAllShadows(): Concurrent modification. Redo from start...");
                bl = true;
            }
        }
    }

    protected void newNetSystem() {
        try {
            this.simulatorPlugin.possiblySetupClassSource((Properties)this.simulatorPlugin.getProperties());
        }
        catch (IllegalStateException illegalStateException) {
            logger.warn((Object)"CPNSimulation: Cannot configure classReinit mode while a simulation is running.");
        }
        ShadowCompilerFactory shadowCompilerFactory = ModeReplacement.getInstance().getDefaultCompilerFactory();
        if (shadowCompilerFactory == null) {
            logger.warn((Object)"CPNSimulation: cannot start, got no compiler.");
        }
        this.netSystem = new ShadowNetSystem(shadowCompilerFactory);
        logger.debug((Object)"CPNSimulation: New net system created.");
    }

    public ShadowNetSystem getNetSystem() {
        this.buildAllShadows();
        return this.netSystem;
    }

    public CPNDrawingLoader getDrawingLoader() {
        return this.drawingLoader;
    }

    public void setBreakpointManager(BreakpointManager breakpointManager) {
        BreakpointManager breakpointManager2 = this.breakpointManager;
        this.breakpointManager = breakpointManager;
        if (breakpointManager2 != null) {
            this.simulatorPlugin.removeExtension((SimulatorExtension)breakpointManager2);
        }
        this.simulatorPlugin.addExtension((SimulatorExtension)breakpointManager);
    }

    public BreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    public SimulatorPlugin getSimulatorPlugin() {
        return this.simulatorPlugin;
    }

    public void syntaxCheckOnly() throws SyntaxException {
        this.buildAllShadows();
        this.netSystem.compile();
    }

    public NetInstanceAccessor initSimulation(String string) throws SyntaxException, NetNotFoundException, NoSimulationException {
        this.inGuiSetup = true;
        this.lastSyntaxException = null;
        logger.trace((Object)"CPNSimulation: initializing simulation...");
        this.buildAllShadows();
        try {
            this.simulatorPlugin.setDefaultNetLoader();
            try {
                logger.trace((Object)"CPNSimulation: calling setupSimulation...");
                this.simulatorPlugin.setupSimulation(null);
                logger.trace((Object)"CPNSimulation: finished setupSimulation...");
            }
            catch (SimulationRunningException simulationRunningException) {
                logger.warn((Object)"Simulation already running, inserting nets anyway");
            }
            if (this.lastSyntaxException != null) {
                logger.trace((Object)("CPNSimulation: forwarding (rethrowing) exception: " + this.lastSyntaxException));
                this.simulatorPlugin.terminateSimulation();
                if (this.lastSyntaxException instanceof SyntaxException) {
                    throw (SyntaxException)((Object)this.lastSyntaxException);
                }
                if (this.lastSyntaxException instanceof IllegalCompilerException) {
                    throw (IllegalCompilerException)((Object)this.lastSyntaxException);
                }
                throw new RuntimeException("Unexpected Exception type: " + this.lastSyntaxException, this.lastSyntaxException);
            }
            logger.trace((Object)("CPNSimulation: instantiating net " + string + "..."));
            NetInstanceAccessor netInstanceAccessor = null;
            if (RemotePlugin.getInstance() != null) {
                netInstanceAccessor = RemotePlugin.getInstance().wrapInstance(this.simulatorPlugin.createNetInstance(string));
            }
            if (netInstanceAccessor == null) {
                logger.trace((Object)("CPNSimulation: instantiation of net " + string + " failed."));
                this.simulatorPlugin.terminateSimulation();
            }
            NetInstanceAccessor netInstanceAccessor2 = netInstanceAccessor;
            return netInstanceAccessor2;
        }
        catch (NetNotFoundException netNotFoundException) {
            logger.trace((Object)("CPNSimulation: catching and rethrowing exception: " + (Object)((Object)netNotFoundException)));
            this.simulatorPlugin.terminateSimulation();
            throw netNotFoundException;
        }
        catch (NoSimulationException noSimulationException) {
            logger.info((Object)"CPNSimulation: Simulation terminated externally.");
            throw noSimulationException;
        }
        catch (RuntimeException runtimeException) {
            logger.trace((Object)("CPNSimulation: catching and rethrowing exception: " + runtimeException));
            this.simulatorPlugin.terminateSimulation();
            throw runtimeException;
        }
        catch (Error error) {
            logger.trace((Object)("CPNSimulation: catching and rethrowing exception: " + error));
            this.simulatorPlugin.terminateSimulation();
            throw error;
        }
        finally {
            this.inGuiSetup = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(ObjectOutput objectOutput) throws IOException {
        SimulatorPlugin simulatorPlugin = this.simulatorPlugin;
        synchronized (simulatorPlugin) {
            this.simulatorPlugin.getCurrentEnvironment().getSimulator().stopRun();
            BindingSelectionFrame.close();
            NetInstance[] netInstanceArray = CPNInstanceDrawing.getAllLocalInstances();
            this.simulatorPlugin.saveState(objectOutput, netInstanceArray);
        }
    }

    public void loadState(ObjectInput objectInput) throws IOException, ClassNotFoundException, SimulationRunningException {
        NetInstance[] netInstanceArray = this.simulatorPlugin.loadState(objectInput, null);
        CPNApplication cPNApplication = GuiPlugin.getCurrent().getGui();
        RemotePlugin remotePlugin = RemotePlugin.getInstance();
        for (int i = 0; i < netInstanceArray.length; ++i) {
            NetInstanceAccessor netInstanceAccessor = remotePlugin.wrapInstance(netInstanceArray[i]);
            if (cPNApplication == null) continue;
            cPNApplication.openInstanceDrawing(netInstanceAccessor);
        }
    }

    public boolean isSimulationActive() {
        return this.simulatorPlugin.isSimulationActive();
    }

    public void simulationTerminate() {
        this.simulatorPlugin.terminateSimulation();
    }

    public void simulationRefresh() {
        SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            @Override
            public Object call() {
                Simulator simulator;
                SimulationEnvironment simulationEnvironment = CPNSimulation.this.simulatorPlugin.getCurrentEnvironment();
                Simulator simulator2 = simulator = simulationEnvironment == null ? null : simulationEnvironment.getSimulator();
                if (simulator != null) {
                    simulator.refresh();
                }
                return null;
            }
        });
    }

    public void simulationStop() {
        SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            @Override
            public Object call() {
                Simulator simulator;
                SimulationEnvironment simulationEnvironment = CPNSimulation.this.simulatorPlugin.getCurrentEnvironment();
                Simulator simulator2 = simulator = simulationEnvironment == null ? null : simulationEnvironment.getSimulator();
                if (simulator != null) {
                    simulator.stopRun();
                }
                return null;
            }
        });
    }

    public void simulationRun() {
        SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() {
                SimulationEnvironment simulationEnvironment = CPNSimulation.this.simulatorPlugin.getCurrentEnvironment();
                Simulator simulator = simulationEnvironment == null ? null : simulationEnvironment.getSimulator();
                3 var3_3 = this;
                synchronized (var3_3) {
                    if (CPNSimulation.this.breakpointManager != null) {
                        CPNSimulation.this.breakpointManager.clearLog();
                    }
                    if (simulator != null) {
                        simulator.startRun();
                    }
                }
                return null;
            }
        });
    }

    public int simulationStep() {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() {
                SimulationEnvironment simulationEnvironment = CPNSimulation.this.simulatorPlugin.getCurrentEnvironment();
                Simulator simulator = simulationEnvironment == null ? null : simulationEnvironment.getSimulator();
                4 var3_3 = this;
                synchronized (var3_3) {
                    if (CPNSimulation.this.breakpointManager != null) {
                        CPNSimulation.this.breakpointManager.clearLog();
                    }
                    if (simulator != null) {
                        return simulator.step();
                    }
                    return 4;
                }
            }
        });
        try {
            return (Integer)future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.info((Object)"Net step aborted");
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Exception during execution of simulation step");
        }
        return 4;
    }

    public void dispose() {
        this.simulatorPlugin.removeExtension((SimulatorExtension)this.compilationExtension);
        this.compilationExtension = null;
    }

    private static class SimulatorGuiCompilationExtension
    extends SimulatorExtensionAdapter {
        private CPNSimulation sim;

        public SimulatorGuiCompilationExtension(CPNSimulation cPNSimulation) {
            this.sim = cPNSimulation;
            logger.trace((Object)"SimGuiCompilationExt created.");
        }

        public void simulationSetup(SimulationEnvironment simulationEnvironment) {
            ShadowNetSystem shadowNetSystem;
            super.simulationSetup(simulationEnvironment);
            if (this.sim.inGuiSetup) {
                logger.trace((Object)"SimGuiCompilationExt: setup called within guiSetup.");
                shadowNetSystem = this.sim.netSystem;
            } else {
                logger.trace((Object)"SimGuiCompilationExt: setup called concurrently.");
                shadowNetSystem = this.sim.getNetSystem();
            }
            try {
                SimulatorPlugin.getCurrent().insertNets(shadowNetSystem);
                logger.trace((Object)"SimGuiCompilationExt: finished initial compilation.");
            }
            catch (NoSimulationException noSimulationException) {
                logger.error((Object)"This is absurd: no simulation during simulation setup", (Throwable)noSimulationException);
            }
            catch (SyntaxException syntaxException) {
                if (this.sim.inGuiSetup) {
                    this.sim.lastSyntaxException = syntaxException;
                } else {
                    logger.warn((Object)("SyntaxException in editor nets during non-gui simulation setup:\n" + syntaxException.getMessage()), (Throwable)syntaxException);
                }
            }
            catch (IllegalCompilerException illegalCompilerException) {
                if (this.sim.inGuiSetup) {
                    this.sim.lastSyntaxException = illegalCompilerException;
                }
                logger.warn((Object)("IllegalCompilerException in editor nets during non-gui simulation setup:\n" + illegalCompilerException.getMessage()), (Throwable)illegalCompilerException);
            }
        }
    }
}

