/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.gui.ConfigureNetpathTab;
import de.renew.gui.ConfigureSimulationTabController;
import de.renew.gui.EditPathEntryDialog;
import de.renew.gui.NetpathModel;
import de.renew.shadow.DefaultShadowNetLoader;
import java.awt.Component;
import java.awt.Container;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.ListSelectionModel;
import org.apache.log4j.Logger;

class ConfigureNetpathController
implements ConfigureSimulationTabController {
    public static Logger logger = Logger.getLogger(ConfigureNetpathController.class);
    private ConfigureNetpathTab tab = new ConfigureNetpathTab(this);
    private NetpathModel model = null;

    @Override
    public Component getTab() {
        return this.tab;
    }

    @Override
    public void commitTab(Properties properties) {
        if (this.model != null) {
            String string = this.model.asPath();
            properties.setProperty("de.renew.netPath", string);
            logger.debug((Object)("ConfigureNetpathController: Configured netpath=" + string + "."));
        }
    }

    @Override
    public void updateTab(Properties properties) {
        this.model = new NetpathModel(properties.getProperty("de.renew.netPath", System.getProperty("user.dir")));
        this.tab.setPathList(this.model);
    }

    public void addEntry() {
        EditPathEntryDialog editPathEntryDialog = new EditPathEntryDialog(this.getParentDialog(), "Add");
        editPathEntryDialog.setEntry(new DefaultShadowNetLoader.PathEntry("", false));
        editPathEntryDialog.setVisible(true);
        if (editPathEntryDialog.isCommitted()) {
            DefaultShadowNetLoader.PathEntry pathEntry = editPathEntryDialog.getEntry();
            int n = this.tab.getSelection().getMinSelectionIndex();
            if (n == -1) {
                this.model.add(pathEntry);
            } else {
                this.model.add(n, pathEntry);
            }
        }
    }

    public void editEntry() {
        ListSelectionModel listSelectionModel = this.tab.getSelection();
        for (int i = listSelectionModel.getMinSelectionIndex(); i <= listSelectionModel.getMaxSelectionIndex(); ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            EditPathEntryDialog editPathEntryDialog = new EditPathEntryDialog(this.getParentDialog(), "Change");
            editPathEntryDialog.setEntry(this.model.get(i));
            editPathEntryDialog.setVisible(true);
            if (!editPathEntryDialog.isCommitted()) continue;
            this.model.set(i, editPathEntryDialog.getEntry());
        }
    }

    public void upEntry() {
        ListSelectionModel listSelectionModel = this.tab.getSelection();
        int n = listSelectionModel.getMinSelectionIndex() - 1;
        if (n < 0) {
            n = 0;
        }
        int[] nArray = this.computeSelectedIndices(listSelectionModel);
        DefaultShadowNetLoader.PathEntry[] pathEntryArray = this.model.removeAll(nArray);
        this.model.addAll(n, pathEntryArray);
        listSelectionModel.addSelectionInterval(n, n + pathEntryArray.length - 1);
    }

    public void downEntry() {
        ListSelectionModel listSelectionModel = this.tab.getSelection();
        int n = listSelectionModel.getMaxSelectionIndex() + 1;
        int[] nArray = this.computeSelectedIndices(listSelectionModel);
        DefaultShadowNetLoader.PathEntry[] pathEntryArray = this.model.removeAll(nArray);
        if ((n = n - pathEntryArray.length + 1) > this.model.getSize()) {
            n = this.model.getSize();
        }
        this.model.addAll(n, pathEntryArray);
        listSelectionModel.addSelectionInterval(n, n + pathEntryArray.length - 1);
    }

    public void removeEntry() {
        this.model.removeAll(this.computeSelectedIndices(this.tab.getSelection()));
    }

    private int[] computeSelectedIndices(ListSelectionModel listSelectionModel) {
        int n = listSelectionModel.getMaxSelectionIndex() - listSelectionModel.getMinSelectionIndex() + 1;
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = listSelectionModel.getMinSelectionIndex(); i <= listSelectionModel.getMaxSelectionIndex(); ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            nArray[n2] = i;
            ++n2;
        }
        if (n2 < n) {
            int[] nArray2 = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray2[i] = nArray[i];
            }
            nArray = nArray2;
        }
        return nArray;
    }

    private JDialog getParentDialog() {
        Container container = this.tab;
        while (!(container instanceof JDialog)) {
            container = container.getParent();
        }
        return (JDialog)container;
    }
}

