/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.shadow.DefaultShadowNetLoader;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EditPathEntryDialog
extends JDialog {
    private boolean commit = false;
    private JLabel pathLabel;
    private JCheckBox useClasspathBox;
    private JButton okButton;
    private JTextField pathField;
    private JButton cancelButton;

    public EditPathEntryDialog(JDialog jDialog, String string) {
        super(jDialog, string + " path entry", true);
        this.initComponents();
        if (string != null) {
            this.okButton.setText(string);
        }
        this.pack();
    }

    private void initComponents() {
        this.pathLabel = new JLabel();
        this.pathField = new JTextField();
        this.useClasspathBox = new JCheckBox();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                EditPathEntryDialog.this.cancelDialog();
            }
        });
        this.pathLabel.setText("Path:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.pathLabel, gridBagConstraints);
        this.pathField.setText("/this/is/a/rather/long/path/name/for/unix/systems/with/slashes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.pathField, gridBagConstraints);
        this.useClasspathBox.setText("relative to classpath");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.useClasspathBox, gridBagConstraints);
        this.okButton.setText("OK");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditPathEntryDialog.this.commitDialog();
            }
        });
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditPathEntryDialog.this.cancelDialog();
            }
        });
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
    }

    private void commitDialog() {
        this.commit = true;
        this.setVisible(false);
        this.dispose();
    }

    private void cancelDialog() {
        this.commit = false;
        this.setVisible(false);
        this.dispose();
    }

    public boolean isCommitted() {
        return this.commit;
    }

    public DefaultShadowNetLoader.PathEntry getEntry() {
        return new DefaultShadowNetLoader.PathEntry(this.pathField.getText(), this.useClasspathBox.isSelected());
    }

    public void setEntry(DefaultShadowNetLoader.PathEntry pathEntry) {
        this.useClasspathBox.setSelected(pathEntry.isClasspathRelative);
        this.pathField.setText(pathEntry.path);
    }
}

