/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.FigureException;
import de.renew.gui.CPNDrawing;
import de.renew.shadow.ShadowNetElement;
import de.renew.shadow.SyntaxException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FigureExceptionFactory {
    private static final Logger logger = Logger.getLogger(FigureExceptionFactory.class);

    public static FigureException createFigureException(SyntaxException syntaxException, Drawing drawing, TextFigure textFigure) {
        int n = syntaxException.line;
        int n2 = syntaxException.column;
        String string = syntaxException.getMessage();
        logger.debug((Object)"Syntax Error: ", (Throwable)syntaxException);
        return new FigureException(string, n, n2, drawing, textFigure);
    }

    public static FigureException createFigureException(SyntaxException syntaxException) {
        CPNDrawing cPNDrawing;
        int n = syntaxException.line;
        int n2 = syntaxException.column;
        String string = syntaxException.getMessage();
        TextFigure textFigure = null;
        Vector<Figure> vector = new Vector<Figure>();
        if (!syntaxException.errorObjects.isEmpty()) {
            cPNDrawing = CPNDrawing.findDrawing(syntaxException.errorObjects.elementAt(0));
            if (cPNDrawing != null) {
                boolean bl = false;
                Enumeration enumeration = syntaxException.errorObjects.elements();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    Figure figure = null;
                    if (e instanceof ShadowNetElement) {
                        figure = (Figure)((ShadowNetElement)e).context;
                    }
                    if (figure == null) continue;
                    if (bl) {
                        textFigure = null;
                    } else {
                        bl = true;
                        if (syntaxException.line > 0 && syntaxException.column > 0 && figure instanceof TextFigure && ((TextFigure)figure).acceptsTyping()) {
                            textFigure = (TextFigure)figure;
                        }
                    }
                    vector.addElement(figure);
                }
            }
        } else {
            cPNDrawing = null;
        }
        logger.debug((Object)"Syntax Error: ", (Throwable)syntaxException);
        return new FigureException(string, n, n2, (Drawing)cPNDrawing, textFigure, vector);
    }
}

