/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.util.Animatable;
import CH.ifa.draw.util.Animator;
import CH.ifa.draw.util.GUIProperties;
import de.renew.gui.GraphLayout;
import de.renew.gui.LayoutableDrawing;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class LayoutFrame
implements AdjustmentListener,
Animatable {
    private static int width = 200;
    private static String[] buttonTexts = new String[]{"Spring Length", "Spring Strength", "Repulsion Distance", "Repulsion Strength", "Torque Strength", "Friction"};
    private DrawingEditor editor;
    private Animator animator;
    private GraphLayout graphLayout = null;
    private JFrame frame;
    private JScrollBar[] scroller;
    private JButton startButton;
    private JButton stopButton;

    public LayoutFrame(DrawingEditor drawingEditor) {
        JComponent jComponent;
        this.editor = drawingEditor;
        this.frame = new JFrame("Automatic Net Layout");
        if (!GUIProperties.avoidFrameReshape()) {
            this.frame.setSize(600, 200);
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.frame.getContentPane().setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        this.scroller = new JScrollBar[buttonTexts.length];
        for (int i = 0; i < buttonTexts.length; ++i) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            jComponent = new JLabel(buttonTexts[i]);
            jComponent.setPreferredSize(new Dimension(150, 20));
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            this.frame.getContentPane().add(jComponent);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            this.scroller[i] = new JScrollBar(0, width / 2, 10, 0, width);
            this.scroller[i].addAdjustmentListener(this);
            this.scroller[i].setPreferredSize(new Dimension(150, 20));
            gridBagLayout.setConstraints(this.scroller[i], gridBagConstraints);
            this.frame.getContentPane().add(this.scroller[i]);
        }
        JPanel jPanel = new JPanel();
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.frame.getContentPane().add(jPanel);
        gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setPreferredSize(new Dimension(300, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        this.startButton = new JButton("Start");
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LayoutFrame.this.startAnimation();
            }
        });
        gridBagLayout.setConstraints(this.startButton, gridBagConstraints);
        jPanel.add(this.startButton);
        this.stopButton = new JButton("Stop");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LayoutFrame.this.stopAnimation();
            }
        });
        gridBagLayout.setConstraints(this.stopButton, gridBagConstraints);
        jPanel.add(this.stopButton);
        jComponent = new JButton("Close");
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LayoutFrame.this.stopAnimation();
                LayoutFrame.this.frame.setVisible(false);
                DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().removeFrame((Frame)LayoutFrame.this.frame);
            }
        });
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                LayoutFrame.this.stopAnimation();
                LayoutFrame.this.frame.setVisible(false);
                DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().removeFrame((Frame)LayoutFrame.this.frame);
            }
        });
        this.frame.pack();
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 200);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void stopAnimation() {
        this.startButton.setEnabled(true);
        this.stopButton.setEnabled(false);
        if (this.animator != null) {
            this.animator.end();
            this.animator = null;
        }
    }

    public void startAnimation() {
        this.stopAnimation();
        this.startButton.setEnabled(false);
        this.stopButton.setEnabled(true);
        DrawingView drawingView = this.editor.view();
        Drawing drawing = drawingView.drawing();
        if (drawing instanceof LayoutableDrawing) {
            this.frame.setTitle("Automatic Layout - " + drawing.getName());
            this.frame.setVisible(true);
            DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().addFrame("Tools", (Frame)this.frame);
            this.editor.prepareUndoSnapshot();
            this.editor.commitUndoSnapshot();
            this.graphLayout = new GraphLayout();
            ((LayoutableDrawing)drawing).fillInGraph(this.graphLayout);
            this.fillInScrollerValues();
            this.animator = new Animator((Animatable)this, drawingView);
            new Thread((Runnable)this.animator).start();
        }
    }

    public void createLayout(double d, double d2, double d3, double d4, double d5, double d6, long l) {
        this.stopAnimation();
        this.startButton.setEnabled(false);
        this.stopButton.setEnabled(true);
        DrawingView drawingView = this.editor.view();
        Drawing drawing = drawingView.drawing();
        if (drawing instanceof LayoutableDrawing) {
            this.editor.prepareUndoSnapshot();
            this.editor.commitUndoSnapshot();
            this.graphLayout = new GraphLayout();
            ((LayoutableDrawing)drawing).fillInGraph(this.graphLayout);
            this.fillInScrollerValues();
            this.animator = new Animator((Animatable)this, drawingView);
            new Thread((Runnable)this.animator).start();
            this.graphLayout.LENGTH_FACTOR = 4.0 * d;
            this.graphLayout.SPRING_STRENGTH = 0.4 * d2;
            this.graphLayout.REPULSION_LIMIT = 800.0 * d3;
            this.graphLayout.REPULSION_STRENGTH = 2.0 * d4;
            this.graphLayout.TORQUE_STRENGTH = 1.0 * d5;
            this.graphLayout.FRICTION_FACTOR = 1.0 - d6;
            if (l <= 0L) {
                this.frame.setTitle("Automatic Layout - " + drawing.getName());
                this.frame.setVisible(true);
                DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().addFrame("Tools", (Frame)this.frame);
            } else {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            this.stopAnimation();
        }
    }

    private static double calcFactor(int n) {
        double d = (double)n / (double)width;
        return d * d;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.fillInScrollerValues();
    }

    private void fillInScrollerValues() {
        int n = 0;
        if (this.graphLayout != null) {
            this.graphLayout.LENGTH_FACTOR = 4.0 * LayoutFrame.calcFactor(this.scroller[n++].getValue());
            this.graphLayout.SPRING_STRENGTH = 0.4 * LayoutFrame.calcFactor(this.scroller[n++].getValue());
            this.graphLayout.REPULSION_LIMIT = 800.0 * LayoutFrame.calcFactor(this.scroller[n++].getValue());
            this.graphLayout.REPULSION_STRENGTH = 2.0 * LayoutFrame.calcFactor(this.scroller[n++].getValue());
            this.graphLayout.TORQUE_STRENGTH = 1.0 * LayoutFrame.calcFactor(this.scroller[n++].getValue());
            this.graphLayout.FRICTION_FACTOR = 1.0 - LayoutFrame.calcFactor(this.scroller[n++].getValue());
        }
    }

    public synchronized void animationStart() {
    }

    public synchronized void animationStop() {
        this.graphLayout.remove();
        this.graphLayout = null;
    }

    public synchronized void animationStep() {
        if (this.graphLayout != null) {
            this.graphLayout.relax();
        }
    }
}

