/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.shadow.DefaultShadowNetLoader;
import de.renew.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;

public class NetpathModel
extends AbstractListModel {
    private List<DefaultShadowNetLoader.PathEntry> paths;

    public NetpathModel(String string) {
        DefaultShadowNetLoader.PathEntry[] pathEntryArray = DefaultShadowNetLoader.canonizePaths((String[])StringUtil.splitPaths((String)string));
        this.paths = new ArrayList<DefaultShadowNetLoader.PathEntry>(pathEntryArray.length + 5);
        for (int i = 0; i < pathEntryArray.length; ++i) {
            this.paths.add(pathEntryArray[i]);
        }
    }

    public String asPath() {
        return DefaultShadowNetLoader.asPathString((DefaultShadowNetLoader.PathEntry[])this.paths.toArray(new DefaultShadowNetLoader.PathEntry[this.paths.size()]));
    }

    @Override
    public int getSize() {
        return this.paths.size();
    }

    @Override
    public Object getElementAt(int n) {
        DefaultShadowNetLoader.PathEntry pathEntry = this.paths.get(n);
        StringBuffer stringBuffer = new StringBuffer();
        if (pathEntry.isClasspathRelative) {
            stringBuffer.append("CLASSPATH");
            if (!"".equals(pathEntry.path)) {
                stringBuffer.append(File.separator);
            }
        }
        stringBuffer.append(pathEntry.path);
        return stringBuffer.toString();
    }

    public void add(int n, DefaultShadowNetLoader.PathEntry pathEntry) {
        this.paths.add(n, pathEntry);
        this.fireIntervalAdded(this, n, n);
    }

    public void add(DefaultShadowNetLoader.PathEntry pathEntry) {
        int n = this.paths.size();
        this.add(n, pathEntry);
    }

    public void set(int n, DefaultShadowNetLoader.PathEntry pathEntry) {
        this.paths.remove(n);
        this.paths.add(n, pathEntry);
        this.fireContentsChanged(this, n, n);
    }

    public DefaultShadowNetLoader.PathEntry get(int n) {
        return this.paths.get(n);
    }

    public DefaultShadowNetLoader.PathEntry remove(int n) {
        DefaultShadowNetLoader.PathEntry pathEntry = this.paths.remove(n);
        this.fireIntervalRemoved(this, n, n);
        return pathEntry;
    }

    public DefaultShadowNetLoader.PathEntry[] removeAll(int[] nArray) {
        int n;
        if (nArray == null || nArray.length == 0) {
            return new DefaultShadowNetLoader.PathEntry[0];
        }
        ArrayList<DefaultShadowNetLoader.PathEntry> arrayList = new ArrayList<DefaultShadowNetLoader.PathEntry>(this.paths.size());
        for (n = 0; n < nArray.length; ++n) {
            arrayList.add(this.paths.get(nArray[n]));
        }
        n = nArray[nArray.length - 1];
        int n2 = nArray[nArray.length - 1] + 1;
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.paths.remove(nArray[i]);
            if (nArray[i] != n2 - 1) {
                this.fireIntervalRemoved(this, n2, n);
                n = nArray[i];
            }
            n2 = nArray[i];
        }
        this.fireIntervalRemoved(this, n2, n);
        return arrayList.toArray(new DefaultShadowNetLoader.PathEntry[arrayList.size()]);
    }

    public void addAll(int n, DefaultShadowNetLoader.PathEntry[] pathEntryArray) {
        this.paths.addAll(n, Arrays.asList(pathEntryArray));
        this.fireIntervalAdded(this, n, n + pathEntryArray.length - 1);
    }
}

