/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.util.StorableInput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class PatchingStorableInput
extends StorableInput {
    private boolean stringReadPatching = true;
    private static final Hashtable<String, String> patchPrefixes = new Hashtable();
    private static final Hashtable<String, String> patchMap;

    PatchingStorableInput(InputStream inputStream, boolean bl) {
        super(inputStream, bl);
    }

    PatchingStorableInput(File file, boolean bl) throws FileNotFoundException {
        super(file, bl);
    }

    public PatchingStorableInput(String string) {
        super(string);
    }

    public PatchingStorableInput(URL uRL, boolean bl) throws IOException {
        super(uRL, bl);
    }

    protected Object makeInstance(String string) throws IOException {
        return super.makeInstance(this.patchString(string));
    }

    public String readString() throws IOException {
        String string = super.readString();
        if (this.stringReadPatching) {
            string = this.patchString(string);
        }
        return string;
    }

    protected String patchString(String string) {
        String string2;
        boolean bl = false;
        Enumeration<String> enumeration = patchPrefixes.keys();
        while (enumeration.hasMoreElements() && !bl) {
            string2 = enumeration.nextElement();
            if (!string.startsWith(string2)) continue;
            string = patchPrefixes.get(string2) + string.substring(string2.length());
            bl = true;
        }
        string2 = patchMap.get(string);
        if (string2 != null) {
            string = string2;
        }
        return string;
    }

    static {
        patchPrefixes.put("CH.ifa.draw.cpn.", "de.renew.gui.");
        patchMap = new Hashtable();
        patchMap.put("de.renew.gui.fs.AssocArrowTip", "de.renew.gui.AssocArrowTip");
        patchMap.put("de.renew.gui.fs.IsaArrowTip", "de.renew.gui.IsaArrowTip");
        patchMap.put("de.renew.diagram.AssocArrowTip", "de.renew.gui.AssocArrowTip");
        patchMap.put("de.renew.fa.figures.AssocArrowTip", "de.renew.gui.AssocArrowTip");
    }
}

