/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.gui.Breakpoint;
import de.renew.gui.BreakpointManager;
import de.renew.net.Net;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.net.event.PlaceEvent;
import de.renew.net.event.PlaceEventListener;
import de.renew.net.event.PlaceEventProducer;
import de.renew.net.event.TokenEvent;

class PlaceInstanceBreakpoint
implements Breakpoint,
PlaceEventListener {
    private BreakpointManager manager;
    private int reactOn;
    private PlaceEventProducer producer;
    private Net net;
    private PlaceInstance hitInstance;
    private String description;

    PlaceInstanceBreakpoint(BreakpointManager breakpointManager, PlaceEventProducer placeEventProducer, int n, Net net) {
        if (n == 0) {
            n = 3;
        }
        placeEventProducer.addPlaceEventListener((PlaceEventListener)this);
        this.manager = breakpointManager;
        this.reactOn = n;
        this.producer = placeEventProducer;
        this.net = net;
        this.hitInstance = null;
        this.composeDescription();
    }

    public boolean wantSynchronousNotification() {
        return true;
    }

    private void composeDescription() {
        StringBuffer stringBuffer = new StringBuffer("BP: ");
        if (this.producer instanceof PlaceInstance) {
            stringBuffer.append("place instance " + this.producer);
        } else if (this.producer instanceof Place) {
            stringBuffer.append("place " + this.net.getName() + "." + this.producer);
        } else {
            stringBuffer.append("PlaceEventProducer " + this.producer);
        }
        switch (this.reactOn) {
            case 3: {
                stringBuffer.append(" changes marking");
                break;
            }
            case 5: {
                stringBuffer.append(" changes marking (test arcs ignored)");
                break;
            }
            case 6: {
                stringBuffer.append(" gets one token added");
                break;
            }
            case 7: {
                stringBuffer.append(" looses one token");
                break;
            }
            case 8: {
                stringBuffer.append(" changes test status of tokens");
                break;
            }
            default: {
                stringBuffer.append(" <wrong mode!>");
            }
        }
        this.description = stringBuffer.toString();
    }

    private void hitBP(PlaceEvent placeEvent) {
        this.hitInstance = placeEvent.getPlaceInstance();
        this.manager.stopSimulation();
        this.manager.informHitBreakpoint(this);
    }

    public void markingChanged(PlaceEvent placeEvent) {
        switch (this.reactOn) {
            case 3: 
            case 5: {
                this.hitBP(placeEvent);
            }
        }
    }

    public void tokenAdded(TokenEvent tokenEvent) {
        switch (this.reactOn) {
            case 3: 
            case 5: 
            case 6: {
                this.hitBP((PlaceEvent)tokenEvent);
            }
        }
    }

    public void tokenRemoved(TokenEvent tokenEvent) {
        switch (this.reactOn) {
            case 3: 
            case 5: 
            case 7: {
                this.hitBP((PlaceEvent)tokenEvent);
            }
        }
    }

    public void tokenTested(TokenEvent tokenEvent) {
        switch (this.reactOn) {
            case 3: 
            case 8: {
                this.hitBP((PlaceEvent)tokenEvent);
            }
        }
    }

    public void tokenUntested(TokenEvent tokenEvent) {
        switch (this.reactOn) {
            case 3: 
            case 8: {
                this.hitBP((PlaceEvent)tokenEvent);
            }
        }
    }

    @Override
    public Object getTaggedElement() {
        return this.producer;
    }

    @Override
    public Object getHitElement() {
        return this.hitInstance;
    }

    @Override
    public Net getTaggedNet() {
        return this.net;
    }

    @Override
    public void release() {
        this.producer.removePlaceEventListener((PlaceEventListener)this);
        this.manager = null;
        this.producer = null;
        this.net = null;
        this.hitInstance = null;
    }

    public String toString() {
        return this.description;
    }
}

