/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.gui.CPNDrawing;
import de.renew.gui.ShadowNetRenderer;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class ShadowNetSystemRenderer {
    public static Logger logger = Logger.getLogger(ShadowNetSystemRenderer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShadowNetSystem readShadowNetSystem(URL uRL) {
        ShadowNetSystem shadowNetSystem = null;
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            shadowNetSystem = (ShadowNetSystem)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            logger.error((Object)iOException.getMessage(), (Throwable)iOException);
            logger.error((Object)("Could not load net system from " + uRL + "."));
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error((Object)classNotFoundException.getMessage(), (Throwable)classNotFoundException);
            logger.error((Object)("Could not load net system from " + uRL + "."));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return shadowNetSystem;
    }

    public static CPNDrawing[] render(URL uRL) {
        ShadowNetSystem shadowNetSystem = ShadowNetSystemRenderer.readShadowNetSystem(uRL);
        Set set = shadowNetSystem.elements();
        Iterator iterator = set.iterator();
        CPNDrawing[] cPNDrawingArray = new CPNDrawing[set.size()];
        int n = 0;
        while (iterator.hasNext()) {
            ShadowNet shadowNet = (ShadowNet)iterator.next();
            cPNDrawingArray[n] = new ShadowNetRenderer((ShadowNet)shadowNet).drawing;
            ++n;
        }
        return cPNDrawingArray;
    }
}

