/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import de.renew.gui.CPNDrawing;
import de.renew.io.RNWFileFilter;
import de.renew.shadow.ShadowCompilerFactory;
import de.renew.shadow.ShadowNetLoader;
import de.renew.shadow.ShadowNetSystem;
import de.renew.shadow.SyntaxException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class ShadowTranslator {
    private static Logger logger = Logger.getLogger(ShadowTranslator.class);
    private static final StatusDisplayer sd = new StatusDisplayer(){

        public void showStatus(String string) {
            System.err.println(string);
        }
    };

    public static void main(String[] stringArray) {
        System.setProperty("de.renew.noGraphics", "true");
        Logger logger = Logger.getRootLogger();
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)new SimpleLayout(), "System.out");
        logger.addAppender((Appender)consoleAppender);
        logger.setLevel(Level.DEBUG);
        if (stringArray.length == 0) {
            ShadowTranslator.logger.error((Object)"Usage: java de.renew.gui.ShadowTranslator file.rnw ...");
            ShadowTranslator.logger.info((Object)"Converts Renew drawings (.rnw) to shadow nets (.sns).");
            ShadowTranslator.logger.info((Object)"No syntax check or compilation is done, just conversion.");
            System.exit(1);
        }
        RNWFileFilter rNWFileFilter = new RNWFileFilter();
        Vector<File> vector = new Vector<File>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(DrawingFileHelper.checkAndAddExtension((File)new File(stringArray[i]), (SimpleFileFilter)rNWFileFilter));
        }
        CPNDrawing[] cPNDrawingArray = ShadowTranslator.readDrawings(vector.toArray(new File[vector.size()]));
        ShadowTranslator.writeShadows(cPNDrawingArray);
        System.exit(0);
    }

    public static CPNDrawing[] readDrawings(File[] fileArray) {
        Vector<Drawing> vector = new Vector<Drawing>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                Drawing drawing = DrawingFileHelper.loadDrawing((File)fileArray[i], (StatusDisplayer)sd);
                if (drawing == null) continue;
                if (drawing instanceof CPNDrawing) {
                    vector.add(drawing);
                    continue;
                }
                logger.warn((Object)(drawing.getName() + " is not a CPN drawing - ignored."));
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)exception);
            }
        }
        return vector.toArray(new CPNDrawing[vector.size()]);
    }

    public static void writeShadows(CPNDrawing[] cPNDrawingArray) {
        try {
            ShadowTranslator.writeShadows(null, false, cPNDrawingArray);
        }
        catch (SyntaxException syntaxException) {
            // empty catch block
        }
    }

    public static void writeShadows(ShadowCompilerFactory shadowCompilerFactory, boolean bl, CPNDrawing[] cPNDrawingArray) throws SyntaxException {
        ShadowTranslator.writeShadows(shadowCompilerFactory, bl, cPNDrawingArray, null);
    }

    public static void writeShadows(ShadowCompilerFactory shadowCompilerFactory, boolean bl, CPNDrawing[] cPNDrawingArray, File[] fileArray) throws SyntaxException {
        ShadowTranslator.writeShadows(shadowCompilerFactory, bl, cPNDrawingArray, fileArray, null);
    }

    public static void writeShadows(ShadowCompilerFactory shadowCompilerFactory, boolean bl, CPNDrawing[] cPNDrawingArray, File[] fileArray, ShadowNetLoader shadowNetLoader) throws SyntaxException {
        if (bl) {
            ShadowTranslator.createGlobalSns(shadowCompilerFactory, bl, cPNDrawingArray, shadowNetLoader);
        }
        int n = 0;
        for (int i = 0; i < cPNDrawingArray.length; ++i) {
            File file;
            CPNDrawing cPNDrawing = cPNDrawingArray[i];
            ShadowNetSystem shadowNetSystem = new ShadowNetSystem(shadowCompilerFactory);
            cPNDrawing.buildShadow(shadowNetSystem);
            String string = cPNDrawing.getName();
            if (fileArray != null) {
                file = fileArray[i];
            } else {
                file = cPNDrawing.getFilename();
                if (file != null) {
                    try {
                        file = file.getCanonicalFile();
                        file = new File(file.getParent(), string + ".sns");
                    }
                    catch (IOException iOException) {
                        logger.error((Object)("Cannot compute sns filename for net " + string + "."), (Throwable)iOException);
                        file = null;
                    }
                }
            }
            if (file == null) {
                logger.warn((Object)("Skipping net " + string + " (no filename)."));
            } else {
                try {
                    logger.debug((Object)("Exporting net " + string + " to " + file + "..."));
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    objectOutputStream.writeObject(shadowNetSystem);
                    objectOutputStream.close();
                    ++n;
                }
                catch (Exception exception) {
                    logger.error((Object)exception);
                }
            }
            cPNDrawing.discardShadow();
        }
        logger.info((Object)("Exported " + n + " shadow net" + (n == 1 ? "" : "s") + "."));
    }

    private static ShadowNetSystem createGlobalSns(ShadowCompilerFactory shadowCompilerFactory, boolean bl, CPNDrawing[] cPNDrawingArray, ShadowNetLoader shadowNetLoader) throws SyntaxException {
        logger.debug((Object)("Creating shadow net system with compiler " + shadowCompilerFactory + " and net loader " + shadowNetLoader + "."));
        ShadowNetSystem shadowNetSystem = new ShadowNetSystem(shadowCompilerFactory, shadowNetLoader);
        for (int i = 0; i < cPNDrawingArray.length; ++i) {
            CPNDrawing cPNDrawing = cPNDrawingArray[i];
            cPNDrawing.buildShadow(shadowNetSystem);
        }
        if (bl) {
            shadowNetSystem.compile();
        }
        return shadowNetSystem;
    }

    public static void writeSingleShadow(CPNDrawing[] cPNDrawingArray, File file) {
        try {
            ShadowTranslator.writeSingleShadow(null, false, cPNDrawingArray, file);
        }
        catch (SyntaxException syntaxException) {
            // empty catch block
        }
    }

    public static void writeSingleShadow(ShadowCompilerFactory shadowCompilerFactory, boolean bl, CPNDrawing[] cPNDrawingArray, File file) throws SyntaxException {
        ShadowNetSystem shadowNetSystem = ShadowTranslator.createGlobalSns(shadowCompilerFactory, bl, cPNDrawingArray, null);
        if (file == null) {
            logger.error((Object)"Cannot write output sns, no filename given.");
        } else {
            try {
                logger.debug((Object)("Exporting all nets to " + file + "..."));
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(shadowNetSystem);
                objectOutputStream.close();
            }
            catch (Exception exception) {
                logger.error((Object)exception);
            }
        }
        logger.info((Object)("Exported " + cPNDrawingArray.length + " shadow net" + (cPNDrawingArray.length == 1 ? "" : "s") + "."));
    }
}

