/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.converter;

import de.renew.formalism.FormalismPlugin;
import de.renew.gui.CPNDrawing;
import de.renew.gui.ModeReplacement;
import de.renew.gui.pnml.converter.DefaultNetConverter;
import de.renew.gui.pnml.converter.NetConverter;
import de.renew.gui.pnml.converter.NetConverterAbstract;
import de.renew.gui.pnml.converter.PTNetConverter;
import de.renew.gui.pnml.converter.RefNetConverter;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetSystem;

public class Converter {
    private String _netType;
    private ShadowNet net;
    private static Converter _instance;

    protected Converter() {
    }

    public String getType() {
        return this._netType;
    }

    public void setType(String string) {
        this._netType = string;
    }

    public ShadowNet getShadowNet() {
        return this.net;
    }

    public void setShadowNet(CPNDrawing cPNDrawing) {
        if (PTNetConverter.isNetParser(this.getType())) {
            FormalismPlugin.getCurrent().setCompiler("P/T Net Compiler");
        } else if (RefNetConverter.isNetParser(this.getType())) {
            FormalismPlugin.getCurrent().setCompiler("Java Net Compiler");
        }
        this.net = cPNDrawing.buildShadow(new ShadowNetSystem(ModeReplacement.getInstance().getDefaultCompilerFactory()));
    }

    public NetConverter getNetConverter() {
        NetConverterAbstract netConverterAbstract = new DefaultNetConverter();
        if (this.getType() != null) {
            if (PTNetConverter.isNetParser(this.getType())) {
                netConverterAbstract = new PTNetConverter();
            } else if (RefNetConverter.isNetParser(this.getType())) {
                netConverterAbstract = new RefNetConverter();
            }
        }
        return netConverterAbstract;
    }

    public static Converter instance() {
        if (_instance == null) {
            _instance = new Converter();
        }
        return _instance;
    }
}

