/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.converter;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ParentFigure;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.pnml.converter.Converter;
import de.renew.gui.pnml.converter.NetConverterAbstract;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.SyntaxException;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class PTNetConverter
extends NetConverterAbstract {
    public static Logger logger = Logger.getLogger(PTNetConverter.class);

    @Override
    public boolean isAttribute(String string) {
        boolean bl = false;
        if (string.equals("type")) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isAnnotation(Element element) {
        boolean bl = false;
        String string = element.getNodeName();
        if (string.equals("initialMarking") || string.equals("name") || string.equals("inscription")) {
            bl = true;
        }
        return bl;
    }

    @Override
    public TextFigure convertAnnotationToTextFigure(Element element) {
        TextFigure textFigure = new TextFigure();
        String string = element.getNodeName();
        textFigure = string.equals("initialMarking") ? new CPNTextFigure(1) : (string.equals("name") ? new CPNTextFigure(2) : (string.equals("inscription") ? new CPNTextFigure(1) : new CPNTextFigure()));
        return textFigure;
    }

    @Override
    public String convertAnnotationToPNML(CPNTextFigure cPNTextFigure) {
        String string = "";
        ShadowNet shadowNet = Converter.instance().getShadowNet();
        int n = cPNTextFigure.getType();
        switch (n) {
            case 2: {
                string = "name";
                break;
            }
            case 1: {
                string = "label";
                ParentFigure parentFigure = cPNTextFigure.parent();
                try {
                    if (parentFigure instanceof ArcConnection) {
                        string = shadowNet.checkArcInscription(cPNTextFigure.getText(), false);
                        break;
                    }
                    if (parentFigure instanceof PlaceFigure) {
                        string = shadowNet.checkPlaceInscription(cPNTextFigure.getText(), false);
                        break;
                    }
                    if (!(parentFigure instanceof TransitionFigure)) break;
                    string = shadowNet.checkTransitionInscription(cPNTextFigure.getText(), false);
                }
                catch (SyntaxException syntaxException) {
                    logger.error((Object)syntaxException.getMessage());
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)(PTNetConverter.class.getSimpleName() + ": \n" + (Object)((Object)syntaxException)));
                }
                break;
            }
            default: {
                throw new RuntimeException("Unkown type");
            }
        }
        return string;
    }

    public static boolean isNetParser(String string) {
        return string.equals("http://www.informatik.hu-berlin.de/top/pntd/ptNetb");
    }

    @Override
    public boolean isInRenewAnnotation(Element element) {
        boolean bl = false;
        return bl;
    }
}

