/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.creator;

import de.renew.gui.pnml.converter.GraphicConverter;
import de.renew.gui.pnml.creator.PNMLCreator;
import java.awt.Color;
import org.w3c.dom.Element;

public class GraphicCreator {
    private Element _element;
    private Element line;

    public GraphicCreator() {
        this.setElement(PNMLCreator.createElement("graphics"));
    }

    protected Element getElement() {
        return this._element;
    }

    protected void setElement(Element element) {
        this._element = element;
    }

    public Element createGraphic() {
        return this.getElement();
    }

    public void addPosition(int n, int n2) {
        Element element = PNMLCreator.createElement("position");
        element.setAttribute("x", "\"" + String.valueOf(n) + "\"");
        element.setAttribute("y", "\"" + String.valueOf(n2) + "\"");
        this.getElement().appendChild(element);
    }

    public void addOffset(int n, int n2) {
        Element element = PNMLCreator.createElement("offset");
        element.setAttribute("x", "\"" + String.valueOf(n) + "\"");
        element.setAttribute("y", "\"" + String.valueOf(n2) + "\"");
        this.getElement().appendChild(element);
    }

    public void addDimension(int n, int n2) {
        Element element = PNMLCreator.createElement("dimension");
        element.setAttribute("x", "\"" + String.valueOf(n) + "\"");
        element.setAttribute("y", "\"" + String.valueOf(n2) + "\"");
        this.getElement().appendChild(element);
    }

    public void addFill(Color color) {
        Element element = PNMLCreator.createElement("fill");
        element.setAttribute("color", "\"rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")\"");
        this.getElement().appendChild(element);
    }

    public void addLineColor(Color color) {
        this.getLineElement().setAttribute("color", "\"rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")\"");
    }

    public void addLineStyle(String string) {
        this.getLineElement().setAttribute("style", "\"" + GraphicConverter.instance().parseRenewLineStyle(string) + "\"");
    }

    public void addLine() {
        this.getElement().appendChild(this.getLineElement());
    }

    private Element getLineElement() {
        if (this.line == null) {
            this.line = PNMLCreator.createElement("line");
        }
        return this.line;
    }
}

