/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import de.renew.gui.pnml.parser.ObjectParser;
import java.awt.Color;
import java.awt.Point;
import org.w3c.dom.Element;

public abstract class NodeParser
extends ObjectParser {
    public NodeParser(Element element) {
        super(element);
    }

    protected Point getLocation() {
        Point point = new Point();
        if (this.getGraphic().hasPosition()) {
            point = this.getGraphic().positions().next();
        }
        return point;
    }

    protected Point getDimension() {
        Point point = null;
        if (this.getGraphic().hasDimension()) {
            point = this.getGraphic().getDimension();
        }
        return point;
    }

    protected Color getFillColor() {
        Color color = null;
        if (this.getGraphic().hasFill()) {
            color = this.getGraphic().getFill();
        }
        return color;
    }

    protected Color getLineColor() {
        Color color = null;
        if (this.getGraphic().hasLineColor()) {
            color = this.getGraphic().getLineColor();
        }
        return color;
    }

    protected void setFigureDimension(Point point, Point point2) {
        this.figure().displayBox(point, point2);
    }

    @Override
    protected void initGraphic() {
        Point point = new Point(0, 0);
        Point point2 = this.getDimension() != null ? this.getDimension() : new Point(20, 20);
        if (this.getFillColor() != null) {
            this.figure().setAttribute("FillColor", (Object)this.getFillColor());
        }
        if (this.getLineColor() != null) {
            this.figure().setAttribute("FrameColor", (Object)this.getLineColor());
        }
        this.setFigureDimension(point, point2);
        this.moveObject(this.getLocation().x - point2.x / 2, this.getLocation().y - point2.y / 2);
    }
}

