/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.framework.ParentFigure;
import de.renew.gui.pnml.converter.Converter;
import de.renew.gui.pnml.converter.NetConverter;
import de.renew.gui.pnml.parser.AnnotationParser;
import de.renew.gui.pnml.parser.AttributeParser;
import de.renew.gui.pnml.parser.ElementParser;
import de.renew.gui.pnml.parser.GraphicParser;
import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ObjectParser
extends ElementParser {
    private FigureWithID _figure;
    private String _pnmlId;
    private Integer _mappedId;
    private List<AnnotationParser> _annotation;
    private List<AttributeParser> _attributes;
    private int _posAnnotation;
    private boolean _isParsed;
    private GraphicParser _parser;

    public ObjectParser(Element element) {
        super(element);
        this.setIsParsed(false);
        this.setMappedId(null);
        this.setAnnotations(new LinkedList<AnnotationParser>());
        this.setAttributes(new LinkedList<AttributeParser>());
        this.setPosAnnotations(0);
    }

    protected void setFigure(FigureWithID figureWithID) {
        this._figure = figureWithID;
    }

    protected FigureWithID figure() {
        return this._figure;
    }

    protected String getPNMLId() {
        return this._pnmlId;
    }

    protected void setPNMLId(String string) {
        this._pnmlId = string;
    }

    public Integer getMappedId() {
        return this._mappedId;
    }

    public void setMappedId(Integer n) {
        this._mappedId = n;
    }

    protected List<AnnotationParser> getAnnotations() {
        return this._annotation;
    }

    protected void setAnnotations(List<AnnotationParser> list) {
        this._annotation = list;
    }

    protected List<AttributeParser> getAttributes() {
        return this._attributes;
    }

    protected void setAttributes(List<AttributeParser> list) {
        this._attributes = list;
    }

    protected int getPosAnnotations() {
        return this._posAnnotation;
    }

    protected void setPosAnnotations(int n) {
        this._posAnnotation = n;
    }

    public boolean isParsed() {
        return this._isParsed;
    }

    protected void setIsParsed(boolean bl) {
        this._isParsed = bl;
    }

    protected GraphicParser getGraphic() {
        return this._parser;
    }

    protected void setGraphic(GraphicParser graphicParser) {
        this._parser = graphicParser;
    }

    public boolean hasNumericId() {
        boolean bl = true;
        if (this.getMappedId() == null) {
            bl = false;
        }
        return bl;
    }

    protected void parseId() {
        this.setPNMLId(this.getElement().getAttribute("id"));
        try {
            this.setMappedId(new Integer(this.getPNMLId()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void parseGraphics() {
        NodeList nodeList = this.getElement().getChildNodes();
        Element element = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals("graphics")) continue;
            element = (Element)node;
            break;
        }
        GraphicParser graphicParser = new GraphicParser(element);
        graphicParser.parse();
        this.setGraphic(graphicParser);
    }

    private boolean isVirtual(Element element) {
        boolean bl = false;
        NodeList nodeList = element.getElementsByTagName("toolspecific");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList nodeList2;
            Element element2 = (Element)nodeList.item(i);
            if (!element2.getAttribute("tool").equals("renew") || (nodeList2 = element2.getElementsByTagName("virtual")).getLength() == 0) continue;
            bl = true;
        }
        return bl;
    }

    protected void parseLabels() {
        NodeList nodeList = this.getElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ElementParser elementParser;
            Element element;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            NetConverter netConverter = Converter.instance().getNetConverter();
            if (netConverter.isAnnotation(element = (Element)node) || netConverter.isInRenewAnnotation(element)) {
                if (this.isVirtual(element)) continue;
                elementParser = new AnnotationParser(element);
                elementParser.parse();
                this.getAnnotations().add((AnnotationParser)elementParser);
                continue;
            }
            if (!netConverter.isAttribute(element)) continue;
            elementParser = new AttributeParser(element);
            elementParser.parse();
            this.getAttributes().add((AttributeParser)elementParser);
        }
    }

    protected void parseFigure() {
    }

    @Override
    protected void doParse() {
        this.parseId();
        this.parseGraphics();
        this.parseLabels();
        this.parseFigure();
        this.setIsParsed(true);
    }

    protected abstract FigureWithID createObject();

    protected abstract void initGraphic();

    protected void doInitFigure() {
        this.initGraphic();
    }

    public FigureWithID getFigure() {
        if (!this.isParsed()) {
            this.parse();
        }
        this.setFigure(this.createObject());
        this.figure().setID(this.getMappedId().intValue());
        this.doInitFigure();
        FigureWithID figureWithID = this.figure();
        return figureWithID;
    }

    public boolean hasMoreAnnotations() {
        return this.getAnnotations().size() > this.getPosAnnotations();
    }

    public TextFigure nextAnnotation() {
        AnnotationParser annotationParser = this.getAnnotations().get(this.getPosAnnotations());
        TextFigure textFigure = annotationParser.getFigure();
        Point point = textFigure.displayBox().getLocation();
        textFigure.setParent((ParentFigure)this.figure());
        if (point.x != 0 || point.y != 0) {
            textFigure.moveBy(point.x, point.y);
        }
        this.setPosAnnotations(this.getPosAnnotations() + 1);
        return textFigure;
    }

    protected void moveObject(int n, int n2) {
        this.figure().moveBy(n, n2);
    }
}

