/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator;

import java.io.File;
import java.io.FileFilter;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class FileTreeNode
implements TreeNode {
    protected TreeNode _parent = null;
    protected Vector<TreeNode> _children = null;
    protected File _node;
    protected FileFilter _ff = null;
    protected boolean _bChildrenLoaded = false;

    public FileTreeNode(File file) {
        assert (file != null);
        this._node = file;
    }

    public FileTreeNode(File file, FileFilter fileFilter) {
        assert (file != null);
        this._node = file;
        this._ff = fileFilter;
    }

    public FileTreeNode(TreeNode treeNode, File file) {
        assert (file != null);
        this._parent = treeNode;
        this._node = file;
    }

    public FileTreeNode(TreeNode treeNode, File file, FileFilter fileFilter) {
        assert (file != null);
        this._parent = treeNode;
        this._node = file;
        this._ff = fileFilter;
    }

    public Enumeration<TreeNode> children() {
        if (!this._bChildrenLoaded) {
            this.reloadChildren();
        }
        return this._children.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return this._node.isDirectory();
    }

    @Override
    public TreeNode getChildAt(int n) {
        if (!this._bChildrenLoaded) {
            this.reloadChildren();
        }
        return this._children.elementAt(n);
    }

    @Override
    public int getChildCount() {
        if (!this._bChildrenLoaded) {
            this.reloadChildren();
        }
        return this._children != null ? this._children.size() : 0;
    }

    public void ensureCapacity(int n) {
        this._children.ensureCapacity(n);
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this._children.indexOf(treeNode);
    }

    @Override
    public TreeNode getParent() {
        return this._parent;
    }

    public TreeNode[] getPath() {
        LinkedList<FileTreeNode> linkedList = new LinkedList<FileTreeNode>();
        for (TreeNode treeNode = this; treeNode != null; treeNode = treeNode.getParent()) {
            linkedList.addFirst((FileTreeNode)treeNode);
        }
        return linkedList.toArray(new TreeNode[0]);
    }

    public boolean isChild(File file) {
        for (int i = 0; i < this._children.size(); ++i) {
            TreeNode treeNode = this._children.get(i);
            if (!(treeNode instanceof FileTreeNode) || !((FileTreeNode)treeNode).getFile().getPath().equals(file.getPath())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLeaf() {
        return !this._node.isDirectory();
    }

    public boolean exists() {
        return this._node.exists();
    }

    public boolean reloadChildren() {
        File[] fileArray;
        this._bChildrenLoaded = true;
        if (this._node.isDirectory() && (fileArray = this._node.listFiles(this._ff)) != null) {
            if (this._children == null) {
                this._children = new Vector(fileArray.length);
            } else {
                this._children.clear();
                this._children.ensureCapacity(fileArray.length);
            }
            if (fileArray.length > 0) {
                this.loadChildren(fileArray);
                return true;
            }
        }
        return false;
    }

    protected void loadChildren(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            this._children.add(new FileTreeNode(this, fileArray[i], this._ff));
        }
    }

    public File getFile() {
        return this._node;
    }

    public FileFilter getFilter() {
        return this._ff;
    }

    public File[] getChildFiles() {
        return this._ff == null ? this._node.listFiles() : this._node.listFiles(this._ff);
    }

    public String toString() {
        return this._node.getName();
    }

    public boolean invalidateChildren() {
        boolean bl;
        boolean bl2 = bl = this._children != null && this._children.size() > 0;
        if (this._children != null) {
            this._children.clear();
        }
        this._children = null;
        this._bChildrenLoaded = false;
        return bl;
    }

    public String getFileExtension() {
        String string = this._node.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(n);
    }
}

