/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator;

import de.renew.navigator.FileTreeNode;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class MutableFileTreeNode
extends FileTreeNode
implements MutableTreeNode {
    public MutableFileTreeNode(File file) {
        super(file);
        this.sortChildren();
    }

    public MutableFileTreeNode(File file, FileFilter fileFilter) {
        super(file, fileFilter);
        this.sortChildren();
    }

    public MutableFileTreeNode(FileTreeNode fileTreeNode, File file) {
        super(fileTreeNode, file);
        this.sortChildren();
    }

    public MutableFileTreeNode(FileTreeNode fileTreeNode, File file, FileFilter fileFilter) {
        super(fileTreeNode, file, fileFilter);
        this.sortChildren();
    }

    @Override
    public void insert(MutableTreeNode mutableTreeNode, int n) {
        this._children.add(n, mutableTreeNode);
        this.sortChildren();
    }

    @Override
    public void remove(int n) {
        this._children.remove(n);
    }

    @Override
    public void remove(MutableTreeNode mutableTreeNode) {
        this._children.remove(mutableTreeNode);
    }

    @Override
    public void removeFromParent() {
        if (this._parent != null && this._parent instanceof MutableTreeNode) {
            ((MutableTreeNode)this._parent).remove(this);
        }
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        this._parent = mutableTreeNode;
    }

    @Override
    public void setUserObject(Object object) {
    }

    @Override
    protected void loadChildren(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            this._children.add(new MutableFileTreeNode(this, fileArray[i], this._ff));
        }
    }

    private synchronized void sortChildren() {
        if (this.reloadChildren() && this._children != null) {
            Collections.sort(this._children, new Comparator<TreeNode>(){

                @Override
                public int compare(TreeNode treeNode, TreeNode treeNode2) {
                    return treeNode.toString().compareToIgnoreCase(treeNode2.toString());
                }
            });
        }
    }
}

