/*
 * Decompiled with CFR 0.152.
 */
package de.renew.mxml;

import de.renew.mxml.MXMLCommandCenter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MXMLHelper {
    private StringBuilder attributes;
    private StringBuilder data;
    private Date date;
    private String originator;
    private SimpleDateFormat form;
    private String defaultHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><!-- MXML version 1.0 --><!-- This is a process event log created to be analyzed by ProM. When analyzing please discard the events of type \"ignore\"--><!-- ProM is the process mining framework. It can be freely obtained at http://www.processmining.org/. --><WorkflowLog xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://is.tm.tue.nl/research/processmining/WorkflowLog.xsd\" description=\"PAOSE Workflow log\"><Source program=\"Renew Mulan\"/>";
    private String processInstanceDefaultHeader = this.defaultHeader + "<Process id=\"DEFAULT\" description=\"Default process\">";
    private String auditTrailDefaultHeader = this.processInstanceDefaultHeader + "<ProcessInstance id=\"DEFAULT\" description=\"Default process instance\">";

    public MXMLHelper() {
        this.attributes = new StringBuilder();
        this.data = new StringBuilder();
        this.data.append("<Data>");
        this.data.append("</Data>");
        this.date = new Date();
        MXMLCommandCenter mXMLCommandCenter = MXMLCommandCenter.getInstance();
        this.originator = mXMLCommandCenter.getUserName();
        this.form = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    }

    public void addAttribute(String string, String string2) {
        String string3 = "<Attribute name=\"" + string + "\">" + string2 + "</Attribute>";
        this.attributes.append(string3);
    }

    public String generateAudiTrail(String string, String string2) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(MXMLCommandCenter.FILE));
            String string3 = bufferedReader.readLine();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<AuditTrailEntry>");
            if (this.attributes.length() > 0) {
                this.data.insert(6, this.attributes);
                stringBuilder.append((CharSequence)this.data);
            }
            stringBuilder.append("<WorkflowModelElement>" + string + "</WorkflowModelElement>");
            stringBuilder.append("<EventType>" + string2 + "</EventType>");
            String string4 = this.form.format(this.date);
            stringBuilder.append("<Timestamp>" + string4 + "</Timestamp>");
            stringBuilder.append("<Originator>" + this.originator + "</Originator>");
            stringBuilder.append("</AuditTrailEntry>\n");
            if (string3 == null) {
                stringBuilder.insert(0, this.auditTrailDefaultHeader);
                System.out.println("INFO: New log file generated");
            }
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            MXMLCommandCenter.lockEnvironment();
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return "";
        }
    }

    public String generateProcessInstance(String string, String string2) {
        BufferedReader bufferedReader = null;
        try {
            String string3 = "";
            bufferedReader = new BufferedReader(new FileReader(MXMLCommandCenter.FILE));
            String string4 = bufferedReader.readLine();
            if (string4 == null) {
                string3 = this.processInstanceDefaultHeader + "<ProcessInstance id=\"";
                System.out.println("INFO: New log file generated");
            } else {
                string3 = "</ProcessInstance><ProcessInstance id=\"";
                System.out.println("INFO: Log file updated");
            }
            string3 = string3 + string + "\" description=\"" + string2 + "\">";
            if (this.attributes.length() > 0) {
                this.data.insert(6, this.attributes);
                string3 = string3 + this.data;
            }
            bufferedReader.close();
            return string3;
        }
        catch (IOException iOException) {
            MXMLCommandCenter.lockEnvironment();
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return "";
        }
    }

    public String generateProcess(String string, String string2) {
        BufferedReader bufferedReader = null;
        try {
            String string3 = "";
            bufferedReader = new BufferedReader(new FileReader(MXMLCommandCenter.FILE));
            String string4 = bufferedReader.readLine();
            if (string4 == null) {
                string3 = this.defaultHeader + "<ProcessInstance id=\"";
                System.out.println("INFO: New log file generated");
            } else {
                string3 = "</Process><Process id=\"";
                System.out.println("INFO: Log file updated");
            }
            string3 = string3 + string + "\" description=\"" + string2 + "\">";
            if (this.attributes.length() > 0) {
                this.data.insert(6, this.attributes);
                string3 = string3 + this.data;
            }
            bufferedReader.close();
            return string3;
        }
        catch (IOException iOException) {
            MXMLCommandCenter.lockEnvironment();
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return "";
        }
    }
}

