/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.IPlugin;
import de.renew.plugin.IPluginManagerListener;
import de.renew.plugin.PluginManager;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class ApplicationTracker
implements IPluginManagerListener {
    public static Logger logger = Logger.getLogger(ApplicationTracker.class);
    protected String requiredService;
    protected Collection<IPlugin> applicationList;
    private PluginManager mgr;

    public ApplicationTracker(String string) {
        this.requiredService = string;
        this.applicationList = new ArrayList<IPlugin>();
        this.mgr = PluginManager.getInstance();
    }

    public void open() {
        this.mgr.addPluginManagerListener(this);
        this.bindServices(this.mgr.getPluginsRequiring(this.requiredService));
    }

    public synchronized void close() {
        this.mgr.removePluginManagerListener(this);
        this.unbindServices(this.mgr.getPluginsRequiring(this.requiredService));
    }

    private void bindServices(Collection<IPlugin> collection) {
        if (collection != null) {
            for (IPlugin iPlugin : collection) {
                this.bindService(iPlugin);
            }
        }
    }

    private void unbindServices(Collection<IPlugin> collection) {
        for (IPlugin iPlugin : collection) {
            this.unbindService(iPlugin);
        }
        assert (this.applicationList.isEmpty()) : "There is a difference between the \nlist of plugins requiring " + this.requiredService + " of the plugin manager and " + "the application service tracker (" + this + ").\n" + "[Tracked required service: " + this.requiredService + "]." + "\nRemaining plugins : " + this.applicationList + ".";
    }

    protected void bindService(IPlugin iPlugin) {
        if (iPlugin != null && iPlugin.getProperties().getRequirements().contains(this.requiredService)) {
            this.applicationList.add(iPlugin);
        }
    }

    protected void unbindService(IPlugin iPlugin) {
        if (iPlugin != null && this.applicationList.contains(iPlugin)) {
            this.applicationList.remove(iPlugin);
        }
    }

    @Override
    public synchronized void serviceAdded(String string, IPlugin iPlugin) {
        if (iPlugin != null) {
            this.bindService(iPlugin);
        }
    }

    @Override
    public synchronized void serviceRemoved(String string, IPlugin iPlugin) {
        if (iPlugin != null) {
            this.unbindService(iPlugin);
        }
    }
}

