/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.load.SimplePluginLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;

public class PluginAdapter
implements IPlugin {
    public static Logger logger = Logger.getLogger(PluginAdapter.class);
    protected PluginProperties _properties;

    public PluginAdapter(URL uRL) throws PluginException {
        PluginProperties pluginProperties = new PluginProperties(uRL);
        try {
            InputStream inputStream = SimplePluginLoader.PluginConfigFinder.getConfigInputStream(uRL);
            pluginProperties.load(inputStream);
            inputStream.close();
        }
        catch (MalformedURLException malformedURLException) {
            throw new PluginException("PluginAdapter constructor: trying to find properties", malformedURLException);
        }
        catch (IOException iOException) {
            throw new PluginException("PluginAdapter constructor: trying to read properties", iOException);
        }
        this._properties = pluginProperties;
    }

    public PluginAdapter(PluginProperties pluginProperties) {
        this._properties = pluginProperties;
    }

    @Override
    public String getName() {
        return this.getProperties().getProperty("name");
    }

    @Override
    public String getAlias() {
        return this.getProperties().getProperty("alias");
    }

    public String toString() {
        return "plugin " + this.getName();
    }

    @Override
    public void init() {
        logger.debug((Object)(this.toString() + ": (default) init method called."));
    }

    @Override
    public boolean cleanup() {
        logger.debug((Object)(this.toString() + ": (default) cleanup method called."));
        return true;
    }

    @Override
    public boolean canShutDown() {
        logger.debug((Object)(this.toString() + ": (default) canShutDown method called."));
        return true;
    }

    @Override
    public PluginProperties getProperties() {
        return this._properties;
    }

    protected void registerExitBlock() {
        logger.debug((Object)(this.toString() + " blocking exit."));
        PluginManager.getInstance().blockExit(this);
    }

    protected void registerExitOk() {
        logger.debug((Object)(this.toString() + " releasing exit block."));
        PluginManager.getInstance().exitOk(this);
    }

    public String getLongVersion() {
        String string = "";
        PluginProperties pluginProperties = this.getProperties();
        if (pluginProperties.containsKey("version")) {
            String string2;
            String string3 = pluginProperties.getProperty("versionText");
            if (string3 == null) {
                string3 = "Version: ";
            }
            if ((string2 = pluginProperties.getProperty("versionDate")) == null) {
                string2 = "no date set";
            }
            string = string3 + " " + this.getVersion() + "! Date: " + string2;
        }
        return string;
    }

    @Override
    public String getVersion() {
        String string = "";
        PluginProperties pluginProperties = this.getProperties();
        if (pluginProperties.containsKey("version")) {
            string = this.getProperties().getProperty("version");
        }
        return string;
    }

    @Override
    public void startUpComplete() {
    }
}

