/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.ClassLoaderManager;
import de.renew.plugin.CollectionLister;
import de.renew.plugin.DefaultClassLoaderManager;
import de.renew.plugin.DefaultLogStrategy;
import de.renew.plugin.DependencyCheckList;
import de.renew.plugin.DependencyNotFulfilledException;
import de.renew.plugin.IPlugin;
import de.renew.plugin.IPluginManagerListener;
import de.renew.plugin.Loader;
import de.renew.plugin.LogStrategy;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginClassLoader;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.PropertyHelper;
import de.renew.plugin.command.CLCommand;
import de.renew.plugin.command.ExitCommand;
import de.renew.plugin.command.GCCommand;
import de.renew.plugin.command.GetPropertyCommand;
import de.renew.plugin.command.InfoCommand;
import de.renew.plugin.command.ListCommand;
import de.renew.plugin.command.LoadCommand;
import de.renew.plugin.command.NoOpCommand;
import de.renew.plugin.command.ScriptCommand;
import de.renew.plugin.command.SetPropertyCommand;
import de.renew.plugin.command.SleepCommand;
import de.renew.plugin.command.UnloadCommand;
import de.renew.plugin.load.PluginLoaderComposition;
import de.renew.plugin.load.SimplePluginLoader;
import de.renew.plugin.locate.PluginJarLocationFinder;
import de.renew.plugin.locate.PluginLocationFinders;
import de.renew.plugin.locate.PluginSubDirFinder;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PluginManager
implements Serializable {
    public static final String COMMAND_SEPERATOR = "---";
    public static Logger logger = Logger.getLogger(PluginManager.class);
    public static final int CLEANUP_TIMEOUT = 20000;
    public static final String PLUGIN_LOCATIONS_PROPERTY = "pluginLocations";
    protected static PluginManager _instance;
    DependencyCheckList<IPlugin> _dependencyList = new DependencyCheckList();
    private Map<String, CLCommand> _commands = Collections.synchronizedMap(new TreeMap());
    private Set<IPluginManagerListener> _managerListener;
    private Set<IPlugin> _blockers = Collections.synchronizedSet(new HashSet());
    private boolean _Terminating = false;
    protected PluginLocationFinders _locationFinder = PluginLocationFinders.getInstance();
    protected PluginLoaderComposition _loader = new PluginLoaderComposition();
    private ClassLoaderManager _classLoaderManager;
    protected static URL _loaderLocation;
    private LogStrategy _logStrategy;
    private static final String PREF_DIR = ".renew";

    public static URL getLoaderLocation() {
        if (_loaderLocation == null) {
            _loaderLocation = PluginManager.getDefaultLoaderLocation();
        }
        return _loaderLocation;
    }

    private static URL getDefaultLoaderLocation() {
        URL uRL = Loader.class.getProtectionDomain().getCodeSource().getLocation();
        String string = uRL.toExternalForm();
        string = string.substring(0, string.lastIndexOf("/"));
        try {
            return new URL(string + "/");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    private static LogStrategy getDefaultLogStrategy() {
        return new DefaultLogStrategy();
    }

    private static ClassLoaderManager getDefaultClassLoaderManager() {
        return new DefaultClassLoaderManager();
    }

    protected PluginManager(URL uRL, LogStrategy logStrategy, ClassLoaderManager classLoaderManager) {
        if (logStrategy == null) {
            logStrategy = PluginManager.getDefaultLogStrategy();
        }
        this._logStrategy = logStrategy;
        if (classLoaderManager == null) {
            classLoaderManager = PluginManager.getDefaultClassLoaderManager();
        }
        this._classLoaderManager = classLoaderManager;
        this._logStrategy.configureLogging();
        this._classLoaderManager.initClassLoaders();
        this._managerListener = new HashSet<IPluginManagerListener>();
        this.initLocationFinders();
        this._loader = new PluginLoaderComposition();
        this._loader.addLoader(new SimplePluginLoader());
        this._commands.put("", new NoOpCommand());
        this._commands.put("help", new HelpCommand());
        this._commands.put("exit", new ExitCommand());
        this._commands.put("load", new LoadCommand());
        this._commands.put("list", new ListCommand());
        this._commands.put("unload", new UnloadCommand());
        this._commands.put("info", new InfoCommand());
        this._commands.put("script", new ScriptCommand());
        this._commands.put("set", new SetPropertyCommand());
        this._commands.put("get", new GetPropertyCommand());
        this._commands.put("gc", new GCCommand());
        this._commands.put("packageCount", this._classLoaderManager.getPluginClassLoader().new PluginClassLoader.PackageCountCommand());
        this._commands.put("sleep", new SleepCommand());
    }

    public static synchronized PluginManager getInstance() {
        if (_instance == null) {
            PluginManager.createInstance(PluginManager.getDefaultLoaderLocation(), PluginManager.getDefaultLogStrategy(), PluginManager.getDefaultClassLoaderManager());
        }
        return _instance;
    }

    private static synchronized PluginManager createInstance(URL uRL, LogStrategy logStrategy, ClassLoaderManager classLoaderManager) {
        if (_instance != null) {
            throw new IllegalStateException("Cannot create PluginManager singleton, is already there.");
        }
        _instance = new PluginManager(uRL, logStrategy, classLoaderManager);
        _instance.initPlugins();
        return _instance;
    }

    public void addPluginManagerListener(IPluginManagerListener iPluginManagerListener) {
        this._managerListener.add(iPluginManagerListener);
    }

    public void removePluginManagerListener(IPluginManagerListener iPluginManagerListener) {
        this._managerListener.remove(iPluginManagerListener);
    }

    private void serviceAdded(Collection<String> collection, IPlugin iPlugin) {
        for (IPluginManagerListener iPluginManagerListener : this._managerListener) {
            for (String string : collection) {
                iPluginManagerListener.serviceAdded(string, iPlugin);
            }
        }
    }

    private void serviceRemoved(Collection<String> collection, IPlugin iPlugin) {
        for (IPluginManagerListener iPluginManagerListener : this._managerListener) {
            for (String string : collection) {
                iPluginManagerListener.serviceRemoved(string, iPlugin);
            }
        }
    }

    public void addPlugin(IPlugin iPlugin) throws DependencyNotFulfilledException {
        if (!this.checkDependenciesFulfilled(iPlugin)) {
            throw new DependencyNotFulfilledException("Cannot add " + iPlugin);
        }
        try {
            logger.debug((Object)("************ INITIALIZING " + iPlugin.getName() + " ********"));
            iPlugin.init();
            this._dependencyList.addElement(DependencyCheckList.DependencyElement.create(iPlugin));
            this.serviceAdded(iPlugin.getProperties().getProvisions(), iPlugin);
        }
        catch (RuntimeException runtimeException) {
            logger.error((Object)("PluginManager: adding of Plugin " + iPlugin + " failed: " + runtimeException));
            logger.debug((Object)runtimeException.toString(), (Throwable)runtimeException);
        }
        catch (LinkageError linkageError) {
            logger.error((Object)("PluginManager: adding of Plugin " + iPlugin + " failed: " + linkageError));
            logger.debug((Object)linkageError.toString(), (Throwable)linkageError);
        }
    }

    public synchronized boolean checkDependenciesFulfilled(PluginProperties pluginProperties) {
        return this._dependencyList.dependencyFulfilled(DependencyCheckList.DependencyElement.create(pluginProperties));
    }

    public synchronized boolean checkDependenciesFulfilled(IPlugin iPlugin) {
        return this._dependencyList.dependencyFulfilled(DependencyCheckList.DependencyElement.create(iPlugin));
    }

    public IPlugin getPluginByName(String string) {
        IPlugin iPlugin = null;
        logger.debug((Object)("PluginManager looking for " + string));
        List<IPlugin> list = this.getPlugins();
        for (int i = 0; i < list.size(); ++i) {
            IPlugin iPlugin2 = list.get(i);
            if (!iPlugin2.getName().equals(string)) continue;
            iPlugin = iPlugin2;
            break;
        }
        if (iPlugin == null) {
            iPlugin = this.getPluginByAlias(string);
        }
        return iPlugin;
    }

    public IPlugin getPluginByAlias(String string) {
        IPlugin iPlugin = null;
        logger.debug((Object)("PluginManager looking for " + string));
        List<IPlugin> list = this.getPlugins();
        for (int i = 0; i < list.size(); ++i) {
            IPlugin iPlugin2 = list.get(i);
            if (!string.equals(iPlugin2.getAlias())) continue;
            iPlugin = iPlugin2;
            break;
        }
        return iPlugin;
    }

    public Collection<IPlugin> getPluginsProviding(String string) {
        Vector<IPlugin> vector = new Vector<IPlugin>();
        for (IPlugin iPlugin : this.getPlugins()) {
            if (!iPlugin.getProperties().getProvisions().contains(string)) continue;
            vector.add(iPlugin);
        }
        return vector;
    }

    public Collection<IPlugin> getPluginsRequiring(String string) {
        Vector<IPlugin> vector = new Vector<IPlugin>();
        block0: for (IPlugin iPlugin : this.getPlugins()) {
            if (iPlugin.getProperties().getRequirements().contains(string)) {
                vector.add(iPlugin);
                continue;
            }
            for (String string2 : iPlugin.getProperties().getRequirements()) {
                if (!string2.startsWith(string)) continue;
                vector.add(iPlugin);
                continue block0;
            }
        }
        return vector;
    }

    public void initPlugins() {
        for (IPlugin iPlugin : this.getPlugins()) {
            logger.debug((Object)("initializing " + iPlugin.getName() + ", loaded from " + iPlugin.getClass().getClassLoader()));
            logger.debug((Object)("************ INITIALIZING " + iPlugin.getName() + " ********"));
            iPlugin.init();
            this.serviceAdded(iPlugin.getProperties().getProvisions(), iPlugin);
        }
    }

    public PluginClassLoader getPluginClassLoader() {
        return this._classLoaderManager.getPluginClassLoader();
    }

    public ClassLoader getBottomClassLoader() {
        return this._classLoaderManager.getBottomClassLoader();
    }

    public ClassLoader getNewBottomClassLoader() {
        return this._classLoaderManager.getNewBottomClassLoader();
    }

    public ClassLoader getSystemClassLoader() {
        return this._classLoaderManager.getSystemClassLoader();
    }

    PluginLoaderComposition getPluginLoader() {
        return this._loader;
    }

    public synchronized void loadPlugins() {
        this._loader.loadPlugins();
    }

    public synchronized IPlugin loadPlugin(URL uRL) {
        return this._loader.loadPluginFromURL(uRL);
    }

    public List<IPlugin> getPlugins() {
        return this._dependencyList.getFulfilledObjects();
    }

    public void addCLCommand(String string, CLCommand cLCommand) {
        this._commands.put(string, cLCommand);
    }

    public void removeCLCommand(String string) {
        this._commands.remove(string);
    }

    public Map<String, CLCommand> getCLCommands() {
        return this._commands;
    }

    public void blockExit(IPlugin iPlugin) {
        if (iPlugin != null) {
            logger.debug((Object)("PluginManager: registering exit blocker " + iPlugin));
            this._blockers.add(iPlugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitOk(IPlugin iPlugin) {
        Set<IPlugin> set = this._blockers;
        synchronized (set) {
            if (iPlugin != null) {
                logger.debug((Object)("PluginManager: unregistering exit blocker " + iPlugin));
                this._blockers.remove(iPlugin);
            }
            this.checkExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkExit() {
        Set<IPlugin> set = this._blockers;
        synchronized (set) {
            if (this._blockers.isEmpty()) {
                logger.debug((Object)"PluginManager: no active plugins, shutting down.");
                this.stop();
                return true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Active plugins blocking exit: " + CollectionLister.toString(this._blockers)));
            }
        }
        return false;
    }

    public void stop() {
        logger.debug((Object)"Initiating PluginManager termination.");
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (PluginManager.this.stopSynchronized()) {
                    System.exit(0);
                }
            }
        };
        thread.start();
    }

    public void stop(final IPlugin iPlugin) {
        logger.debug((Object)("Initiating termination of " + iPlugin + "."));
        Thread thread = new Thread(){

            @Override
            public void run() {
                PluginManager.this.stopSynchronized(iPlugin);
            }
        };
        thread.start();
    }

    public void stop(final List<IPlugin> list) {
        logger.debug((Object)("Initiating termination of " + list + "."));
        Thread thread = new Thread(){

            @Override
            public void run() {
                PluginManager.this.stopSynchronized(list);
            }
        };
        thread.start();
    }

    public boolean isStopping() {
        return this._Terminating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean stopSynchronized() {
        logger.debug((Object)"Stopping plugin system asynchronously.");
        this._Terminating = true;
        try {
            List<IPlugin> list = this._dependencyList.getFulfilledObjects();
            boolean bl = this.stopSynchronized(list);
            return bl;
        }
        finally {
            this._Terminating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean stopSynchronized(List<IPlugin> list) {
        IPlugin iPlugin;
        int n;
        for (n = list.size() - 1; n >= 0; --n) {
            SynchronizedThread synchronizedThread;
            block22: {
                int n2;
                iPlugin = list.get(n);
                Object object = new Object();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Preparing stop of " + iPlugin));
                }
                int n3 = n2 = iPlugin.getProperties().getIntProperty("cleanupTimeout", 20000);
                int n4 = 1;
                if (n2 > 10) {
                    n3 = n2 / 10;
                    n4 = n2 - n3;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("canShutDown timeout is " + n2 + " milliseconds (" + n3 + "/" + n4 + ")."));
                }
                synchronizedThread = new SynchronizedThread(new Command(){

                    @Override
                    public boolean execute() {
                        return iPlugin.canShutDown();
                    }
                }, object);
                try {
                    synchronizedThread.start();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Started canShutDown thread, synching on " + object));
                    }
                    Object object2 = object;
                    synchronized (object2) {
                        if (!synchronizedThread.didFinish()) {
                            if (n2 == -1) {
                                if (logger.isTraceEnabled()) {
                                    logger.trace((Object)("Waiting (unlimited) for canShutDown thread to finish, synched on " + object));
                                }
                                object.wait();
                            } else {
                                if (logger.isTraceEnabled()) {
                                    logger.trace((Object)("Waiting (first part) for canShutDown thread to finish, synched on " + object));
                                }
                                object.wait(n3);
                                if (!synchronizedThread.didFinish()) {
                                    logger.info((Object)("Waiting for " + iPlugin + " to confirm termination..."));
                                    object.wait(n4);
                                }
                                if (logger.isTraceEnabled()) {
                                    logger.trace((Object)("Done waiting, canShutDown thread " + (synchronizedThread.didFinish() ? "finished" : "did not finish") + ", synched on " + object));
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!logger.isTraceEnabled()) break block22;
                    logger.trace((Object)("Interrupted timeout waiting on " + object));
                }
            }
            if (!synchronizedThread.hadSuccess()) {
                logger.warn((Object)(iPlugin + " did not confirm termination in time."));
                return false;
            }
            if (!synchronizedThread.hadSuccess()) {
                logger.warn((Object)(iPlugin + " said it cannot shut down."));
                return false;
            }
            logger.debug((Object)(iPlugin + " said it can shut down."));
        }
        for (n = list.size() - 1; n >= 0; --n) {
            iPlugin = list.get(n);
            try {
                this._dependencyList.removeElement(iPlugin);
            }
            catch (DependencyNotFulfilledException dependencyNotFulfilledException) {
                logger.error((Object)dependencyNotFulfilledException.getMessage());
                logger.error((Object)"list of dependent plugins:");
                logger.error((Object)CollectionLister.toString(dependencyNotFulfilledException.getElements()));
                return false;
            }
            if (this.stopSynchronized(iPlugin)) continue;
            logger.warn((Object)("stop cancelled by plugin " + iPlugin));
            this._dependencyList.addElement(DependencyCheckList.DependencyElement.create(iPlugin));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean stopSynchronized(final IPlugin iPlugin) {
        DependencyCheckList<IPlugin> dependencyCheckList;
        PluginAdapter pluginAdapter;
        SynchronizedThread synchronizedThread;
        block24: {
            try {
                DependencyCheckList<IPlugin> dependencyCheckList2 = this._dependencyList;
                synchronized (dependencyCheckList2) {
                    this._dependencyList.removeElement(iPlugin);
                }
            }
            catch (DependencyNotFulfilledException dependencyNotFulfilledException) {
                logger.error((Object)dependencyNotFulfilledException.getMessage());
                logger.error((Object)"list of dependent plugins:");
                logger.error((Object)CollectionLister.toString(dependencyNotFulfilledException.getElements()));
                return false;
            }
            logger.debug((Object)("stopping " + iPlugin));
            DependencyCheckList<IPlugin> dependencyCheckList3 = new DependencyCheckList<IPlugin>();
            int n = iPlugin.getProperties().getIntProperty("cleanupTimeout", 20000);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Cleanup timeout is " + n + " milliseconds."));
            }
            synchronizedThread = new SynchronizedThread(new Command(){

                @Override
                public boolean execute() {
                    return iPlugin.cleanup();
                }
            }, dependencyCheckList3);
            pluginAdapter = new PluginAdapter(PluginProperties.getUserProperties());
            this._blockers.add(pluginAdapter);
            try {
                synchronizedThread.start();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Started cleanup thread, synching on " + dependencyCheckList3));
                }
                dependencyCheckList = dependencyCheckList3;
                synchronized (dependencyCheckList) {
                    if (!synchronizedThread.didFinish()) {
                        if (n == -1) {
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)("Waiting (unlimited) for cleanup thread to finish, synched on " + dependencyCheckList3));
                            }
                            dependencyCheckList3.wait();
                        } else {
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)("Waiting for cleanup thread to finish, synched on " + dependencyCheckList3));
                            }
                            dependencyCheckList3.wait(n);
                        }
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Done waiting, cleanup thread " + (synchronizedThread.didFinish() ? "finished" : "did not finish") + ", synched on " + dependencyCheckList3));
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                if (!logger.isTraceEnabled()) break block24;
                logger.trace((Object)("Interrupted timeout waiting on " + dependencyCheckList3));
            }
        }
        this._blockers.remove(pluginAdapter);
        logger.debug((Object)(iPlugin + " stopped"));
        boolean bl = synchronizedThread.hadSuccess();
        if (!bl) {
            dependencyCheckList = this._dependencyList;
            synchronized (dependencyCheckList) {
                this._dependencyList.addElement(DependencyCheckList.DependencyElement.create(iPlugin));
            }
        } else {
            this.serviceRemoved(iPlugin.getProperties().getProvisions(), iPlugin);
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        PluginManager.main(stringArray, null);
    }

    public static void main(String[] stringArray, URL uRL) {
        PluginManager.main(stringArray, uRL, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray, URL uRL, LogStrategy logStrategy, ClassLoaderManager classLoaderManager) {
        for (String object : stringArray) {
            System.out.println(object);
        }
        if (uRL != null) {
            _loaderLocation = uRL;
        }
        PluginManager pluginManager = PluginManager.createInstance(uRL, logStrategy, classLoaderManager);
        Thread.currentThread().setContextClassLoader(pluginManager.getBottomClassLoader());
        pluginManager.loadPlugins();
        for (IPlugin iPlugin : pluginManager.getPlugins()) {
            iPlugin.startUpComplete();
            logger.info((Object)("loaded plugin: " + iPlugin.getName()));
        }
        if (stringArray.length > 0) {
            String[] stringArray2;
            ArrayList arrayList = new ArrayList();
            arrayList.add(new ArrayList());
            for (int i = 0; i < stringArray.length; ++i) {
                void var7_13;
                String string = stringArray[i];
                if (string.equals(COMMAND_SEPERATOR)) {
                    arrayList.add(new ArrayList());
                    continue;
                }
                if (string.matches("^\\s*$")) continue;
                while (var7_13.contains(COMMAND_SEPERATOR)) {
                    int n = var7_13.indexOf(COMMAND_SEPERATOR);
                    stringArray2 = var7_13.substring(0, n);
                    String string2 = var7_13.substring(n + COMMAND_SEPERATOR.length());
                    ((List)arrayList.get(arrayList.size() - 1)).add(stringArray2);
                    arrayList.add(new ArrayList());
                    String string3 = string2;
                }
                ((List)arrayList.get(arrayList.size() - 1)).add(var7_13);
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                if (list.size() == 0) continue;
                CLCommand cLCommand = pluginManager._commands.get(list.get(0));
                if (cLCommand == null) {
                    for (String string2 : list) {
                        System.out.println("#" + string2 + "#");
                    }
                    logger.warn((Object)("Unknown initial command (ignored): " + list));
                    continue;
                }
                list.remove(0);
                stringArray2 = new String[list.size()];
                stringArray2 = list.toArray(stringArray2);
                logger.debug((Object)("Executing initial command: " + list));
                cLCommand.execute(stringArray2, System.out);
            }
        }
        pluginManager.checkExit();
    }

    public static synchronized void configureLogging() {
        if (_instance != null) {
            PluginManager._instance._logStrategy.configureLogging();
        } else {
            PluginManager.getDefaultLogStrategy().configureLogging();
        }
    }

    private void initLocationFinders() {
        URL uRL = PluginManager.getLoaderLocation();
        try {
            uRL = new URL(uRL, "plugins/");
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)("Could not deduce plugins directory near plugin loader: " + malformedURLException));
            try {
                uRL = new URL(new File(System.getProperty("user.dir")).toURI().toURL(), "plugins/");
            }
            catch (MalformedURLException malformedURLException2) {
                logger.error((Object)("Could not deduce plugins directory near current directory: " + malformedURLException2));
                return;
            }
        }
        this._locationFinder.addLocationFinder(new PluginSubDirFinder(uRL));
        this._locationFinder.addLocationFinder(new PluginJarLocationFinder(uRL));
        Iterator<URL> iterator = this.getLocations();
        while (iterator.hasNext()) {
            uRL = iterator.next();
            this._locationFinder.addLocationFinder(new PluginSubDirFinder(uRL));
            this._locationFinder.addLocationFinder(new PluginJarLocationFinder(uRL));
        }
    }

    private Iterator<URL> getLocations() {
        Vector<URL> vector = new Vector<URL>();
        PluginProperties pluginProperties = PluginProperties.getUserProperties();
        if (pluginProperties.getProperty(PLUGIN_LOCATIONS_PROPERTY) == null) {
            logger.info((Object)"no additional plugin locations set.");
        }
        Collection<String> collection = PropertyHelper.parsePathListString(pluginProperties.getProperty(PLUGIN_LOCATIONS_PROPERTY, ""));
        for (String string : collection) {
            logger.debug((Object)("location: " + string));
            URL uRL = this.createURLfromString(string);
            logger.debug((Object)("as URL: " + uRL));
            vector.add(uRL);
        }
        return vector.iterator();
    }

    private URL createURLfromString(String string) {
        URL uRL = null;
        File file = new File(string);
        if (file.exists()) {
            try {
                uRL = file.toURI().toURL();
                return uRL;
            }
            catch (MalformedURLException malformedURLException) {
                logger.error((Object)malformedURLException.getMessage(), (Throwable)malformedURLException);
            }
        }
        try {
            uRL = new URI(string).toURL();
        }
        catch (URISyntaxException uRISyntaxException) {
            if (logger.isDebugEnabled()) {
                logger.warn((Object)("Neither file nor url: " + string + "(" + uRISyntaxException + ")"), (Throwable)uRISyntaxException);
            } else {
                logger.warn((Object)("Neither file nor url: " + string));
            }
        }
        catch (NullPointerException nullPointerException) {
            if (logger.isDebugEnabled()) {
                logger.warn((Object)("Neither file nor url: " + string + "(" + nullPointerException + ")"), (Throwable)nullPointerException);
            } else {
                logger.warn((Object)("Neither file nor url: " + string));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (logger.isDebugEnabled()) {
                logger.warn((Object)("Neither file nor url: " + string + "(" + illegalArgumentException + ")"), (Throwable)illegalArgumentException);
            } else {
                logger.warn((Object)("Neither file nor url: " + string));
            }
        }
        catch (MalformedURLException malformedURLException) {
            if (logger.isDebugEnabled()) {
                logger.warn((Object)("Neither file nor url: " + string + "(" + malformedURLException + ")"), (Throwable)malformedURLException);
            }
            logger.warn((Object)("Neither file nor url: " + string));
        }
        return uRL;
    }

    public URL[] getLibs() {
        URLClassLoader uRLClassLoader;
        try {
            uRLClassLoader = (URLClassLoader)this.getSystemClassLoader();
        }
        catch (ClassCastException classCastException) {
            logger.warn((Object)"Could not extract URL from SystemClassLoader, no URLClassLoader.", (Throwable)classCastException);
            return null;
        }
        return uRLClassLoader.getURLs();
    }

    public File getPreferencesLocation() {
        File file = new File(System.getProperty("user.home") + File.separator + PREF_DIR);
        if (!file.exists() && !file.mkdir()) {
            return null;
        }
        return file;
    }

    private static interface Command {
        public boolean execute();
    }

    private static class SynchronizedThread
    extends Thread {
        private boolean _success = false;
        private boolean _finished = false;
        private Object _toNotify;
        private Command _toExecute;

        public SynchronizedThread(Command command, Object object) {
            this._toExecute = command;
            this._toNotify = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this._success = this._toExecute.execute();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Execution finished: 1) synching on " + this._toNotify));
            }
            Object object = this._toNotify;
            synchronized (object) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Execution finished: 2) notifying on " + this._toNotify));
                }
                this._finished = true;
                this._toNotify.notify();
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Execution finished: 3) done on " + this._toNotify));
            }
        }

        public boolean hadSuccess() {
            return this._success;
        }

        public boolean didFinish() {
            return this._finished;
        }
    }

    public class HelpCommand
    implements CLCommand {
        @Override
        public void execute(String[] stringArray, PrintStream printStream) {
            printStream.println("usage: {command {args}* ---}*");
            printStream.println("available commands:");
            for (String string : PluginManager.this._commands.keySet()) {
                CLCommand cLCommand = (CLCommand)PluginManager.this._commands.get(string);
                printStream.println(string + "\t-\t" + cLCommand.getDescription());
            }
        }

        @Override
        public String getDescription() {
            return "print a list of all commands";
        }
    }
}

