/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.IPlugin;
import de.renew.plugin.IPluginManagerListener;
import de.renew.plugin.PluginManager;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class PluginServiceTracker
implements IPluginManagerListener {
    public static Logger logger = Logger.getLogger(PluginServiceTracker.class);
    private String providedService;
    protected Collection<IPlugin> providerList;
    private PluginManager mgr;

    public PluginServiceTracker(String string) {
        this.providedService = string;
        this.providerList = new ArrayList<IPlugin>();
        this.mgr = PluginManager.getInstance();
    }

    public void open() {
        this.mgr.addPluginManagerListener(this);
        this.bindServices(this.mgr.getPluginsProviding(this.providedService));
    }

    public void close() {
        this.mgr.removePluginManagerListener(this);
        this.unbindServices(this.mgr.getPluginsProviding(this.providedService));
    }

    private void bindServices(Collection<IPlugin> collection) {
        if (collection != null) {
            for (IPlugin iPlugin : collection) {
                this.bindService(iPlugin);
            }
        }
    }

    private void unbindServices(Collection<IPlugin> collection) {
        for (IPlugin iPlugin : collection) {
            this.unbindService(iPlugin);
        }
        assert (this.providerList.isEmpty()) : "There is a difference between\nthe provider list of the plugin manager and the plugin service tracker (" + this + ").\n[Tracked provider service: " + this.providedService + "]." + "\nRemaining plugins : " + this.providerList + ".";
    }

    protected void bindService(IPlugin iPlugin) {
        if (iPlugin != null && iPlugin.getProperties().getProvisions().contains(this.providedService)) {
            this.providerList.add(iPlugin);
        }
    }

    protected void unbindService(IPlugin iPlugin) {
        if (iPlugin != null && this.providerList.contains(iPlugin)) {
            this.providerList.remove(iPlugin);
        }
    }

    @Override
    public synchronized void serviceAdded(String string, IPlugin iPlugin) {
        if (iPlugin != null) {
            this.bindService(iPlugin);
        }
    }

    @Override
    public synchronized void serviceRemoved(String string, IPlugin iPlugin) {
        if (iPlugin != null) {
            this.unbindService(iPlugin);
        }
    }
}

